/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.DescReadBatchData;
import org.apache.iotdb.tsfile.read.common.DescReadWriteBatchData;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class SerializeUtilsTest {
    @Test
    public void serdesStringTest() {
        String str = "abcd%+/123\n\t";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serialize((String)str, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals((Object)str, (Object)SerializeUtils.deserializeString((ByteBuffer)buffer));
    }

    @Test
    public void serdesStringListTest() {
        List<String> slist = Arrays.asList("abc", "123", "y87@", "9+&d\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeStringList(slist, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals(slist, (Object)SerializeUtils.deserializeStringList((ByteBuffer)buffer));
    }

    @Test
    public void serdesIntListTest() {
        List<Integer> intlist = Arrays.asList(12, 34, 567, 8910);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeIntList(intlist, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        ArrayList anotherIntlist = new ArrayList();
        SerializeUtils.deserializeIntList(anotherIntlist, (ByteBuffer)buffer);
        Assert.assertEquals(intlist, anotherIntlist);
    }

    @Test
    public void serdesIntSetTest() {
        List<Integer> intlist = Arrays.asList(12, 34, 567, 8910);
        TreeSet<Integer> intSet = new TreeSet<Integer>(intlist);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeIntSet(intSet, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        TreeSet anotherIntlist = new TreeSet();
        SerializeUtils.deserializeIntSet(anotherIntlist, (ByteBuffer)buffer);
        Assert.assertEquals(intSet, anotherIntlist);
    }

    @Test
    public void serdesINT32BatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.INT32);
        int ivalue = 0;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)ivalue);
            ++ivalue;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesINT64BatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.INT64);
        long lvalue = 0L;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)lvalue);
            ++lvalue;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesFLOATBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.FLOAT);
        float fvalue = 0.0f;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)Float.valueOf(fvalue));
            fvalue += 1.0f;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesDOUBLEBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.DOUBLE);
        double dvalue = 0.0;
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)dvalue);
            dvalue += 1.0;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesBOOLEANBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.BOOLEAN);
        batchData.putAnObject(1L, (Object)true);
        batchData.putAnObject(2L, (Object)false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesTEXTBatchDataTest() {
        BatchData batchData = new BatchData(TSDataType.TEXT);
        String svalue = "";
        for (long time = 0L; time < 10L; ++time) {
            batchData.putAnObject(time, (Object)Binary.valueOf((String)svalue));
            svalue = svalue + String.valueOf(time);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData anotherBatch = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        while (batchData.hasCurrent()) {
            Assert.assertEquals((Object)batchData.currentValue(), (Object)anotherBatch.currentValue());
            batchData.next();
            anotherBatch.next();
        }
    }

    @Test
    public void serdesTVPairTest() {
        ArrayList<TimeValuePair> TVPairs = new ArrayList<TimeValuePair>();
        TimeValuePair p1 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)true));
        TVPairs.add(p1);
        TimeValuePair p2 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)1));
        TVPairs.add(p2);
        TimeValuePair p3 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)1L));
        TVPairs.add(p3);
        TimeValuePair p4 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(1.0f)));
        TVPairs.add(p4);
        TimeValuePair p5 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)1.0));
        TVPairs.add(p5);
        TimeValuePair p6 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)Binary.valueOf((String)"a")));
        TVPairs.add(p6);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        for (TimeValuePair tv : TVPairs) {
            SerializeUtils.serializeTVPair((TimeValuePair)tv, (DataOutputStream)outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            Assert.assertEquals((Object)tv, (Object)SerializeUtils.deserializeTVPair((ByteBuffer)buffer));
            baos.reset();
        }
    }

    @Test
    public void serdesTVPairsTest() {
        ArrayList<List<TimeValuePair>> TVPairs = new ArrayList<List<TimeValuePair>>();
        TimeValuePair p1 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)true));
        TVPairs.add(Collections.singletonList(p1));
        TimeValuePair p2 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)1));
        TVPairs.add(Collections.singletonList(p2));
        TimeValuePair p3 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)1L));
        TVPairs.add(Collections.singletonList(p3));
        TimeValuePair p4 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(1.0f)));
        TVPairs.add(Collections.singletonList(p4));
        TimeValuePair p5 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)1.0));
        TVPairs.add(Collections.singletonList(p5));
        TimeValuePair p6 = new TimeValuePair(0L, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)Binary.valueOf((String)"a")));
        TVPairs.add(Collections.singletonList(p6));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        for (List list : TVPairs) {
            SerializeUtils.serializeTVPairs((List)list, (DataOutputStream)outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            Assert.assertEquals((Object)list, (Object)SerializeUtils.deserializeTVPairs((ByteBuffer)buffer));
            baos.reset();
        }
    }

    @Test
    public void serdesObjectTest() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeObject((Object)1, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals((Object)1, (Object)SerializeUtils.deserializeObject((ByteBuffer)buffer));
    }

    @Test
    public void serdesObjectsTest() {
        Object[] objects = new Object[]{1, "2", 3.0};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeObjects((Object[])objects, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertArrayEquals((Object[])objects, (Object[])SerializeUtils.deserializeObjects((ByteBuffer)buffer));
    }

    @Test
    public void serdesLongsTest() {
        long[] array = new long[]{1L, 10L, 100L, 1000L, 10000L};
        ByteBuffer buffer = SerializeUtils.serializeLongs((long[])array);
        Assert.assertArrayEquals((long[])array, (long[])SerializeUtils.deserializeLongs((ByteBuffer)buffer));
    }

    @Test
    public void descReadWriteBatchDataTest() {
        this.descReadWriteBatchDataSerializableTest(0);
        this.descReadWriteBatchDataSerializableTest(1);
        this.descReadWriteBatchDataSerializableTest(10);
        this.descReadWriteBatchDataSerializableTest(16);
        this.descReadWriteBatchDataSerializableTest(100);
        this.descReadWriteBatchDataSerializableTest(1000);
        this.descReadWriteBatchDataSerializableTest(1500);
    }

    @Test
    public void descReadBatchDataTest() {
        this.descReadBatchDataSerializableTest(0);
        this.descReadBatchDataSerializableTest(1);
        this.descReadBatchDataSerializableTest(10);
        this.descReadBatchDataSerializableTest(16);
        this.descReadBatchDataSerializableTest(100);
        this.descReadBatchDataSerializableTest(1000);
        this.descReadBatchDataSerializableTest(1500);
    }

    @Test
    public void batchDataTest() {
        this.batchDataSerializableTest(0);
        this.batchDataSerializableTest(1);
        this.batchDataSerializableTest(10);
        this.batchDataSerializableTest(16);
        this.batchDataSerializableTest(100);
        this.batchDataSerializableTest(1000);
        this.batchDataSerializableTest(1500);
    }

    private void descReadWriteBatchDataSerializableTest(int dataSize) {
        int i;
        double E = 1.0E-5;
        String debugMsg = "Data size: " + dataSize + ", Data type: ";
        TSDataType dataType = TSDataType.INT64;
        DescReadWriteBatchData data = new DescReadWriteBatchData(dataType);
        String fullMsg = debugMsg + dataType;
        for (int i2 = dataSize; i2 > 0; --i2) {
            data.putLong((long)i2, (long)i2);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getLongByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getLong());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.INT32;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putInt((long)i, i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getIntByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getInt());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.DOUBLE;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putDouble((long)i, (double)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getDoubleByIndex(i), (double)E);
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getDouble(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.FLOAT;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putFloat((long)i, (float)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getFloatByIndex(i), (double)E);
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getFloat(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.BOOLEAN;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putBoolean((long)i, i % 3 == 0);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)((i + 1) % 3 == 0 ? 1 : 0), (Object)data2.getBooleanByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)(i % 3 == 0 ? 1 : 0), (Object)data2.getBoolean());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.TEXT;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putBinary((long)i, Binary.valueOf((String)String.valueOf(i)));
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i + 1), (Object)data2.getBinaryByIndex(i).getStringValue());
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i), (Object)data2.getBinary().getStringValue());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.VECTOR;
        data = new DescReadWriteBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = dataSize; i > 0; --i) {
            data.putVector((long)i, new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))});
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadWriteBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)(i + 1)), new TsPrimitiveType.TsInt(i + 1), new TsPrimitiveType.TsDouble((double)(i + 1)), new TsPrimitiveType.TsFloat((float)(i + 1)), new TsPrimitiveType.TsBoolean((i + 1) % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i + 1)))}, (Object[])data2.getVectorByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))}, (Object[])data2.getVector());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
    }

    private void descReadBatchDataSerializableTest(int dataSize) {
        int i;
        double E = 1.0E-5;
        String debugMsg = "Data size: " + dataSize + ", Data type: ";
        TSDataType dataType = TSDataType.INT64;
        DescReadBatchData data = new DescReadBatchData(dataType);
        String fullMsg = debugMsg + dataType;
        for (int i2 = 1; i2 <= dataSize; ++i2) {
            data.putLong((long)i2, (long)i2);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getLongByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getLong());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.INT32;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putInt((long)i, i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getIntByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getInt());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.DOUBLE;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putDouble((long)i, (double)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getDoubleByIndex(i), (double)E);
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getDouble(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.FLOAT;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putFloat((long)i, (float)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getFloatByIndex(i), (double)E);
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getFloat(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.BOOLEAN;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putBoolean((long)i, i % 3 == 0);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)((i + 1) % 3 == 0 ? 1 : 0), (Object)data2.getBooleanByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)(i % 3 == 0 ? 1 : 0), (Object)data2.getBoolean());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.TEXT;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putBinary((long)i, Binary.valueOf((String)String.valueOf(i)));
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i + 1), (Object)data2.getBinaryByIndex(i).getStringValue());
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i), (Object)data2.getBinary().getStringValue());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.VECTOR;
        data = new DescReadBatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putVector((long)i, new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))});
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertTrue((String)fullMsg, (boolean)(data2 instanceof DescReadBatchData));
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)(i + 1)), new TsPrimitiveType.TsInt(i + 1), new TsPrimitiveType.TsDouble((double)(i + 1)), new TsPrimitiveType.TsFloat((float)(i + 1)), new TsPrimitiveType.TsBoolean((i + 1) % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i + 1)))}, (Object[])data2.getVectorByIndex(i));
        }
        for (i = dataSize; i > 0; --i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))}, (Object[])data2.getVector());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
    }

    private void batchDataSerializableTest(int dataSize) {
        int i;
        double E = 1.0E-5;
        String debugMsg = "Data size: " + dataSize + ", Data type: ";
        TSDataType dataType = TSDataType.INT64;
        BatchData data = new BatchData(dataType);
        String fullMsg = debugMsg + dataType;
        for (int i2 = 1; i2 <= dataSize; ++i2) {
            data.putLong((long)i2, (long)i2);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        BatchData data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getLongByIndex(i));
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getLong());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.INT32;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putInt((long)i, i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getIntByIndex(i));
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.getInt());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.DOUBLE;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putDouble((long)i, (double)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getDoubleByIndex(i), (double)E);
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getDouble(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.FLOAT;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putFloat((long)i, (float)i);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (double)(i + 1), (double)data2.getFloatByIndex(i), (double)E);
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (double)i, (double)data2.getFloat(), (double)E);
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.BOOLEAN;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putBoolean((long)i, i % 3 == 0);
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)((i + 1) % 3 == 0 ? 1 : 0), (Object)data2.getBooleanByIndex(i));
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)(i % 3 == 0 ? 1 : 0), (Object)data2.getBoolean());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.TEXT;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putBinary((long)i, Binary.valueOf((String)String.valueOf(i)));
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i + 1), (Object)data2.getBinaryByIndex(i).getStringValue());
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertEquals((String)fullMsg, (Object)String.valueOf(i), (Object)data2.getBinary().getStringValue());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
        dataType = TSDataType.VECTOR;
        data = new BatchData(dataType);
        fullMsg = debugMsg + dataType;
        for (i = 1; i <= dataSize; ++i) {
            data.putVector((long)i, new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))});
        }
        baos = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(baos);
        SerializeUtils.serializeBatchData((BatchData)data, (DataOutputStream)outputStream);
        buffer = ByteBuffer.wrap(baos.toByteArray());
        data2 = SerializeUtils.deserializeBatchData((ByteBuffer)buffer);
        Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.length());
        if (dataSize > 0) {
            Assert.assertEquals((String)fullMsg, (long)1L, (long)data2.getMinTimestamp());
            Assert.assertEquals((String)fullMsg, (long)dataSize, (long)data2.getMaxTimestamp());
        }
        for (i = 0; i < dataSize; ++i) {
            Assert.assertEquals((String)fullMsg, (long)(i + 1), (long)data2.getTimeByIndex(i));
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)(i + 1)), new TsPrimitiveType.TsInt(i + 1), new TsPrimitiveType.TsDouble((double)(i + 1)), new TsPrimitiveType.TsFloat((float)(i + 1)), new TsPrimitiveType.TsBoolean((i + 1) % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i + 1)))}, (Object[])data2.getVectorByIndex(i));
        }
        for (i = 1; i <= dataSize; ++i) {
            Assert.assertTrue((String)fullMsg, (boolean)data2.hasCurrent());
            Assert.assertEquals((String)fullMsg, (long)i, (long)data2.currentTime());
            Assert.assertArrayEquals((String)fullMsg, (Object[])new TsPrimitiveType[]{new TsPrimitiveType.TsLong((long)i), new TsPrimitiveType.TsInt(i), new TsPrimitiveType.TsDouble((double)i), new TsPrimitiveType.TsFloat((float)i), new TsPrimitiveType.TsBoolean(i % 3 == 0), new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i)))}, (Object[])data2.getVector());
            data2.next();
        }
        Assert.assertFalse((String)fullMsg, (boolean)data2.hasCurrent());
    }
}

