/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.utils.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class MathQueryDataSetUtilsTest {
    @Test
    public void roundFloatWithGivenPrecision() {
        int[] size = new int[]{0, 4, 19};
        float[] data = new float[]{0.0f, (float)Math.PI, (float)(Math.PI * 10), 2.1474836E9f, -2.1474836E9f};
        float[][] expData = new float[][]{{0.0f, 3.0f, 31.0f, 2.1474836E9f, -2.1474836E9f}, {0.0f, 3.1416f, 31.4159f, 2.1474836E9f, -2.1474836E9f}, {0.0f, (float)Math.PI, (float)(Math.PI * 10), 2.1474836E9f, -2.1474836E9f}};
        for (int j = 0; j < size.length; ++j) {
            for (int i = 0; i < data.length; ++i) {
                float res = MathUtils.roundWithGivenPrecision((float)data[i], (int)size[j]);
                Assert.assertEquals((float)expData[j][i], (float)res, (float)Float.MIN_NORMAL);
            }
        }
    }

    @Test
    public void roundDoubleWithGivenPrecision() {
        int[] size = new int[]{0, 4, 19};
        double[] data = new double[]{0.0, Math.PI, Math.PI * 10, 9.223372036854776E18, -9.223372036854776E18};
        double[][] expData = new double[][]{{0.0, 3.0, 31.0, 9.223372036854776E18, -9.223372036854776E18}, {0.0, 3.1416, 31.4159, 9.223372036854776E18, -9.223372036854776E18}, {0.0, Math.PI, Math.PI * 10, 9.223372036854776E18, -9.223372036854776E18}};
        for (int j = 0; j < size.length; ++j) {
            for (int i = 0; i < data.length; ++i) {
                double res = MathUtils.roundWithGivenPrecision((double)data[i], (int)size[j]);
                Assert.assertEquals((double)expData[j][i], (double)res, (double)Double.MIN_NORMAL);
            }
        }
    }
}

