/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.tools.mlog.MLogParser;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MLogParserTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.deleteOnExit();
        file = new File("target" + File.separator + "tmp" + File.separator + "text.snapshot");
        file.deleteOnExit();
    }

    public void prepareData() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
                    try {
                        plan.setPath(new PartialPath("root.sg" + i + ".device" + j + ".s" + k));
                        plan.setDataType(TSDataType.INT32);
                        plan.setEncoding(TSEncoding.PLAIN);
                        plan.setCompressor(CompressionType.GZIP);
                        IoTDB.metaManager.createTimeseries(plan);
                        continue;
                    }
                    catch (MetadataException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.ln.cc"));
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.sgcc"));
            IoTDB.metaManager.setTTL(new PartialPath("root.sgcc"), 1234L);
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg1.device1.s1"));
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            paths.add(new PartialPath("root.ln.cc"));
            IoTDB.metaManager.deleteStorageGroups(paths);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag1", "value1");
            IoTDB.metaManager.addTags(tags, new PartialPath("root.sg1.device1.s2"));
            IoTDB.metaManager.changeAlias(new PartialPath("root.sg1.device1.s3"), "hello");
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
        }
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
            IoTDB.metaManager.createSchemaTemplate(this.genCreateSchemaTemplatePlan());
            SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg");
            IoTDB.metaManager.setSchemaTemplate(setTemplatePlan);
            IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg.d1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private CreateTemplatePlan genCreateSchemaTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        measurementList.add(Collections.singletonList("s12"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.DOUBLE));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s11");
        schemaNames.add("s12");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testParseMLog() throws IOException {
        this.prepareData();
        IoTDB.metaManager.flushAllMlogForTest();
        try {
            MLogParser.parseFromFile((String)(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mlog.bin"), (String)("target" + File.separator + "tmp" + File.separator + "text.mlog"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.mlog"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != 113) {
                for (String content : lines) {
                    System.out.println(content);
                }
            }
            Assert.assertEquals((long)113L, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseSnapshot() {
        this.prepareData();
        IoTDB.metaManager.createMTreeSnapshot();
        try {
            MLogParser.parseFromFile((String)(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mtree-1.snapshot.bin"), (String)("target" + File.separator + "tmp" + File.separator + "text.snapshot"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.snapshot"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != 115) {
                for (String content : lines) {
                    System.out.println(content);
                }
            }
            Assert.assertEquals((long)115L, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

