/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.tools.watermark.WatermarkDetector;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBWatermarkTest {
    private static String filePath1 = TestConstant.BASE_OUTPUT_PATH.concat("watermarked_query_result.csv");
    private static String filePath2 = TestConstant.BASE_OUTPUT_PATH.concat("notWatermarked_query_result.csv");
    private static PrintWriter writer1;
    private static PrintWriter writer2;
    private static String secretKey;
    private static String watermarkBitString;
    private static int embed_row_cycle;
    private static int embed_lsb_num;

    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setEnableWatermark(true);
        IoTDBDescriptor.getInstance().getConfig().setWatermarkSecretKey(secretKey);
        IoTDBDescriptor.getInstance().getConfig().setWatermarkBitString(watermarkBitString);
        IoTDBDescriptor.getInstance().getConfig().setWatermarkMethod(String.format("GroupBasedLSBMethod(embed_row_cycle=%d,embed_lsb_num=%d)", embed_row_cycle, embed_lsb_num));
        EnvironmentUtils.envSetUp();
        IoTDBWatermarkTest.insertData();
        File file1 = new File(filePath1);
        if (file1.exists()) {
            file1.delete();
        }
        writer1 = new PrintWriter(file1);
        writer1.println("time,root.vehicle.d0.s0,root.vehicle.d0.s1,root.vehicle.d0.s2");
        File file2 = new File(filePath2);
        if (file2.exists()) {
            file2.delete();
        }
        writer2 = new PrintWriter(file2);
        writer2.println("time,root.vehicle.d0.s0,root.vehicle.d0.s1,root.vehicle.d0.s2");
    }

    @After
    public void tearDown() throws Exception {
        File file2;
        File file1 = new File(filePath1);
        if (file1.exists()) {
            file1.delete();
        }
        if ((file2 = new File(filePath2)).exists()) {
            file2.delete();
        }
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] create_sql;
            for (String sql : create_sql = new String[]{"SET STORAGE GROUP TO root.vehicle", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE"}) {
                statement.execute(sql);
            }
            for (int time = 1; time < 1000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0,s2) values(%s,%s,%s)", time, time % 50, time % 50, time % 50);
                statement.execute(sql);
                if (time % 10 != 0) continue;
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 50);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void EncodeAndDecodeTest1() throws IOException, ClassNotFoundException, LogicalOperatorException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("GRANT WATERMARK_EMBEDDING TO root");
            boolean hasResultSet = statement.execute("SELECT s0,s1,s2 FROM root.vehicle.d0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0") + "," + resultSet.getString("root.vehicle.d0.s1") + "," + resultSet.getString("root.vehicle.d0.s2");
                    writer1.println(ans);
                }
                writer1.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        double alpha = 0.1;
        int columnIndex = 1;
        boolean isWatermarked = WatermarkDetector.isWatermarked((String)filePath1, (String)secretKey, (String)watermarkBitString, (int)embed_row_cycle, (int)embed_lsb_num, (double)alpha, (int)columnIndex, (String)"int");
        Assert.assertTrue((boolean)isWatermarked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void EncodeAndDecodeTest2() throws IOException, ClassNotFoundException, LogicalOperatorException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("REVOKE WATERMARK_EMBEDDING FROM root");
            boolean hasResultSet = statement.execute("SELECT s0,s1,s2 FROM root.vehicle.d0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0") + "," + resultSet.getString("root.vehicle.d0.s1") + "," + resultSet.getString("root.vehicle.d0.s2");
                    writer2.println(ans);
                }
                writer2.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        double alpha = 0.1;
        int columnIndex = 1;
        boolean isWatermarked = WatermarkDetector.isWatermarked((String)filePath2, (String)secretKey, (String)watermarkBitString, (int)embed_row_cycle, (int)embed_lsb_num, (double)alpha, (int)columnIndex, (String)"int");
        Assert.assertFalse((boolean)isWatermarked);
    }

    static {
        secretKey = "ASDFGHJKL";
        watermarkBitString = "10101000100";
        embed_row_cycle = 5;
        embed_lsb_num = 5;
    }
}

