/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.transfer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.transfer.ISyncClient;
import org.apache.iotdb.db.sync.sender.transfer.SyncClient;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientTest {
    private static final Logger logger = LoggerFactory.getLogger(SyncClientTest.class);
    private ISyncClient manager = SyncClient.getInstance();
    private SyncSenderConfig config = SyncSenderDescriptor.getInstance().getConfig();
    private String dataDir;
    private ISyncSenderLogAnalyzer senderLogAnalyzer;

    @Before
    public void setUp() throws DiskSpaceInsufficientException {
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.config.update(this.dataDir);
        this.senderLogAnalyzer = new SyncSenderLogAnalyzer(this.config.getSenderFolderPath());
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void makeFileSnapshot() throws IOException {
        void var7_15;
        HashMap<String, Map> allFileList = new HashMap<String, Map>();
        Random r = new Random(0L);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!allFileList.containsKey(String.valueOf(i))) {
                    allFileList.computeIfAbsent(String.valueOf(i), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                }
                String string = String.valueOf(r.nextInt(10000));
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + i + File.separator + "0" + File.separator + "0" + File.separator + string;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(String.valueOf(i))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    logger.error("Can not create new file {}", (Object)file.getPath());
                }
                if (new File(file.getAbsolutePath() + ".resource").exists() || new File(file.getAbsolutePath() + ".resource").createNewFile()) continue;
                logger.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        HashMap dataFileMap = new HashMap();
        File sequenceFile = new File(this.dataDir, "sequence");
        File[] fileArray = sequenceFile.listFiles();
        int n = fileArray.length;
        boolean bl = false;
        while (var7_15 < n) {
            File sgFile = fileArray[var7_15];
            dataFileMap.putIfAbsent(sgFile.getName(), new HashSet());
            for (File vgFile : sgFile.listFiles()) {
                for (File trFile : vgFile.listFiles()) {
                    for (File tsfile : trFile.listFiles()) {
                        if (!tsfile.getName().endsWith(".resource")) {
                            ((SyncClient)this.manager).makeFileSnapshot(tsfile);
                        }
                        ((Set)dataFileMap.get(sgFile.getName())).add(tsfile.getName());
                    }
                }
            }
            ++var7_15;
        }
        Assert.assertTrue((boolean)new File(this.config.getSenderFolderPath()).exists());
        Assert.assertTrue((boolean)new File(this.config.getSnapshotPath()).exists());
        HashMap hashMap = new HashMap();
        for (File sgFile : new File(this.config.getSnapshotPath()).listFiles()) {
            hashMap.putIfAbsent(sgFile.getName(), new HashSet());
            for (File vgFile : sgFile.listFiles()) {
                for (File trFile : vgFile.listFiles()) {
                    for (File snapshotTsfile : trFile.listFiles()) {
                        ((Set)hashMap.get(sgFile.getName())).add(snapshotTsfile.getName());
                    }
                }
            }
        }
        Assert.assertEquals((long)dataFileMap.size(), (long)hashMap.size());
        for (Map.Entry entry : dataFileMap.entrySet()) {
            String sg = (String)entry.getKey();
            Set tsfiles = (Set)entry.getValue();
            Assert.assertTrue((boolean)hashMap.containsKey(sg));
            Assert.assertEquals((long)((Set)hashMap.get(sg)).size(), (long)tsfiles.size());
            Assert.assertTrue((boolean)((Set)hashMap.get(sg)).containsAll(tsfiles));
        }
        Assert.assertFalse((boolean)new File(this.config.getLastFileInfoPath()).exists());
        this.senderLogAnalyzer.recover();
        Assert.assertFalse((boolean)new File(this.config.getSnapshotPath()).exists());
        Assert.assertTrue((boolean)new File(this.config.getLastFileInfoPath()).exists());
    }
}

