/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogger;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncSenderLoggerTest {
    private SyncSenderLogger senderLogger;
    private SyncSenderConfig config = SyncSenderDescriptor.getInstance().getConfig();
    private String dataDir;

    @Before
    public void setUp() throws IOException, InterruptedException, StartupException, DiskSpaceInsufficientException {
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.config.update(this.dataDir);
    }

    @After
    public void tearDown() throws InterruptedException, IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSyncSenderLogger() throws IOException {
        this.senderLogger = new SyncSenderLogger(new File(this.config.getSenderFolderPath(), "sync.log"));
        HashSet<String> deletedFileNames = new HashSet<String>();
        HashSet<String> deletedFileNamesTest = new HashSet<String>();
        this.senderLogger.startSyncDeletedFilesName();
        for (int i = 0; i < 100; ++i) {
            this.senderLogger.finishSyncDeletedFileName(new File(this.config.getSenderFolderPath(), "deleted" + i));
            deletedFileNames.add(new File(this.config.getSenderFolderPath(), "deleted" + i).getAbsolutePath());
        }
        HashSet<String> toBeSyncedFiles = new HashSet<String>();
        HashSet<String> toBeSyncedFilesTest = new HashSet<String>();
        this.senderLogger.startSyncTsFiles();
        for (int i = 0; i < 100; ++i) {
            this.senderLogger.finishSyncTsfile(new File(this.config.getSenderFolderPath(), "new" + i));
            toBeSyncedFiles.add(new File(this.config.getSenderFolderPath(), "new" + i).getAbsolutePath());
        }
        this.senderLogger.close();
        int count = 0;
        int mode = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.config.getSenderFolderPath(), "sync.log")));){
            String line;
            while ((line = br.readLine()) != null) {
                ++count;
                if (line.equals("sync deleted file names start")) {
                    mode = -1;
                    continue;
                }
                if (line.equals("sync tsfile start")) {
                    mode = 1;
                    continue;
                }
                if (mode == -1) {
                    deletedFileNamesTest.add(line);
                    continue;
                }
                if (mode != 1) continue;
                toBeSyncedFilesTest.add(line);
            }
        }
        Assert.assertEquals((long)202L, (long)count);
        Assert.assertEquals((long)deletedFileNames.size(), (long)deletedFileNamesTest.size());
        Assert.assertEquals((long)toBeSyncedFiles.size(), (long)toBeSyncedFilesTest.size());
        Assert.assertTrue((boolean)deletedFileNames.containsAll(deletedFileNamesTest));
        Assert.assertTrue((boolean)toBeSyncedFiles.containsAll(toBeSyncedFilesTest));
    }
}

