/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recover;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.manage.ISyncFileManager;
import org.apache.iotdb.db.sync.sender.manage.SyncFileManager;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogger;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.recover.SyncSenderLogger;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SyncUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSenderLogAnalyzerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSenderLogAnalyzerTest.class);
    private ISyncSenderLogger senderLogger;
    private ISyncSenderLogAnalyzer senderLogAnalyzer;
    private ISyncFileManager manager = SyncFileManager.getInstance();
    private SyncSenderConfig config = SyncSenderDescriptor.getInstance().getConfig();
    private String dataDir;

    @Before
    public void setUp() throws IOException, InterruptedException, StartupException, DiskSpaceInsufficientException {
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
        this.config.update(this.dataDir);
        this.senderLogger = new SyncSenderLogger(new File(this.config.getSenderFolderPath(), "sync.log"));
        this.senderLogAnalyzer = new SyncSenderLogAnalyzer(this.config.getSenderFolderPath());
    }

    @After
    public void tearDown() throws InterruptedException, IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void recover() throws IOException, MetadataException {
        HashMap<String, Map<Long, Map<Long, Set<File>>>> allFileList = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        for (int i = 0; i < 3; ++i) {
            IoTDB.metaManager.setStorageGroup(new PartialPath(this.getSgName(i)));
        }
        Random r = new Random(0L);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                allFileList.computeIfAbsent(this.getSgName(i), k -> new HashMap()).computeIfAbsent(0L, k -> new HashMap()).computeIfAbsent(0L, k -> new HashSet());
                String rand = r.nextInt(10000) + ".tsfile";
                String fileName = FilePathUtils.regularizePath((String)this.dataDir) + "sequence" + File.separator + this.getSgName(i) + File.separator + "0" + File.separator + "0" + File.separator + (String)rand;
                File file = new File(fileName);
                ((Set)((Map)((Map)allFileList.get(this.getSgName(i))).get(0L)).get(0L)).add(file);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    LOGGER.error("Can not create new file {}", (Object)file.getPath());
                }
                if (new File(file.getAbsolutePath() + ".resource").exists() || new File(file.getAbsolutePath() + ".resource").createNewFile()) continue;
                LOGGER.error("Can not create new file {}", (Object)file.getPath());
            }
        }
        this.manager.getValidFiles(this.dataDir);
        Assert.assertTrue((boolean)SyncUtils.isEmpty((Map)this.manager.getLastLocalFilesMap()));
        this.senderLogger.startSyncTsFiles();
        for (Map map : allFileList.values()) {
            for (Map vgMap : map.values()) {
                for (Set newTsFiles : vgMap.values()) {
                    for (File file : newTsFiles) {
                        this.senderLogger.finishSyncTsfile(file);
                    }
                }
            }
        }
        this.senderLogger.close();
        this.senderLogAnalyzer.recover();
        this.manager.getValidFiles(this.dataDir);
        Assert.assertFalse((boolean)SyncUtils.isEmpty((Map)this.manager.getLastLocalFilesMap()));
        Map lastFilesMap = this.manager.getLastLocalFilesMap();
        this.assertFileMap(allFileList, lastFilesMap);
        Assert.assertFalse((boolean)new File(this.config.getSenderFolderPath(), "sync.log").exists());
        this.senderLogger = new SyncSenderLogger(new File(this.config.getSenderFolderPath(), "sync.log"));
        this.manager.getValidFiles(this.dataDir);
        Assert.assertFalse((boolean)SyncUtils.isEmpty((Map)this.manager.getLastLocalFilesMap()));
        this.senderLogger.startSyncDeletedFilesName();
        for (Map map : allFileList.values()) {
            for (Map vgMap : map.values()) {
                for (Set newTsFiles : vgMap.values()) {
                    for (File file : newTsFiles) {
                        this.senderLogger.finishSyncDeletedFileName(file);
                    }
                }
            }
        }
        this.senderLogger.close();
        this.senderLogAnalyzer.recover();
        this.manager.getValidFiles(this.dataDir);
        Assert.assertTrue((boolean)SyncUtils.isEmpty((Map)this.manager.getLastLocalFilesMap()));
        Assert.assertTrue((boolean)SyncUtils.isEmpty((Map)this.manager.getDeletedFilesMap()));
        Map toBeSyncedFilesMap = this.manager.getToBeSyncedFilesMap();
        this.assertFileMap(allFileList, toBeSyncedFilesMap);
    }

    private void assertFileMap(Map<String, Map<Long, Map<Long, Set<File>>>> correctMap, Map<String, Map<Long, Map<Long, Set<File>>>> curMap) {
        for (Map.Entry<String, Map<Long, Map<Long, Set<File>>>> entry : correctMap.entrySet()) {
            Assert.assertTrue((boolean)curMap.containsKey(entry.getKey()));
            for (Map.Entry<Long, Map<Long, Set<File>>> vgEntry : entry.getValue().entrySet()) {
                Assert.assertTrue((boolean)curMap.get(entry.getKey()).containsKey(vgEntry.getKey()));
                for (Map.Entry<Long, Set<File>> innerEntry : vgEntry.getValue().entrySet()) {
                    Assert.assertTrue((boolean)curMap.get(entry.getKey()).get(vgEntry.getKey()).get(innerEntry.getKey()).containsAll((Collection)innerEntry.getValue()));
                }
            }
        }
    }

    private String getSgName(int i) {
        return "root." + i;
    }

    private boolean isEmpty(Map<String, Set<File>> sendingFileList) {
        for (Map.Entry<String, Set<File>> entry : sendingFileList.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

