/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.sync.receiver.recover.ISyncReceiverLogger;
import org.apache.iotdb.db.sync.receiver.recover.SyncReceiverLogger;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncReceiverLoggerTest {
    private ISyncReceiverLogger receiverLogger;
    private String dataDir;

    @Before
    public void setUp() throws DiskSpaceInsufficientException {
        EnvironmentUtils.envSetUp();
        this.dataDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile()).getParentFile().getAbsolutePath();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSyncReceiverLogger() throws IOException {
        this.receiverLogger = new SyncReceiverLogger(new File(this.getReceiverFolderFile(), "sync.log"));
        HashSet<String> deletedFileNames = new HashSet<String>();
        HashSet<String> deletedFileNamesTest = new HashSet<String>();
        this.receiverLogger.startSyncDeletedFilesName();
        for (int i = 0; i < 200; ++i) {
            this.receiverLogger.finishSyncDeletedFileName(new File(this.getReceiverFolderFile(), "deleted" + i));
            deletedFileNames.add(new File(this.getReceiverFolderFile(), "deleted" + i).getAbsolutePath());
        }
        HashSet<String> toBeSyncedFiles = new HashSet<String>();
        HashSet<String> toBeSyncedFilesTest = new HashSet<String>();
        this.receiverLogger.startSyncTsFiles();
        for (int i = 0; i < 200; ++i) {
            this.receiverLogger.finishSyncTsfile(new File(this.getReceiverFolderFile(), "new" + i));
            toBeSyncedFiles.add(new File(this.getReceiverFolderFile(), "new" + i).getAbsolutePath());
        }
        this.receiverLogger.close();
        int count = 0;
        int mode = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.getReceiverFolderFile(), "sync.log")));){
            String line;
            while ((line = br.readLine()) != null) {
                ++count;
                if (line.equals("sync deleted file names start")) {
                    mode = -1;
                    continue;
                }
                if (line.equals("sync tsfile start")) {
                    mode = 1;
                    continue;
                }
                if (mode == -1) {
                    deletedFileNamesTest.add(line);
                    continue;
                }
                if (mode != 1) continue;
                toBeSyncedFilesTest.add(line);
            }
        }
        Assert.assertEquals((long)402L, (long)count);
        Assert.assertEquals((long)deletedFileNames.size(), (long)deletedFileNamesTest.size());
        Assert.assertEquals((long)toBeSyncedFiles.size(), (long)toBeSyncedFilesTest.size());
        Assert.assertTrue((boolean)deletedFileNames.containsAll(deletedFileNamesTest));
        Assert.assertTrue((boolean)toBeSyncedFiles.containsAll(toBeSyncedFilesTest));
    }

    private File getReceiverFolderFile() {
        return new File(this.dataDir + File.separatorChar + "sync-receiver" + File.separatorChar + "127.0.0.1_5555");
    }
}

