/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sink;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.sink.mqtt.MQTTConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.mqtt.MQTTEvent;
import org.apache.iotdb.db.engine.trigger.sink.mqtt.MQTTHandler;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.awaitility.Awaitility;
import org.fusesource.mqtt.client.QoS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MQTTSinkTest {
    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setEnableMQTTService(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void onEventUsingSingleSensorHandler() throws Exception {
        MQTTHandler mqttHandler = new MQTTHandler();
        mqttHandler.open(new MQTTConfiguration("127.0.0.1", 1883, "root", "root", new PartialPath("root.sg1.d1"), new String[]{"s1"}));
        for (int i = 0; i < 10000; ++i) {
            mqttHandler.onEvent(new MQTTEvent("test", QoS.EXACTLY_ONCE, false, (long)i, new Object[]{i}));
        }
        mqttHandler.close();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).until(() -> 10000 == this.checkSingleSensorHandlerResult());
    }

    private int checkSingleSensorHandlerResult() throws ClassNotFoundException {
        int count = 0;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("select * from root.**"));
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.checkHeader(resultSetMetaData, "Time,root.sg1.d1.s1,", new int[]{93, 6});
                while (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        Assert.assertEquals((double)count, (double)Double.parseDouble(resultSet.getString(i)), (double)0.0);
                    }
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        return count;
    }

    @Test
    public void onEventUsingMultiSensorsHandler() throws Exception {
        MQTTHandler mqttHandler = new MQTTHandler();
        mqttHandler.open(new MQTTConfiguration("127.0.0.1", 1883, "root", "root", new PartialPath("root.sg1.d1"), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}));
        for (int i = 0; i < 10000; ++i) {
            mqttHandler.onEvent(new MQTTEvent("test", QoS.EXACTLY_ONCE, false, (long)i, new Object[]{i, (long)i, Float.valueOf(i), (double)i, i % 2 == 0, String.valueOf(i)}));
        }
        mqttHandler.close();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).until(() -> 10000 == this.checkMultiSensorsHandlerResult());
    }

    private int checkMultiSensorsHandlerResult() throws ClassNotFoundException {
        int count = 0;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("select * from root.**"));
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.checkHeader(resultSetMetaData, "Time,root.sg1.d1.s1,root.sg1.d1.s2,root.sg1.d1.s3,root.sg1.d1.s4,root.sg1.d1.s5,root.sg1.d1.s6,", new int[]{93, 6, 6, 6, 6, 16, 6});
                while (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        try {
                            Assert.assertEquals((double)count, (double)Double.parseDouble(resultSet.getString(i)), (double)0.0);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            Assert.assertEquals((Object)(count % 2 == 0 ? 1 : 0), (Object)Boolean.parseBoolean(resultSet.getString(i)));
                        }
                    }
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        return count;
    }

    private void checkHeader(ResultSetMetaData resultSetMetaData, String expectedHeaderStrings, int[] expectedTypes) throws SQLException {
        int i;
        String[] expectedHeaders = expectedHeaderStrings.split(",");
        HashMap<String, Integer> expectedHeaderToTypeIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < expectedHeaders.length; ++i) {
            expectedHeaderToTypeIndexMap.put(expectedHeaders[i], i);
        }
        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Integer typeIndex = (Integer)expectedHeaderToTypeIndexMap.get(resultSetMetaData.getColumnName(i));
            Assert.assertNotNull((Object)typeIndex);
            Assert.assertEquals((long)expectedTypes[typeIndex], (long)resultSetMetaData.getColumnType(i));
        }
    }
}

