/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sink;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.iotdb.db.engine.trigger.sink.local.LocalIoTDBConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.local.LocalIoTDBEvent;
import org.apache.iotdb.db.engine.trigger.sink.local.LocalIoTDBHandler;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalIoTDBSinkTest {
    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void onEventUsingSingleSensorHandler() throws Exception {
        LocalIoTDBHandler localIoTDBHandler = new LocalIoTDBHandler();
        localIoTDBHandler.open(new LocalIoTDBConfiguration("root.sg1.d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32}));
        for (int i = 0; i < 10000; ++i) {
            localIoTDBHandler.onEvent(new LocalIoTDBEvent((long)i, new Object[]{i}));
        }
        localIoTDBHandler.close();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("select * from root.**"));
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.checkHeader(resultSetMetaData, "Time,root.sg1.d1.s1,", new int[]{93, 4});
                int count = 0;
                while (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        Assert.assertEquals((double)count, (double)Double.parseDouble(resultSet.getString(i)), (double)0.0);
                    }
                    ++count;
                }
                Assert.assertEquals((long)10000L, (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void onEventUsingMultiSensorsHandler() throws Exception {
        LocalIoTDBHandler localIoTDBHandler = new LocalIoTDBHandler();
        localIoTDBHandler.open(new LocalIoTDBConfiguration("root.sg1.d1", new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.TEXT}));
        for (int i = 0; i < 10000; ++i) {
            localIoTDBHandler.onEvent(new LocalIoTDBEvent((long)i, new Object[]{i, (long)i, Float.valueOf(i), (double)i, i % 2 == 0, Binary.valueOf((String)String.valueOf(i))}));
        }
        localIoTDBHandler.close();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            Assert.assertTrue((boolean)statement.execute("select * from root.**"));
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.checkHeader(resultSetMetaData, "Time,root.sg1.d1.s1,root.sg1.d1.s2,root.sg1.d1.s3,root.sg1.d1.s4,root.sg1.d1.s5,root.sg1.d1.s6,", new int[]{93, 4, -5, 6, 8, 16, 12});
                int count = 0;
                while (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        try {
                            Assert.assertEquals((double)count, (double)Double.parseDouble(resultSet.getString(i)), (double)0.0);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            Assert.assertEquals((Object)(count % 2 == 0 ? 1 : 0), (Object)Boolean.parseBoolean(resultSet.getString(i)));
                        }
                    }
                    ++count;
                }
                Assert.assertEquals((long)10000L, (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkHeader(ResultSetMetaData resultSetMetaData, String expectedHeaderStrings, int[] expectedTypes) throws SQLException {
        int i;
        String[] expectedHeaders = expectedHeaderStrings.split(",");
        HashMap<String, Integer> expectedHeaderToTypeIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < expectedHeaders.length; ++i) {
            expectedHeaderToTypeIndexMap.put(expectedHeaders[i], i);
        }
        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Integer typeIndex = (Integer)expectedHeaderToTypeIndexMap.get(resultSetMetaData.getColumnName(i));
            Assert.assertNotNull((Object)typeIndex);
            Assert.assertEquals((long)expectedTypes[typeIndex], (long)resultSetMetaData.getColumnType(i));
        }
    }

    @Test(expected=QueryProcessException.class)
    public void onEventWithWrongType1() throws Exception {
        LocalIoTDBHandler localIoTDBHandler = new LocalIoTDBHandler();
        localIoTDBHandler.open(new LocalIoTDBConfiguration("root.sg1.d1", new String[]{"s1"}, new TSDataType[]{TSDataType.INT32}));
        localIoTDBHandler.onEvent(new LocalIoTDBEvent(0L, new Object[]{Binary.valueOf((String)String.valueOf(0))}));
        localIoTDBHandler.close();
    }

    @Test(expected=ClassCastException.class)
    public void onEventWithWrongType2() throws Exception {
        LocalIoTDBHandler localIoTDBHandler = new LocalIoTDBHandler();
        localIoTDBHandler.open(new LocalIoTDBConfiguration("root.sg1.d1", new String[]{"s1"}, new TSDataType[]{TSDataType.TEXT}));
        localIoTDBHandler.onEvent(new LocalIoTDBEvent(0L, new Object[]{String.valueOf(0)}));
        localIoTDBHandler.close();
    }
}

