/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.security.encrypt;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.auth.user.LocalFileUserManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.security.encrypt.MessageDigestEncrypt;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageDigestEncryptTest {
    private static final String providerClass = "org.apache.iotdb.db.security.encrypt.MessageDigestEncrypt";
    private File testFolder;
    private LocalFileUserManager manager;
    private MessageDigestEncrypt messageDigestEncrypt = new MessageDigestEncrypt();

    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setEncryptDecryptProvider(providerClass);
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.manager = new LocalFileUserManager(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testMessageDigestEncrypt() throws AuthException {
        User[] users = new User[5];
        for (int i = 0; i < users.length; ++i) {
            users[i] = new User("user" + i, "password" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege("root.a.b.c" + j);
                pathPrivilege.getPrivileges().add(j);
                users[i].getPrivilegeList().add(pathPrivilege);
                users[i].getRoleList().add("role" + j);
            }
        }
        User user = this.manager.getUser(users[0].getName());
        Assert.assertNull((Object)user);
        for (User user1 : users) {
            Assert.assertTrue((boolean)this.manager.createUser(user1.getName(), user1.getPassword()));
        }
        for (User user1 : users) {
            user = this.manager.getUser(user1.getName());
            Assert.assertEquals((Object)user1.getName(), (Object)user.getName());
            Assert.assertEquals((Object)this.messageDigestEncrypt.encrypt(user1.getPassword()), (Object)user.getPassword());
        }
    }

    @Test
    public void testMessageDigestValidatePassword() {
        String password = "root";
        Assert.assertTrue((boolean)this.messageDigestEncrypt.validate(password, this.messageDigestEncrypt.encrypt(password)));
    }
}

