/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.valuefilter;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RawQueryWithValueFilterTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private IPlanExecutor queryExecutor = new PlanExecutor();
    private Planner processor = new Planner();
    private String[] sqls = new String[]{"SET STORAGE GROUP TO root.test", "CREATE TIMESERIES root.test.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "insert into root.test.d0(timestamp,s0) values(1,1)", "insert into root.test.d0(timestamp,s0) values(2,2)", "insert into root.test.d0(timestamp,s0) values(3,3)", "insert into root.test.d0(timestamp,s0) values(10,10)", "flush", "insert into root.test.d0(timestamp,s0) values(5,5)", "flush"};
    protected static boolean enableSeqSpaceCompaction;
    protected static boolean enableUnseqSpaceCompaction;
    protected static boolean enableCrossSpaceCompaction;

    @Before
    public void setUp() throws Exception {
        enableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        enableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        enableCrossSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
        config.setEnableSeqSpaceCompaction(false);
        config.setEnableUnseqSpaceCompaction(false);
        config.setEnableCrossSpaceCompaction(false);
        EnvironmentUtils.envSetUp();
        for (String sql : this.sqls) {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
    }

    @After
    public void tearDown() throws Exception {
        config.setEnableCrossSpaceCompaction(enableCrossSpaceCompaction);
        config.setEnableSeqSpaceCompaction(enableSeqSpaceCompaction);
        config.setEnableUnseqSpaceCompaction(enableUnseqSpaceCompaction);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testQuery() throws Exception {
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.test.d0");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"1\t1", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"2\t2", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"3\t3", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"5\t5", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"10\t10", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
    }

    @Test
    public void testOverlapped() throws Exception {
        this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan("insert into root.test.d0(timestamp,s0) values(2,-2)"));
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.test.d0 where s0 > 0");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"1\t1", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"3\t3", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"5\t5", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"10\t10", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
    }

    @Test
    public void testOverlapped2() throws Exception {
        this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan("insert into root.test.d0(timestamp,s0) values(4,-4)"));
        this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan("insert into root.test.d0(timestamp,s0) values(6,-6)"));
        this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan("insert into root.test.d0(timestamp,s0) values(8,-8)"));
        this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan("insert into root.test.d0(timestamp,s0) values(7,7)"));
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.test.d0 where s0 < 0");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"4\t-4", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"6\t-6", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"8\t-8", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
    }
}

