/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.query.udf.datastructure.SerializableTVListTest;
import org.apache.iotdb.db.query.udf.datastructure.tv.SerializableDoubleTVList;
import org.apache.iotdb.db.query.udf.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SerializableDoubleTVListTest
extends SerializableTVListTest {
    private List<Double> originalList;
    private SerializableDoubleTVList testList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.originalList = new ArrayList<Double>();
        this.testList = (SerializableDoubleTVList)SerializableTVList.newSerializableTVList((TSDataType)TSDataType.DOUBLE, (long)0L);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Override
    protected void generateData(int index) {
        this.originalList.add(Double.valueOf(index));
        this.testList.putDouble((long)index, (double)index);
    }

    @Override
    protected void serializeAndDeserializeOnce() {
        try {
            this.testList.serialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            this.testList.deserialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        int count = 0;
        while (this.testList.hasCurrent()) {
            Assert.assertEquals((long)count, (long)this.testList.currentTime());
            Assert.assertEquals((double)this.originalList.get(count), (double)this.testList.getDouble(), (double)0.0);
            this.testList.next();
            ++count;
        }
        Assert.assertEquals((long)10000L, (long)count);
    }
}

