/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import org.apache.iotdb.db.query.udf.datastructure.LRUCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LRUCacheTest {
    private static final int CACHE_SIZE = 3;
    private static final int DATA_SIZE = 24;
    private LRUCache cache;

    @Before
    public void setUp() {
        this.cache = new LRUCache(3);
    }

    @Test
    public void testPutAndGetRandomly() {
        this.cache.set(0, 0);
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        this.cache.set(4, 4);
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        this.cache.set(10, 10);
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        this.cache.set(23, 23);
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        this.cache.set(21, 21);
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        this.cache.set(18, 18);
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        this.cache.set(1, 1);
        Assert.assertEquals((long)1L, (long)this.cache.get(1));
        this.cache.set(3, 3);
        Assert.assertEquals((long)3L, (long)this.cache.get(3));
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        Assert.assertEquals((long)1L, (long)this.cache.get(1));
        Assert.assertEquals((long)3L, (long)this.cache.get(3));
    }

    @Test
    public void testPutAndGetOrderly() {
        int i;
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            Assert.assertEquals((long)i, (long)this.cache.get(i));
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, 24 - i);
        }
        for (i = 0; i < 24; ++i) {
            Assert.assertEquals((long)(24 - i), (long)this.cache.get(i));
        }
        for (i = 23; 0 <= i; --i) {
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
        for (i = 23; 0 <= i; --i) {
            this.cache.set(i, i);
            this.cache.set(i, i);
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
    }
}

