/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.util.Arrays;
import org.apache.iotdb.db.query.udf.datastructure.Cache;

public class LRUCache
extends Cache {
    private final int[] inMemory;
    private final int[] outMemory;

    public LRUCache(int capacity) {
        super(capacity);
        this.inMemory = new int[capacity << 3];
        this.outMemory = new int[capacity << 3];
        Arrays.fill(this.inMemory, Integer.MIN_VALUE);
        Arrays.fill(this.outMemory, Integer.MIN_VALUE);
    }

    public int get(int targetIndex) {
        this.access(targetIndex);
        return this.inMemory[targetIndex];
    }

    public void set(int targetIndex, int value) {
        this.access(targetIndex);
        this.inMemory[targetIndex] = value;
    }

    private void access(int targetIndex) {
        if (!this.removeFirstOccurrence(targetIndex)) {
            if (this.cacheCapacity <= this.cacheSize) {
                int lastIndex = this.removeLast();
                this.outMemory[lastIndex] = this.inMemory[lastIndex];
                this.inMemory[lastIndex] = Integer.MIN_VALUE;
            }
            this.inMemory[targetIndex] = this.outMemory[targetIndex];
            this.outMemory[targetIndex] = Integer.MIN_VALUE;
        }
        this.addFirst(targetIndex);
    }
}

