/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.io.IOException;
import java.util.Random;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.db.query.udf.datastructure.SerializableListTest;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSerializableRowRecordListTest
extends SerializableListTest {
    private static final TSDataType[] DATA_TYPES = new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.TEXT, TSDataType.TEXT};
    private ElasticSerializableRowRecordList rowRecordList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testESRowRecordList() {
        this.initESRowRecordList();
        this.testPut();
        this.testOrderedAccessByIndex();
    }

    private void initESRowRecordList() {
        try {
            this.rowRecordList = new ElasticSerializableRowRecordList(DATA_TYPES, 0L, 100.0f, 3);
        }
        catch (QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertEquals((long)0L, (long)this.rowRecordList.size());
    }

    private void testPut() {
        try {
            for (int i = 0; i < 10000; ++i) {
                Object[] rowRecord = new Object[DATA_TYPES.length + 1];
                rowRecord[ElasticSerializableRowRecordListTest.DATA_TYPES.length] = (long)i;
                if (i % 7 != 0) {
                    block11: for (int j = 0; j < DATA_TYPES.length; ++j) {
                        switch (DATA_TYPES[j]) {
                            case INT32: {
                                rowRecord[j] = i;
                                continue block11;
                            }
                            case INT64: {
                                rowRecord[j] = (long)i;
                                continue block11;
                            }
                            case FLOAT: {
                                rowRecord[j] = Float.valueOf(i);
                                continue block11;
                            }
                            case DOUBLE: {
                                rowRecord[j] = (double)i;
                                continue block11;
                            }
                            case BOOLEAN: {
                                rowRecord[j] = i % 2 == 0;
                                continue block11;
                            }
                            case TEXT: {
                                rowRecord[j] = Binary.valueOf((String)String.valueOf(i));
                            }
                        }
                    }
                }
                this.rowRecordList.put(rowRecord);
            }
        }
        catch (IOException | QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertEquals((long)10000L, (long)this.rowRecordList.size());
    }

    private void testRowRecord(Object[] rowRecord, int expected) {
        block8: for (int j = 0; j < DATA_TYPES.length; ++j) {
            switch (DATA_TYPES[j]) {
                case INT32: {
                    Assert.assertEquals((long)expected, (long)((Integer)rowRecord[j]).intValue());
                    continue block8;
                }
                case INT64: {
                    Assert.assertEquals((long)expected, (long)((Long)rowRecord[j]));
                    continue block8;
                }
                case FLOAT: {
                    Assert.assertEquals((float)expected, (float)((Float)rowRecord[j]).floatValue(), (float)0.0f);
                    continue block8;
                }
                case DOUBLE: {
                    Assert.assertEquals((double)expected, (double)((Double)rowRecord[j]), (double)0.0);
                    continue block8;
                }
                case BOOLEAN: {
                    Assert.assertEquals((Object)(expected % 2 == 0 ? 1 : 0), (Object)rowRecord[j]);
                    continue block8;
                }
                case TEXT: {
                    Assert.assertEquals((Object)Binary.valueOf((String)String.valueOf(expected)), (Object)rowRecord[j]);
                }
            }
        }
        Assert.assertEquals((long)DATA_TYPES.length, (long)(rowRecord.length - 1));
    }

    private void testOrderedAccessByIndex() {
        try {
            for (int i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    Assert.assertTrue((boolean)this.rowRecordList.fieldsHasAnyNull(i));
                    continue;
                }
                Assert.assertFalse((boolean)this.rowRecordList.fieldsHasAnyNull(i));
                this.testRowRecord(this.rowRecordList.getRowRecord(i), i);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMemoryControl() {
        this.initESRowRecordList();
        int byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 2;
        int byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 8;
        Random random = new Random();
        try {
            int i;
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    this.rowRecordList.put(this.generateRowRecordWithAllNullFields(i));
                    continue;
                }
                this.rowRecordList.put(this.generateRowRecord(i, byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin)));
            }
            this.rowRecordList.setEvictionUpperBound(this.rowRecordList.size());
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    Assert.assertTrue((boolean)this.rowRecordList.fieldsHasAnyNull(i));
                    continue;
                }
                Assert.assertFalse((boolean)this.rowRecordList.fieldsHasAnyNull(i));
            }
            byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 16;
            byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 32;
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    this.rowRecordList.put(this.generateRowRecordWithAllNullFields(i));
                    continue;
                }
                this.rowRecordList.put(this.generateRowRecord(i, byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin)));
            }
            this.rowRecordList.setEvictionUpperBound(this.rowRecordList.size());
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    Assert.assertTrue((boolean)this.rowRecordList.fieldsHasAnyNull(i + 10000));
                    continue;
                }
                Assert.assertFalse((boolean)this.rowRecordList.fieldsHasAnyNull(i + 10000));
            }
            byteLengthMin = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 256;
            byteLengthMax = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL * 512;
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    this.rowRecordList.put(this.generateRowRecordWithAllNullFields(i));
                    continue;
                }
                this.rowRecordList.put(this.generateRowRecord(i, byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin)));
            }
            this.rowRecordList.setEvictionUpperBound(this.rowRecordList.size());
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    Assert.assertTrue((boolean)this.rowRecordList.fieldsHasAnyNull(i + 20000));
                    continue;
                }
                Assert.assertFalse((boolean)this.rowRecordList.fieldsHasAnyNull(i + 20000));
            }
            for (i = 0; i < 20000; ++i) {
                if (i % 7 == 0) {
                    this.rowRecordList.put(this.generateRowRecordWithAllNullFields(i));
                } else {
                    this.rowRecordList.put(this.generateRowRecord(i, byteLengthMin + random.nextInt(byteLengthMax - byteLengthMin)));
                }
                this.rowRecordList.setEvictionUpperBound(this.rowRecordList.size());
            }
            for (i = 0; i < 10000; ++i) {
                if (i % 7 == 0) {
                    Assert.assertTrue((boolean)this.rowRecordList.fieldsHasAnyNull(i + 30000));
                    continue;
                }
                Assert.assertFalse((boolean)this.rowRecordList.fieldsHasAnyNull(i + 30000));
            }
            Assert.assertEquals((long)50000L, (long)this.rowRecordList.size());
        }
        catch (IOException | QueryProcessException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private Object[] generateRowRecord(int time, int byteLength) {
        Object[] rowRecord = new Object[DATA_TYPES.length + 1];
        rowRecord[ElasticSerializableRowRecordListTest.DATA_TYPES.length] = (long)time;
        block8: for (int i = 0; i < DATA_TYPES.length; ++i) {
            switch (DATA_TYPES[i]) {
                case INT32: {
                    rowRecord[i] = time;
                    continue block8;
                }
                case INT64: {
                    rowRecord[i] = (long)time;
                    continue block8;
                }
                case FLOAT: {
                    rowRecord[i] = Float.valueOf(time);
                    continue block8;
                }
                case DOUBLE: {
                    rowRecord[i] = (double)time;
                    continue block8;
                }
                case BOOLEAN: {
                    rowRecord[i] = time % 2 == 0;
                    continue block8;
                }
                case TEXT: {
                    rowRecord[i] = Binary.valueOf((String)this.generateRandomString(byteLength));
                }
            }
        }
        return rowRecord;
    }

    private Object[] generateRowRecordWithAllNullFields(int time) {
        Object[] rowRecord = new Object[DATA_TYPES.length + 1];
        rowRecord[ElasticSerializableRowRecordListTest.DATA_TYPES.length] = (long)time;
        return rowRecord;
    }

    private String generateRandomString(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

