/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.universal.FakedSeriesReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.junit.Assert;
import org.junit.Test;

public class PriorityMergeReaderTest2 {
    @Test
    public void test() throws IOException {
        FakedSeriesReader reader1 = new FakedSeriesReader(100L, 80, 5, 11);
        FakedSeriesReader reader2 = new FakedSeriesReader(150L, 60, 6, 19);
        FakedSeriesReader reader3 = new FakedSeriesReader(180L, 50, 7, 31);
        PriorityMergeReader priorityMergeReader = new PriorityMergeReader();
        priorityMergeReader.addReader((IPointReader)reader1, 3L);
        priorityMergeReader.addReader((IPointReader)reader2, 2L);
        priorityMergeReader.addReader((IPointReader)reader3, 1L);
        int cnt = 0;
        while (priorityMergeReader.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = priorityMergeReader.nextTimeValuePair();
            long time = timeValuePair.getTimestamp();
            long value = (Long)timeValuePair.getValue().getValue();
            if (time <= 500L && (time - 100L) % 5L == 0L) {
                Assert.assertEquals((long)(time % 11L), (long)value);
            } else if (time <= 510L && (time - 150L) % 6L == 0L) {
                Assert.assertEquals((long)(time % 19L), (long)value);
            } else {
                Assert.assertEquals((long)(time % 31L), (long)value);
            }
            ++cnt;
        }
        Assert.assertEquals((long)162L, (long)cnt);
    }
}

