/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataPointReader;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeriesReaderTest {
    private static final String SERIES_READER_TEST_SG = "root.seriesReaderTest";
    private List<String> deviceIds = new ArrayList<String>();
    private List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unseqResources);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unseqResources);
    }

    @Test
    public void batchTest() {
        try {
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            SeriesReader seriesReader = new SeriesReader(new PartialPath("root.seriesReaderTest.device0.sensor0"), allSensors, TSDataType.INT32, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
            SeriesRawDataBatchReader batchReader = new SeriesRawDataBatchReader(seriesReader);
            int count = 0;
            while (batchReader.hasNextBatch()) {
                BatchData batchData = batchReader.nextBatch();
                Assert.assertEquals((Object)TSDataType.INT32, (Object)batchData.getDataType());
                Assert.assertEquals((long)20L, (long)batchData.length());
                for (int i = 0; i < batchData.length(); ++i) {
                    long expectedTime = i + 20 * count;
                    Assert.assertEquals((long)expectedTime, (long)batchData.currentTime());
                    if (expectedTime < 200L) {
                        Assert.assertEquals((long)(20000L + expectedTime), (long)batchData.getInt());
                    } else if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        Assert.assertEquals((long)(10000L + expectedTime), (long)batchData.getInt());
                    } else {
                        Assert.assertEquals((long)expectedTime, (long)batchData.getInt());
                    }
                    batchData.next();
                }
                ++count;
            }
        }
        catch (IOException | IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void pointTest() {
        try {
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            SeriesReader seriesReader = new SeriesReader(new PartialPath("root.seriesReaderTest.device0.sensor0"), allSensors, TSDataType.INT32, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
            SeriesRawDataPointReader pointReader = new SeriesRawDataPointReader(seriesReader);
            long expectedTime = 0L;
            while (pointReader.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = pointReader.nextTimeValuePair();
                Assert.assertEquals((long)expectedTime, (long)timeValuePair.getTimestamp());
                int value = timeValuePair.getValue().getInt();
                if (expectedTime < 200L) {
                    Assert.assertEquals((long)(20000L + expectedTime), (long)value);
                } else if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                    Assert.assertEquals((long)(10000L + expectedTime), (long)value);
                } else {
                    Assert.assertEquals((long)expectedTime, (long)value);
                }
                ++expectedTime;
            }
        }
        catch (IOException | IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void descOrderTest() {
        try {
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            SeriesReader seriesReader = new SeriesReader(new PartialPath("root.seriesReaderTest.device0.sensor0"), allSensors, TSDataType.INT32, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, false);
            SeriesRawDataPointReader pointReader = new SeriesRawDataPointReader(seriesReader);
            long expectedTime = 499L;
            while (pointReader.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = pointReader.nextTimeValuePair();
                Assert.assertEquals((long)expectedTime, (long)timeValuePair.getTimestamp());
                int value = timeValuePair.getValue().getInt();
                if (expectedTime < 200L) {
                    Assert.assertEquals((long)(20000L + expectedTime), (long)value);
                } else if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                    Assert.assertEquals((long)(10000L + expectedTime), (long)value);
                } else {
                    Assert.assertEquals((long)expectedTime, (long)value);
                }
                --expectedTime;
            }
        }
        catch (IOException | IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

