/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.query.externalsort.serialize.impl.FixLengthIExternalSortFileDeserializer;
import org.apache.iotdb.db.query.externalsort.serialize.impl.FixLengthTimeValuePairSerializer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class IExternalSortFileSerializerDeserializerTest {
    @Test
    public void testFIX_LENGTH() throws IOException {
        String rootPath;
        String filePath = rootPath = TestConstant.BASE_OUTPUT_PATH.concat("tmpFile2");
        int count = 10000;
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.BOOLEAN), count, rootPath, filePath, Type.FIX_LENGTH);
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.INT32), count, rootPath, filePath, Type.FIX_LENGTH);
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.INT64), count, rootPath, filePath, Type.FIX_LENGTH);
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.FLOAT), count, rootPath, filePath, Type.FIX_LENGTH);
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.DOUBLE), count, rootPath, filePath, Type.FIX_LENGTH);
        this.testReadWrite(this.genTimeValuePairs(count, TSDataType.TEXT), count, rootPath, filePath, Type.FIX_LENGTH);
    }

    private void testReadWrite(TimeValuePair[] timeValuePairs, int count, String rootPath, String filePath, Type type) throws IOException {
        if (type != Type.FIX_LENGTH) {
            throw new IOException("Unsupported serializer type " + (Object)((Object)type));
        }
        FixLengthTimeValuePairSerializer serializer = new FixLengthTimeValuePairSerializer(filePath);
        for (TimeValuePair timeValuePair : timeValuePairs) {
            serializer.write(timeValuePair);
        }
        serializer.close();
        if (type != Type.FIX_LENGTH) {
            throw new IOException("Unsupported deserializer type " + (Object)((Object)type));
        }
        FixLengthIExternalSortFileDeserializer deserializer = new FixLengthIExternalSortFileDeserializer(filePath);
        int idx = 0;
        while (deserializer.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = deserializer.nextTimeValuePair();
            Assert.assertEquals((Object)timeValuePairs[idx].getValue(), (Object)timeValuePair.getValue());
            Assert.assertEquals((long)timeValuePairs[idx].getTimestamp(), (long)timeValuePair.getTimestamp());
            ++idx;
        }
        Assert.assertEquals((long)count, (long)idx);
        deserializer.close();
        this.deleteFileRecursively(new File(rootPath));
    }

    private void deleteFileRecursively(File file) throws IOException {
        FileUtils.deleteDirectory((File)file);
    }

    private TimeValuePair[] genTimeValuePairs(int count, TSDataType dataType) {
        TimeValuePair[] timeValuePairs = new TimeValuePair[count];
        block8: for (int i = 0; i < count; ++i) {
            switch (dataType) {
                case BOOLEAN: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsBoolean(i % 2 == 0));
                    continue block8;
                }
                case INT32: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsInt(i));
                    continue block8;
                }
                case INT64: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsLong((long)i));
                    continue block8;
                }
                case FLOAT: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsFloat((float)i + 0.1f));
                    continue block8;
                }
                case DOUBLE: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsDouble((double)i + 0.12));
                    continue block8;
                }
                case TEXT: {
                    timeValuePairs[i] = new TimeValuePair((long)i, (TsPrimitiveType)new TsPrimitiveType.TsBinary(new Binary(String.valueOf(i))));
                }
            }
        }
        return timeValuePairs;
    }

    private static enum Type {
        SIMPLE,
        FIX_LENGTH;

    }
}

