/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.externalsort.FakeChunkReaderWrap;
import org.apache.iotdb.db.query.externalsort.SimpleExternalSortEngine;
import org.apache.iotdb.db.query.reader.universal.FakedSeriesReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalSortEngineTest {
    private String baseDir = TestConstant.BASE_OUTPUT_PATH.concat("externalSortTestTmp").concat(File.separator);
    private long queryId = EnvironmentUtils.TEST_QUERY_JOB_ID;
    private SimpleExternalSortEngine engine;
    private String preBaseDir;
    private int preMinExternalSortSourceCount;

    @Before
    public void before() {
        this.engine = SimpleExternalSortEngine.getInstance();
        this.preBaseDir = this.engine.getQueryDir();
        this.preMinExternalSortSourceCount = this.engine.getMinExternalSortSourceCount();
        this.engine.setQueryDir(this.baseDir);
    }

    @After
    public void after() throws IOException, StorageEngineException {
        this.engine.setQueryDir(this.preBaseDir);
        this.engine.setMinExternalSortSourceCount(this.preMinExternalSortSourceCount);
        EnvironmentUtils.cleanAllDir();
        QueryResourceManager.getInstance().endQuery(this.queryId);
        this.deleteExternalTempDir();
    }

    @Test
    public void testSimple() throws IOException {
        this.engine.setMinExternalSortSourceCount(2);
        List readerList1 = this.genSimple();
        List<IPointReader> readerList2 = this.genSimple();
        ArrayList chunkReaderWrapList = new ArrayList();
        readerList1.forEach(x -> chunkReaderWrapList.add(new FakeChunkReaderWrap((IPointReader)x)));
        readerList1 = this.engine.executeForIPointReader(this.queryId, chunkReaderWrapList);
        PriorityMergeReader reader1 = new PriorityMergeReader(readerList1, 1);
        PriorityMergeReader reader2 = new PriorityMergeReader(readerList2, 1);
        reader1.close();
        reader2.close();
    }

    @Test
    public void testBig() throws IOException {
        this.engine.setMinExternalSortSourceCount(50);
        int lineCount = 100;
        int valueCount = 10000;
        List<long[]> data = this.genData(lineCount, valueCount);
        List readerList1 = this.genReaders(data);
        List<IPointReader> readerList2 = this.genReaders(data);
        ArrayList chunkReaderWrapList = new ArrayList();
        readerList1.forEach(x -> chunkReaderWrapList.add(new FakeChunkReaderWrap((IPointReader)x)));
        readerList1 = this.engine.executeForIPointReader(this.queryId, chunkReaderWrapList);
        PriorityMergeReader reader1 = new PriorityMergeReader(readerList1, 1);
        PriorityMergeReader reader2 = new PriorityMergeReader(readerList2, 1);
        reader1.close();
        reader2.close();
    }

    public void efficiencyTest() throws IOException {
        this.engine.setMinExternalSortSourceCount(50);
        int lineCount = 100000;
        int valueCount = 100;
        List<long[]> data = this.genData(lineCount, valueCount);
        List readerList1 = this.genReaders(data);
        ArrayList chunkReaderWrapList = new ArrayList();
        readerList1.forEach(x -> chunkReaderWrapList.add(new FakeChunkReaderWrap((IPointReader)x)));
        long startTimestamp = System.currentTimeMillis();
        readerList1 = this.engine.executeForIPointReader(this.queryId, chunkReaderWrapList);
        PriorityMergeReader reader1 = new PriorityMergeReader();
        for (int i = 0; i < readerList1.size(); ++i) {
            reader1.addReader((IPointReader)readerList1.get(i), (long)i);
        }
        while (reader1.hasNextTimeValuePair()) {
            reader1.nextTimeValuePair();
        }
        System.out.println("Time used WITH external sort:" + (System.currentTimeMillis() - startTimestamp) + "ms");
        List<IPointReader> readerList2 = this.genReaders(data);
        startTimestamp = System.currentTimeMillis();
        PriorityMergeReader reader2 = new PriorityMergeReader();
        for (int i = 0; i < readerList2.size(); ++i) {
            reader2.addReader(readerList2.get(i), (long)i);
        }
        while (reader2.hasNextTimeValuePair()) {
            reader2.nextTimeValuePair();
        }
        System.out.println("Time used WITHOUT external sort:" + (System.currentTimeMillis() - startTimestamp) + "ms");
        reader2.close();
    }

    private List<long[]> genData(int lineCount, int valueCountEachLine) {
        Random rand = new Random();
        ArrayList<long[]> data = new ArrayList<long[]>();
        for (int i = 0; i < lineCount; ++i) {
            long[] tmp = new long[valueCountEachLine];
            long start = rand.nextInt(Integer.MAX_VALUE);
            for (int j = 0; j < valueCountEachLine; ++j) {
                ++start;
            }
            data.add(tmp);
        }
        return data;
    }

    private List<IPointReader> genReaders(List<long[]> data) {
        ArrayList<IPointReader> readerList = new ArrayList<IPointReader>();
        for (int i = 0; i < data.size(); ++i) {
            readerList.add(new FakedSeriesReader(data.get(i), i));
        }
        return readerList;
    }

    private void check(IPointReader reader1, IPointReader reader2) throws IOException {
        while (reader1.hasNextTimeValuePair() && reader2.hasNextTimeValuePair()) {
            TimeValuePair tv1 = reader1.nextTimeValuePair();
            TimeValuePair tv2 = reader2.nextTimeValuePair();
            Assert.assertEquals((long)tv1.getTimestamp(), (long)tv2.getTimestamp());
            Assert.assertEquals((Object)tv1.getValue(), (Object)tv2.getValue());
        }
        Assert.assertFalse((boolean)reader2.hasNextTimeValuePair());
        Assert.assertFalse((boolean)reader1.hasNextTimeValuePair());
    }

    private List<IPointReader> genSimple() {
        FakedSeriesReader reader1 = new FakedSeriesReader(new long[]{1L, 2L, 3L, 4L, 5L}, 1L);
        FakedSeriesReader reader2 = new FakedSeriesReader(new long[]{1L, 5L, 6L, 7L, 8L}, 2L);
        FakedSeriesReader reader3 = new FakedSeriesReader(new long[]{4L, 5L, 6L, 7L, 10L}, 3L);
        ArrayList<IPointReader> readerList = new ArrayList<IPointReader>();
        readerList.add(reader1);
        readerList.add(reader2);
        readerList.add(reader3);
        return readerList;
    }

    private void deleteExternalTempDir() throws IOException {
        File file = new File(this.baseDir);
        if (!file.delete()) {
            throw new IOException("delete external sort tmp file dir error.");
        }
    }
}

