/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByFillDataSetTest {
    private IPlanExecutor queryExecutor = new PlanExecutor();
    private Planner processor = new Planner();
    private String[] sqls = new String[]{"SET STORAGE GROUP TO root.vehicle", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=INT32, ENCODING=RLE", "insert into root.vehicle.d0(timestamp,s0) values(1,1)", "insert into root.vehicle.d0(timestamp,s1) values(1,1)", "insert into root.vehicle.d0(timestamp,s2) values(1,1)", "insert into root.vehicle.d0(timestamp,s2) values(2,2)", "insert into root.vehicle.d0(timestamp,s2) values(3,3)", "insert into root.vehicle.d0(timestamp,s2) values(4,4)", "insert into root.vehicle.d0(timestamp,s2) values(5,5)", "flush", "insert into root.vehicle.d0(timestamp,s0) values(6,6)", "insert into root.vehicle.d0(timestamp,s0) values(7,7)", "insert into root.vehicle.d0(timestamp,s0) values(8,8)", "insert into root.vehicle.d0(timestamp,s1) values(6,6)", "insert into root.vehicle.d0(timestamp,s1) values(7,7)", "insert into root.vehicle.d0(timestamp,s2) values(6,6)", "insert into root.vehicle.d0(timestamp,s2) values(7,7)"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        for (String sql : this.sqls) {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void groupByFillTest() throws Exception {
        int i;
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last_value(s0) from root.vehicle.* group by ([0,20), 1ms) fill (int32[Previous]) order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"19\t8", (Object)dataSet.next().toString());
        for (i = 0; i < 10; ++i) {
            dataSet.hasNext();
            dataSet.next();
        }
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"8\t8", (Object)dataSet.next().toString());
        for (i = 7; i > -1; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            if (i > 5) {
                Assert.assertEquals((Object)(i + "\t" + i), (Object)dataSet.next().toString());
                continue;
            }
            if (i > 0) {
                Assert.assertEquals((Object)(i + "\t" + 1), (Object)dataSet.next().toString());
                continue;
            }
            Assert.assertEquals((Object)(i + "\tnull"), (Object)dataSet.next().toString());
        }
    }

    @Test
    public void groupByWithValueFilterFillTest() throws Exception {
        int i;
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last_value(s0) from root.vehicle.* where s1 > 1  group by ([0,20), 1ms) fill (int32[Previous]) order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        for (i = 19; i >= 7; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\t7"), (Object)dataSet.next().toString());
        }
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"6\t6", (Object)dataSet.next().toString());
        for (i = 5; i >= 0; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\tnull"), (Object)dataSet.next().toString());
        }
    }

    @Test
    public void groupByWithAndFilterFillTest() throws Exception {
        int i;
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last_value(s0) from root.vehicle.* where s1 > 1 or s0 > 1  group by ([0,20), 1ms) fill (int32[Previous]) order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        for (i = 19; i >= 8; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\t8"), (Object)dataSet.next().toString());
        }
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"7\t7", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"6\t6", (Object)dataSet.next().toString());
        for (i = 5; i >= 0; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\tnull"), (Object)dataSet.next().toString());
        }
    }

    @Test
    public void groupByWithFirstNullTest() throws Exception {
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last_value(s0) from root.vehicle.* where s1 > 1 or s0 >= 1  group by ([5,20), 1ms) fill (int32[Previous, 11ms]) order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        for (int i = 19; i >= 8; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\t8"), (Object)dataSet.next().toString());
        }
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"7\t7", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"6\t6", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"5\t1", (Object)dataSet.next().toString());
    }

    @Test
    public void groupByWithCross() throws Exception {
        int i;
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last_value(s0) from root.vehicle.* where s2 > 1 group by ([0,20), 1ms) fill (int32[Previous]) order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        for (i = 19; i >= 8; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\t7"), (Object)dataSet.next().toString());
        }
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"7\t7", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"6\t6", (Object)dataSet.next().toString());
        for (i = 5; i >= 0; --i) {
            Assert.assertTrue((boolean)dataSet.hasNext());
            Assert.assertEquals((Object)(i + "\tnull"), (Object)dataSet.next().toString());
        }
    }

    static {
        IoTDB.metaManager.init();
    }
}

