/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EngineDataSetWithValueFilterTest {
    private IPlanExecutor queryExecutor = new PlanExecutor();
    private Planner processor = new Planner();
    private String[] sqls = new String[]{"SET STORAGE GROUP TO root.vehicle", "SET STORAGE GROUP TO root.test", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.test.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.test.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "insert into root.vehicle.d0(timestamp,s0) values(10,100)", "insert into root.vehicle.d0(timestamp,s0,s1) values(12,101,'102')", "insert into root.vehicle.d0(timestamp,s1) values(19,'103')", "insert into root.vehicle.d0(timestamp,s0) values(20,1000)", "insert into root.vehicle.d0(timestamp,s0,s1) values(22,1001,'1002')", "insert into root.vehicle.d0(timestamp,s1) values(29,'1003')", "insert into root.test.d0(timestamp,s0) values(10,106)", "insert into root.test.d0(timestamp,s0,s1) values(14,107,'108')", "insert into root.test.d0(timestamp,s1) values(16,'109')", "insert into root.test.d0(timestamp,s0) values(30,1006)", "insert into root.test.d0(timestamp,s0,s1) values(34,1007,'1008')", "insert into root.test.d0(timestamp,s1) values(36,'1090')", "insert into root.vehicle.d0(timestamp,s0) values(6,120)", "insert into root.vehicle.d0(timestamp,s0,s1) values(38,121,'122')", "insert into root.vehicle.d0(timestamp,s1) values(9,'123')", "insert into root.vehicle.d0(timestamp,s0) values(16,128)", "insert into root.vehicle.d0(timestamp,s0,s1) values(18,189,'198')", "insert into root.vehicle.d0(timestamp,s1) values(99,'1234')", "insert into root.test.d0(timestamp,s0) values(15,126)", "insert into root.test.d0(timestamp,s0,s1) values(8,127,'128')", "insert into root.test.d0(timestamp,s1) values(20,'129')", "insert into root.test.d0(timestamp,s0) values(150,426)", "insert into root.test.d0(timestamp,s0,s1) values(80,427,'528')", "insert into root.test.d0(timestamp,s1) values(2,'1209')", "insert into root.vehicle.d0(timestamp,s0) values(209,130)", "insert into root.vehicle.d0(timestamp,s0,s1) values(206,131,'132')", "insert into root.vehicle.d0(timestamp,s1) values(70,'33')", "insert into root.test.d0(timestamp,s0) values(19,136)", "insert into root.test.d0(timestamp,s0,s1) values(7,137,'138')", "insert into root.test.d0(timestamp,s1) values(30,'139')", "insert into root.test.d0(timestamp,s0) values(1900,1316)", "insert into root.test.d0(timestamp,s0,s1) values(700,1307,'1038')", "insert into root.test.d0(timestamp,s1) values(3000,'1309')"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        for (String sql : this.sqls) {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testHasNextAndNext() throws Exception {
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select test.d0.s1 from root where root.vehicle.d0.s0 > 100");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"16\t109", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"20\t129", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
        Assert.assertNull((Object)dataSet.next());
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select vehicle.d0.s1 from root where root.vehicle.d0.s0 > 100");
        dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"12\t102", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"18\t198", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"22\t1002", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"38\t122", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"206\t132", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
        Assert.assertNull((Object)dataSet.next());
    }

    @Test
    public void testOrderByTimeDesc() throws Exception {
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select vehicle.d0.s1 from root where root.vehicle.d0.s0 > 100 order by time desc");
        QueryDataSet dataSet = this.queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"206\t132", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"38\t122", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"22\t1002", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"18\t198", (Object)dataSet.next().toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        Assert.assertEquals((Object)"12\t102", (Object)dataSet.next().toString());
        Assert.assertFalse((boolean)dataSet.hasNext());
    }

    static {
        IoTDB.metaManager.init();
    }
}

