/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;

public class DescAggregateResultTest {
    @Test
    public void maxTimeDescAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult maxTimeDescAggrResult = AggregateResultFactory.getAggrResultByName((String)"max_time", (TSDataType)TSDataType.FLOAT, (boolean)false);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.FLOAT);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.FLOAT);
        statistics1.update(10L, 10.0f);
        statistics2.update(1L, 1.0f);
        maxTimeDescAggrResult.updateResultFromStatistics(statistics1);
        Assert.assertEquals((long)10L, (long)((Long)maxTimeDescAggrResult.getResult()));
        maxTimeDescAggrResult.updateResultFromStatistics(statistics2);
        Assert.assertEquals((long)10L, (long)((Long)maxTimeDescAggrResult.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        maxTimeDescAggrResult.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)10L, (long)((Long)result.getResult()));
        maxTimeDescAggrResult.reset();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.FLOAT, (boolean)false, (boolean)false);
        batchData.putFloat(1L, 1.0f);
        batchData.putFloat(2L, 2.0f);
        batchData.putFloat(3L, 3.0f);
        batchData.putFloat(4L, 4.0f);
        batchData.putFloat(5L, 5.0f);
        batchData.resetBatchData();
        BatchData.BatchDataIterator it = batchData.getBatchDataIterator();
        maxTimeDescAggrResult.updateResultFromPageData((IBatchDataIterator)it);
        Assert.assertEquals((Object)5L, (Object)maxTimeDescAggrResult.getResult());
        it.reset();
        maxTimeDescAggrResult.updateResultFromPageData((IBatchDataIterator)it, QueryUtils.getPredicate((long)2L, (long)5L, (boolean)false));
        Assert.assertEquals((Object)5L, (Object)maxTimeDescAggrResult.getResult());
    }

    @Test
    public void minTimeDescAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult minTimeDescAggrResult = AggregateResultFactory.getAggrResultByName((String)"min_time", (TSDataType)TSDataType.FLOAT, (boolean)false);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.FLOAT);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.FLOAT);
        statistics1.update(10L, 10.0f);
        statistics2.update(1L, 1.0f);
        minTimeDescAggrResult.updateResultFromStatistics(statistics1);
        Assert.assertEquals((long)10L, (long)((Long)minTimeDescAggrResult.getResult()));
        minTimeDescAggrResult.updateResultFromStatistics(statistics2);
        Assert.assertEquals((long)1L, (long)((Long)minTimeDescAggrResult.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        minTimeDescAggrResult.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)1L, (long)((Long)result.getResult()));
        minTimeDescAggrResult.reset();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.FLOAT, (boolean)false, (boolean)false);
        batchData.putFloat(1L, 1.0f);
        batchData.putFloat(2L, 2.0f);
        batchData.putFloat(3L, 3.0f);
        batchData.putFloat(4L, 4.0f);
        batchData.putFloat(5L, 5.0f);
        batchData.resetBatchData();
        BatchData.BatchDataIterator it = batchData.getBatchDataIterator();
        minTimeDescAggrResult.updateResultFromPageData((IBatchDataIterator)it);
        Assert.assertEquals((Object)1L, (Object)minTimeDescAggrResult.getResult());
        it.reset();
        minTimeDescAggrResult.updateResultFromPageData((IBatchDataIterator)it, QueryUtils.getPredicate((long)1L, (long)3L, (boolean)false));
        Assert.assertEquals((Object)1L, (Object)minTimeDescAggrResult.getResult());
    }

    @Test
    public void firstValueDescAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult firstValueDescAggrResult = AggregateResultFactory.getAggrResultByName((String)"first_value", (TSDataType)TSDataType.BOOLEAN, (boolean)false);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.BOOLEAN);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.BOOLEAN);
        statistics1.update(10L, true);
        statistics2.update(1L, false);
        firstValueDescAggrResult.updateResultFromStatistics(statistics1);
        Assert.assertEquals((Object)true, (Object)firstValueDescAggrResult.getResult());
        firstValueDescAggrResult.updateResultFromStatistics(statistics2);
        Assert.assertEquals((Object)false, (Object)firstValueDescAggrResult.getResult());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        firstValueDescAggrResult.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)false, (Object)result.getResult());
        firstValueDescAggrResult.reset();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.BOOLEAN, (boolean)false, (boolean)false);
        batchData.putBoolean(1L, true);
        batchData.putBoolean(2L, false);
        batchData.putBoolean(3L, false);
        batchData.putBoolean(4L, true);
        batchData.putBoolean(5L, false);
        batchData.resetBatchData();
        BatchData.BatchDataIterator it = batchData.getBatchDataIterator();
        firstValueDescAggrResult.updateResultFromPageData((IBatchDataIterator)it);
        Assert.assertTrue((boolean)((Boolean)firstValueDescAggrResult.getResult()));
        it.reset();
        firstValueDescAggrResult.updateResultFromPageData((IBatchDataIterator)it, QueryUtils.getPredicate((long)1L, (long)3L, (boolean)false));
        Assert.assertTrue((boolean)((Boolean)firstValueDescAggrResult.getResult()));
    }

    @Test
    public void lastValueDescAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult lastValueDescAggrResult = AggregateResultFactory.getAggrResultByName((String)"last_value", (TSDataType)TSDataType.TEXT, (boolean)false);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.TEXT);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.TEXT);
        statistics1.update(10L, new Binary("last"));
        statistics2.update(1L, new Binary("first"));
        lastValueDescAggrResult.updateResultFromStatistics(statistics1);
        Assert.assertEquals((Object)"last", (Object)String.valueOf(lastValueDescAggrResult.getResult()));
        lastValueDescAggrResult.updateResultFromStatistics(statistics2);
        Assert.assertEquals((Object)"last", (Object)String.valueOf(lastValueDescAggrResult.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        lastValueDescAggrResult.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)"last", (Object)String.valueOf(result.getResult()));
        lastValueDescAggrResult.reset();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.TEXT, (boolean)false, (boolean)false);
        batchData.putBinary(1L, new Binary("a"));
        batchData.putBinary(2L, new Binary("b"));
        batchData.putBinary(3L, new Binary("c"));
        batchData.putBinary(4L, new Binary("d"));
        batchData.putBinary(5L, new Binary("e"));
        batchData.resetBatchData();
        BatchData.BatchDataIterator it = batchData.getBatchDataIterator();
        lastValueDescAggrResult.updateResultFromPageData((IBatchDataIterator)it);
        Assert.assertEquals((Object)"e", (Object)((Binary)lastValueDescAggrResult.getResult()).getStringValue());
        it.reset();
        lastValueDescAggrResult.updateResultFromPageData((IBatchDataIterator)it, QueryUtils.getPredicate((long)3L, (long)5L, (boolean)false));
        Assert.assertEquals((Object)"e", (Object)((Binary)lastValueDescAggrResult.getResult()).getStringValue());
    }
}

