/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializationTest {
    private Planner processor = new Planner();

    @Before
    public void before() throws MetadataException {
        IoTDB.metaManager.init();
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d3.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d4.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    @After
    public void clean() throws IOException {
        IoTDB.metaManager.clear();
        EnvironmentUtils.cleanAllDir();
    }

    @Test
    public void testInsert() throws QueryProcessException, IOException, IllegalPathException {
        String sqlStr = "INSERT INTO root.vehicle.d1(timestamp, s1) VALUES (1, 5.0)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            plan.serialize(dataOutputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
            Assert.assertEquals((Object)plan, (Object)planB);
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        plan.serialize(buffer);
        buffer.flip();
        PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
        Assert.assertEquals((Object)plan, (Object)planB);
    }

    @Test
    public void testFlush() throws IOException, IllegalPathException {
        HashMap storageGroupPartitionIds = new HashMap();
        Boolean[] isSeqArray = new Boolean[]{null, true};
        boolean[] isSyncArray = new boolean[]{true, false};
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            ArrayList<Pair> partitionIdPairs = new ArrayList<Pair>();
            for (int j = 0; j < 10; ++j) {
                partitionIdPairs.add(new Pair((Object)((long)i + (long)j), (Object)isSyncArray[random.nextInt(1)]));
            }
            storageGroupPartitionIds.put(new PartialPath(new String[]{"path_" + i}), partitionIdPairs);
        }
        for (Boolean isSeq : isSeqArray) {
            for (boolean isSync : isSyncArray) {
                FlushPlan plan = new FlushPlan(isSeq, isSync, storageGroupPartitionIds);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                    plan.serialize(dataOutputStream);
                    ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                    FlushPlan planB = (FlushPlan)PhysicalPlan.Factory.create((ByteBuffer)buffer);
                    Assert.assertEquals((Object)plan.getPaths(), (Object)planB.getPaths());
                    Assert.assertEquals((Object)plan.getStorageGroupPartitionIds(), (Object)planB.getStorageGroupPartitionIds());
                    Assert.assertEquals((Object)plan.isSeq(), (Object)planB.isSeq());
                    Assert.assertEquals((Object)plan.isSync(), (Object)planB.isSync());
                }
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                plan.serialize(buffer);
                buffer.flip();
                FlushPlan planB = (FlushPlan)PhysicalPlan.Factory.create((ByteBuffer)buffer);
                Assert.assertEquals((Object)plan.getPaths(), (Object)planB.getPaths());
                Assert.assertEquals((Object)plan.getStorageGroupPartitionIds(), (Object)planB.getStorageGroupPartitionIds());
                Assert.assertEquals((Object)plan.isSeq(), (Object)planB.isSeq());
                Assert.assertEquals((Object)plan.isSync(), (Object)planB.isSync());
            }
        }
    }
}

