/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowContinuousQueriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowFunctionsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTriggersPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.filter.operator.OrFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhysicalPlanTest {
    private final Planner processor = new Planner();

    @Before
    public void before() throws MetadataException {
        EnvironmentUtils.envSetUp();
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d3.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d4.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testMetadata() throws QueryProcessException {
        String metadata = "create timeseries root.vehicle.d1.s2 with datatype=INT32,encoding=RLE";
        Planner processor = new Planner();
        CreateTimeSeriesPlan plan = (CreateTimeSeriesPlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)"seriesPath: root.vehicle.d1.s2, resultDataType: INT32, encoding: RLE, compression: SNAPPY, tagOffset: -1", (Object)plan.toString());
    }

    @Test
    public void testMetadata2() throws QueryProcessException {
        String metadata = "create timeseries root.vehicle.d1.s2 with datatype=int32,encoding=rle";
        Planner processor = new Planner();
        CreateTimeSeriesPlan plan = (CreateTimeSeriesPlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)"seriesPath: root.vehicle.d1.s2, resultDataType: INT32, encoding: RLE, compression: SNAPPY, tagOffset: -1", (Object)plan.toString());
    }

    @Test
    public void testMetadata3() throws QueryProcessException {
        String metadata = "create timeseries root.vehicle.d1.s2(\u6e29\u5ea6) with datatype=int32,encoding=rle, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        System.out.println(metadata.length());
        Planner processor = new Planner();
        CreateTimeSeriesPlan plan = (CreateTimeSeriesPlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)"seriesPath: root.vehicle.d1.s2, resultDataType: INT32, encoding: RLE, compression: SNAPPY, tagOffset: -1", (Object)plan.toString());
    }

    @Test
    public void testAuthor() throws QueryProcessException {
        String sql = "grant role xm privileges SET_STORAGE_GROUP,DELETE_TIMESERIES on root.vehicle.d1.s1";
        Planner processor = new Planner();
        AuthorPlan plan = (AuthorPlan)processor.parseSQLToPhysicalPlan(sql);
        Assert.assertEquals((Object)"userName: null\nroleName: xm\npassword: null\nnewPassword: null\npermissions: [0, 5]\nnodeName: root.vehicle.d1.s1\nauthorType: GRANT_ROLE", (Object)plan.toString());
    }

    @Test
    public void testAggregation() throws QueryProcessException {
        String sqlStr = "select sum(d1.s1) from root.vehicle where time <= 51 or !(time != 100 and time < 460)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        AggregationPlan mergePlan = (AggregationPlan)plan;
        Assert.assertEquals((Object)"sum", mergePlan.getAggregations().get(0));
    }

    @Test
    public void testGroupBy1() throws QueryProcessException {
        String sqlStr = "select count(s1) from root.vehicle.d1 where s1 < 20 and time <= now() group by([8,737), 3ms)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        GroupByTimePlan mergePlan = (GroupByTimePlan)plan;
        Assert.assertEquals((long)3L, (long)mergePlan.getInterval());
        Assert.assertEquals((long)3L, (long)mergePlan.getSlidingStep());
        Assert.assertEquals((long)8L, (long)mergePlan.getStartTime());
        Assert.assertEquals((long)737L, (long)mergePlan.getEndTime());
    }

    @Test
    public void testGroupBy2() throws QueryProcessException {
        String sqlStr = "select count(s1) from root.vehicle.d1 where s1 < 20 and time <= now() group by([123,2017-6-2T12:00:12+07:00), 111ms)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        GroupByTimePlan mergePlan = (GroupByTimePlan)plan;
        Assert.assertEquals((long)111L, (long)mergePlan.getInterval());
    }

    @Test
    public void testGroupBy3() throws QueryProcessException {
        String sqlStr = "select count(s1) from root.vehicle.d1 where s1 < 20 and time <= now() group by([2017-6-2T12:00:12+07:00,2017-6-12T12:00:12+07:00), 3h, 24h)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        GroupByTimePlan mergePlan = (GroupByTimePlan)plan;
        Assert.assertEquals((long)10800000L, (long)mergePlan.getInterval());
        Assert.assertEquals((long)86400000L, (long)mergePlan.getSlidingStep());
        Assert.assertEquals((long)1496379612000L, (long)mergePlan.getStartTime());
        Assert.assertEquals((long)1497243612000L, (long)mergePlan.getEndTime());
    }

    @Test
    public void testFill1() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time = 5000 Fill(int32[linear, 5m, 5m], boolean[previous, 5m])";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        FillQueryPlan mergePlan = (FillQueryPlan)plan;
        Assert.assertEquals((long)5000L, (long)mergePlan.getQueryTime());
        Assert.assertEquals((long)300000L, (long)((IFill)mergePlan.getFillType().get(TSDataType.INT32)).getBeforeRange());
        Assert.assertEquals((long)300000L, (long)((IFill)mergePlan.getFillType().get(TSDataType.INT32)).getAfterRange());
        Assert.assertEquals((long)300000L, (long)((IFill)mergePlan.getFillType().get(TSDataType.BOOLEAN)).getBeforeRange());
    }

    @Test
    public void testFill2() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time = 5000 Fill(int32[linear], boolean[previous])";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        if (!plan.isQuery()) {
            Assert.fail();
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        FillQueryPlan mergePlan = (FillQueryPlan)plan;
        Assert.assertEquals((long)5000L, (long)mergePlan.getQueryTime());
        Assert.assertEquals((long)defaultFillInterval, (long)((IFill)mergePlan.getFillType().get(TSDataType.INT32)).getBeforeRange());
        Assert.assertEquals((long)defaultFillInterval, (long)((IFill)mergePlan.getFillType().get(TSDataType.INT32)).getAfterRange());
        Assert.assertEquals((long)defaultFillInterval, (long)((IFill)mergePlan.getFillType().get(TSDataType.BOOLEAN)).getBeforeRange());
    }

    @Test
    public void testFill3() {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time = 5000 Fill(int32[linear, 5m], boolean[previous])";
        try {
            this.processor.parseSQLToPhysicalPlan(sqlStr);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testFill4() {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 5000 Fill(int32[linear], boolean[previous])";
        try {
            this.processor.parseSQLToPhysicalPlan(sqlStr);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"The condition of WHERE clause must be like time=constant", (Object)e.getMessage());
        }
    }

    @Test
    public void testGroupByFill1() {
        String sqlStr = "select last_value(s1)  from root.vehicle.d1 group by([8,737), 3ms) fill(int32[previous])";
        try {
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            if (!plan.isQuery()) {
                Assert.fail();
            }
            if (!(plan instanceof GroupByTimeFillPlan)) {
                Assert.fail();
            }
            GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)plan;
            Assert.assertEquals((long)3L, (long)groupByFillPlan.getInterval());
            Assert.assertEquals((long)3L, (long)groupByFillPlan.getSlidingStep());
            Assert.assertEquals((long)8L, (long)groupByFillPlan.getStartTime());
            Assert.assertEquals((long)737L, (long)groupByFillPlan.getEndTime());
            Assert.assertEquals((long)1L, (long)groupByFillPlan.getFillType().size());
            Assert.assertTrue((boolean)groupByFillPlan.getFillType().containsKey(TSDataType.INT32));
            Assert.assertTrue((boolean)(groupByFillPlan.getFillType().get(TSDataType.INT32) instanceof PreviousFill));
            PreviousFill previousFill = (PreviousFill)groupByFillPlan.getFillType().get(TSDataType.INT32);
            Assert.assertFalse((boolean)previousFill.isUntilLast());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGroupByFill3() {
        String sqlStr = "select last_value(d1.s1), last_value(d2.s1) from root.vehicle group by([8,737), 3ms) fill(int32[previousuntillast], int64[previous])";
        try {
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            if (!plan.isQuery()) {
                Assert.fail();
            }
            if (!(plan instanceof GroupByTimeFillPlan)) {
                Assert.fail();
            }
            GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)plan;
            Assert.assertEquals((long)3L, (long)groupByFillPlan.getInterval());
            Assert.assertEquals((long)3L, (long)groupByFillPlan.getSlidingStep());
            Assert.assertEquals((long)8L, (long)groupByFillPlan.getStartTime());
            Assert.assertEquals((long)737L, (long)groupByFillPlan.getEndTime());
            Assert.assertEquals((long)2L, (long)groupByFillPlan.getDeduplicatedPaths().size());
            Assert.assertEquals((long)2L, (long)groupByFillPlan.getFillType().size());
            Assert.assertTrue((boolean)groupByFillPlan.getFillType().containsKey(TSDataType.INT32));
            Assert.assertTrue((boolean)(groupByFillPlan.getFillType().get(TSDataType.INT32) instanceof PreviousFill));
            PreviousFill previousFill = (PreviousFill)groupByFillPlan.getFillType().get(TSDataType.INT32);
            Assert.assertTrue((boolean)previousFill.isUntilLast());
            Assert.assertTrue((boolean)groupByFillPlan.getFillType().containsKey(TSDataType.INT64));
            Assert.assertTrue((boolean)(groupByFillPlan.getFillType().get(TSDataType.INT64) instanceof PreviousFill));
            previousFill = (PreviousFill)groupByFillPlan.getFillType().get(TSDataType.INT64);
            Assert.assertFalse((boolean)previousFill.isUntilLast());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGroupByFill4() {
        String sqlStr = "select last_value(d1.s1), last_value(d2.s1) from root.vehicle group by([8,737), 3ms) fill(boolean[linear])";
        try {
            this.processor.parseSQLToPhysicalPlan(sqlStr);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertEquals((Object)"type BOOLEAN cannot use linear fill function", (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGroupByFill5() {
        String sqlStr = "select last_value(d1.s1), count(d2.s1) from root.vehicle group by([8,737), 3ms) fill(text[linear])";
        try {
            this.processor.parseSQLToPhysicalPlan(sqlStr);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertEquals((Object)"type TEXT cannot use linear fill function", (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGroupByFill6() {
        String sqlStr = "select last_value(d1.s1), last_value(d2.s1) from root.vehicle group by([8,737), 3ms) fill(int32[previousuntillast,10ms], int64[previous,10ms])";
        try {
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            if (!plan.isQuery()) {
                Assert.fail();
            }
            if (!(plan instanceof GroupByTimeFillPlan)) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateFunctionPlan1() {
        try {
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("create function udf as 'org.apache.iotdb.db.query.udf.example.Adder'");
            if (plan.isQuery() || !(plan instanceof CreateFunctionPlan)) {
                Assert.fail();
            }
            CreateFunctionPlan createFunctionPlan = (CreateFunctionPlan)plan;
            Assert.assertEquals((Object)"udf", (Object)createFunctionPlan.getUdfName());
            Assert.assertEquals((Object)"org.apache.iotdb.db.query.udf.example.Adder", (Object)createFunctionPlan.getClassName());
        }
        catch (QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUDTFQuery1() {
        try {
            CreateFunctionPlan createFunctionPlan = (CreateFunctionPlan)this.processor.parseSQLToPhysicalPlan("create function udf as 'org.apache.iotdb.db.query.udf.example.Adder'");
            UDFRegistrationService.getInstance().register(createFunctionPlan.getUdfName(), createFunctionPlan.getClassName(), true);
            String sqlStr = "select udf(d2.s1, d1.s1), udf(d1.s1, d2.s1), d1.s1, d2.s1, udf(d1.s1, d2.s1), udf(d2.s1, d1.s1), d1.s1, d2.s1 from root.vehicle";
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            UDFRegistrationService.getInstance().deregister(createFunctionPlan.getUdfName());
            if (!(plan instanceof UDTFPlan)) {
                Assert.fail();
            }
            UDTFPlan udtfPlan = (UDTFPlan)plan;
            Assert.assertTrue((boolean)udtfPlan.isAlignByTime());
            Assert.assertEquals((long)8L, (long)udtfPlan.getPaths().size());
            Assert.assertEquals((long)8L, (long)udtfPlan.getDataTypes().size());
            Assert.assertEquals((long)2L, (long)udtfPlan.getDeduplicatedPaths().size());
            Assert.assertEquals((long)2L, (long)udtfPlan.getDeduplicatedDataTypes().size());
            Assert.assertEquals((long)4L, (long)udtfPlan.getPathToIndex().size());
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("udf(root.vehicle.d2.s1, root.vehicle.d1.s1)"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("udf(root.vehicle.d1.s1, root.vehicle.d2.s1)"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("root.vehicle.d1.s1"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("root.vehicle.d2.s1"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUDTFQuery2() {
        try {
            CreateFunctionPlan createFunctionPlan = (CreateFunctionPlan)this.processor.parseSQLToPhysicalPlan("create function udf as 'org.apache.iotdb.db.query.udf.example.Adder'");
            UDFRegistrationService.getInstance().register(createFunctionPlan.getUdfName(), createFunctionPlan.getClassName(), true);
            String sqlStr = "select udf(d2.s1, d1.s1, 'addend'='100'), udf(d1.s1, d2.s1), d1.s1, d2.s1, udf(d2.s1, d1.s1) from root.vehicle";
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            UDFRegistrationService.getInstance().deregister(createFunctionPlan.getUdfName());
            if (!(plan instanceof UDTFPlan)) {
                Assert.fail();
            }
            UDTFPlan udtfPlan = (UDTFPlan)plan;
            Assert.assertTrue((boolean)udtfPlan.isAlignByTime());
            Assert.assertEquals((long)5L, (long)udtfPlan.getPaths().size());
            Assert.assertEquals((long)5L, (long)udtfPlan.getDataTypes().size());
            Assert.assertEquals((long)2L, (long)udtfPlan.getDeduplicatedPaths().size());
            Assert.assertEquals((long)2L, (long)udtfPlan.getDeduplicatedDataTypes().size());
            Assert.assertEquals((long)5L, (long)udtfPlan.getPathToIndex().size());
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("udf(root.vehicle.d2.s1, root.vehicle.d1.s1, \"addend\"=\"100\")"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("udf(root.vehicle.d2.s1, root.vehicle.d1.s1)"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("udf(root.vehicle.d1.s1, root.vehicle.d2.s1)"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("root.vehicle.d1.s1"));
            Assert.assertTrue((boolean)udtfPlan.getPathToIndex().containsKey("root.vehicle.d2.s1"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUDTFQuery3() {
        try {
            CreateFunctionPlan createFunctionPlan = (CreateFunctionPlan)this.processor.parseSQLToPhysicalPlan("create function udf as 'org.apache.iotdb.db.query.udf.example.Adder'");
            UDFRegistrationService.getInstance().register(createFunctionPlan.getUdfName(), createFunctionPlan.getClassName(), true);
            String sqlStr = "select *, udf(*, *), *, udf(*, *), * from root.vehicle.**";
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
            UDFRegistrationService.getInstance().deregister(createFunctionPlan.getUdfName());
            if (!(plan instanceof UDTFPlan)) {
                Assert.fail();
            }
            UDTFPlan udtfPlan = (UDTFPlan)plan;
            Assert.assertTrue((boolean)udtfPlan.isAlignByTime());
            Assert.assertEquals((long)44L, (long)udtfPlan.getPaths().size());
            Assert.assertEquals((long)44L, (long)udtfPlan.getDataTypes().size());
            Assert.assertEquals((long)4L, (long)udtfPlan.getDeduplicatedPaths().size());
            Assert.assertEquals((long)4L, (long)udtfPlan.getDeduplicatedDataTypes().size());
            Assert.assertEquals((long)20L, (long)udtfPlan.getPathToIndex().size());
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testDropFunctionPlan() {
        try {
            DropFunctionPlan dropFunctionPlan = (DropFunctionPlan)this.processor.parseSQLToPhysicalPlan("drop function udf");
            Assert.assertEquals((Object)"udf", (Object)dropFunctionPlan.getUdfName());
        }
        catch (QueryProcessException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testQuery1() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 5000";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        GlobalTimeExpression expect = new GlobalTimeExpression((Filter)TimeFilter.gt((long)5000L));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQuery2() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 50 and time <= 100";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        GlobalTimeExpression expect = new GlobalTimeExpression((Filter)FilterFactory.and((Filter)TimeFilter.gt((long)50L), (Filter)TimeFilter.ltEq((long)100L)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQuery3() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 50 and time <= 100 or s1 < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)new OrFilter((Filter)new AndFilter((Filter)TimeFilter.gt((long)50L), (Filter)TimeFilter.ltEq((long)100L)), (Filter)ValueFilter.lt((Comparable)Double.valueOf(10.0))));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQuery4() throws QueryProcessException, IllegalPathException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 50 and time <= 100 and s1 < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)new AndFilter((Filter)ValueFilter.lt((Comparable)Double.valueOf(10.0)), (Filter)new AndFilter((Filter)TimeFilter.gt((long)50L), (Filter)TimeFilter.ltEq((long)100L))));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
        PartialPath path = new PartialPath("root.vehicle.d1.s1");
        Assert.assertEquals((Object)path, plan.getPaths().get(0));
    }

    @Test
    public void testQuery5() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 20 or s1 < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)FilterFactory.or((Filter)ValueFilter.gt((Comparable)Double.valueOf(20.0)), (Filter)ValueFilter.lt((Comparable)Double.valueOf(10.0))));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQuery6() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 20 or time < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        GlobalTimeExpression expect = new GlobalTimeExpression((Filter)FilterFactory.or((Filter)TimeFilter.gt((long)20L), (Filter)TimeFilter.lt((long)10L)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQuery7() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE time > 2019-10-16 10:59:00+08:00 - 1d5h or time < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        GlobalTimeExpression expect = new GlobalTimeExpression((Filter)FilterFactory.or((Filter)TimeFilter.gt((long)1571090340000L), (Filter)TimeFilter.lt((long)10L)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testLimitOffset() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1,root.vehicle.d2 WHERE time < 10 limit 100 offset 10 slimit 1 soffset 1";
        QueryPlan plan = (QueryPlan)this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((long)100L, (long)plan.getRowLimit());
        Assert.assertEquals((long)10L, (long)plan.getRowOffset());
    }

    @Test
    public void testOffsetLimit() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1,root.vehicle.d2 WHERE time < 10 offset 10 limit 100 soffset 1 slimit 1";
        QueryPlan plan = (QueryPlan)this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((long)100L, (long)plan.getRowLimit());
        Assert.assertEquals((long)10L, (long)plan.getRowOffset());
    }

    @Test
    public void testQueryFloat1() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 20.5e3";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(20500.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat2() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 20.5E-3";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(0.0205)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat3() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 2.5";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(2.5)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat4() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 2.5";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(2.5)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat5() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > -2.5";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(-2.5)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat6() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > -2.5E-1";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(-0.25)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat7() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 2.5E2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(250.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat8() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > .2e2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(20.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat9() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > .2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(0.2)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat10() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 2.";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(2.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat11() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > 2.";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(2.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat12() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > -2.";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(-2.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat13() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > -.2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(-0.2)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testQueryFloat14() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 > -.2e2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.gt((Comparable)Double.valueOf(-20.0)));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testInOperator() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 in (25, 30, 40)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        HashSet<Float> values = new HashSet<Float>();
        values.add(Float.valueOf(25.0f));
        values.add(Float.valueOf(30.0f));
        values.add(Float.valueOf(40.0f));
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.in(values, (boolean)false));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testNotInOperator() throws QueryProcessException {
        String sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE s1 not in (25, 30, 40)";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        HashSet<Float> values = new HashSet<Float>();
        values.add(Float.valueOf(25.0f));
        values.add(Float.valueOf(30.0f));
        values.add(Float.valueOf(40.0f));
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.in(values, (boolean)true));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
        sqlStr = "SELECT s1 FROM root.vehicle.d1 WHERE not(s1 not in (25, 30, 40))";
        plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        queryFilter = ((RawDataQueryPlan)plan).getExpression();
        expect = new SingleSeriesExpression(new Path("root.vehicle.d1", "s1"), (Filter)ValueFilter.in(values, (boolean)false));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test
    public void testGrantWatermarkEmbedding() throws QueryProcessException {
        String sqlStr = "GRANT WATERMARK_EMBEDDING to a,b";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        DataAuthPlan dataAuthPlan = (DataAuthPlan)plan;
        Assert.assertEquals((long)2L, (long)dataAuthPlan.getUsers().size());
        Assert.assertEquals((Object)Operator.OperatorType.GRANT_WATERMARK_EMBEDDING, (Object)dataAuthPlan.getOperatorType());
    }

    @Test
    public void testRevokeWatermarkEmbedding() throws QueryProcessException {
        String sqlStr = "REVOKE WATERMARK_EMBEDDING from a,b";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        DataAuthPlan dataAuthPlan = (DataAuthPlan)plan;
        Assert.assertEquals((long)2L, (long)dataAuthPlan.getUsers().size());
        Assert.assertEquals((Object)Operator.OperatorType.REVOKE_WATERMARK_EMBEDDING, (Object)dataAuthPlan.getOperatorType());
    }

    @Test
    public void testConfiguration() throws QueryProcessException {
        String metadata = "load configuration";
        Planner processor = new Planner();
        LoadConfigurationPlan plan = (LoadConfigurationPlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)"LOAD_CONFIGURATION", (Object)plan.toString());
    }

    @Test
    public void testShowFlushInfo() throws QueryProcessException {
        String metadata = "SHOW FLUSH INFO";
        Planner processor = new Planner();
        ShowPlan plan = (ShowPlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)"SHOW FLUSH_TASK_INFO", (Object)plan.toString());
    }

    @Test
    public void testLoadFiles() throws QueryProcessException {
        String filePath = "data" + File.separator + "213213441243-1-2.tsfile";
        String metadata = String.format("load '%s'", filePath);
        Planner processor = new Planner();
        OperateFilePlan plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=true, sgLevel=1, verify=true, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
        metadata = String.format("load '%s' autoregister=true", filePath);
        processor = new Planner();
        plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=true, sgLevel=1, verify=true, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
        metadata = String.format("load '%s' autoregister=false", filePath);
        processor = new Planner();
        plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=false, sgLevel=1, verify=true, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
        metadata = String.format("load '%s' autoregister=true,sglevel=3", filePath);
        processor = new Planner();
        plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=true, sgLevel=3, verify=true, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
        metadata = String.format("load '%s' autoregister=true,sglevel=3,verify=false", filePath);
        processor = new Planner();
        plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=true, sgLevel=3, verify=false, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
        metadata = String.format("load '%s' autoregister=true,sglevel=3,verify=true", filePath);
        processor = new Planner();
        plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=true, sgLevel=3, verify=true, operatorType=LOAD_FILES}", filePath), (Object)plan.toString());
    }

    @Test
    public void testRemoveFile() throws QueryProcessException {
        String filePath = "data" + File.separator + "213213441243-1-2.tsfile";
        String metadata = String.format("remove '%s'", filePath);
        Planner processor = new Planner();
        OperateFilePlan plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=null, autoCreateSchema=false, sgLevel=0, verify=false, operatorType=REMOVE_FILE}", filePath), (Object)plan.toString());
    }

    @Test
    public void testUnloadFile() throws QueryProcessException {
        String filePath = "data" + File.separator + "213213441243-1-2.tsfile";
        String targetDir = "user" + File.separator + "backup";
        String metadata = String.format("unload '%s' '%s'", filePath, targetDir);
        Planner processor = new Planner();
        OperateFilePlan plan = (OperateFilePlan)processor.parseSQLToPhysicalPlan(metadata);
        Assert.assertEquals((Object)String.format("OperateFilePlan{file=%s, targetDir=%s, autoCreateSchema=false, sgLevel=0, verify=false, operatorType=UNLOAD_FILE}", filePath, targetDir), (Object)plan.toString());
    }

    @Test
    public void testDeduplicatedPath() throws Exception {
        String sqlStr = "select * from root.vehicle.d1,root.vehicle.d1,root.vehicle.d1";
        RawDataQueryPlan plan = (RawDataQueryPlan)this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((long)1L, (long)plan.getDeduplicatedPaths().size());
        Assert.assertEquals((long)1L, (long)plan.getDeduplicatedDataTypes().size());
        Assert.assertEquals((Object)new Path("root.vehicle.d1", "s1"), plan.getDeduplicatedPaths().get(0));
        sqlStr = "select count(*) from root.vehicle.d1,root.vehicle.d1,root.vehicle.d1";
        plan = (RawDataQueryPlan)this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((long)1L, (long)plan.getDeduplicatedPaths().size());
        Assert.assertEquals((long)1L, (long)plan.getDeduplicatedDataTypes().size());
        Assert.assertEquals((Object)new Path("root.vehicle.d1", "s1"), plan.getDeduplicatedPaths().get(0));
    }

    @Test
    public void testLastPlanPaths() throws QueryProcessException {
        String sqlStr1 = "SELECT last s1 FROM root.vehicle.d1";
        String sqlStr2 = "SELECT last s1 FROM root.vehicle.d1, root.vehicle.d2";
        PhysicalPlan plan1 = this.processor.parseSQLToPhysicalPlan(sqlStr1);
        PhysicalPlan plan2 = this.processor.parseSQLToPhysicalPlan(sqlStr2);
        Path path1 = new Path("root.vehicle.d1", "s1");
        Path path2 = new Path("root.vehicle.d2", "s1");
        Assert.assertEquals((long)1L, (long)plan1.getPaths().size());
        Assert.assertEquals((Object)path1.toString(), (Object)((PartialPath)plan1.getPaths().get(0)).getFullPath());
        Assert.assertEquals((long)2L, (long)plan2.getPaths().size());
        Assert.assertEquals((Object)path1.toString(), (Object)((PartialPath)plan2.getPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)path2.toString(), (Object)((PartialPath)plan2.getPaths().get(1)).getFullPath());
    }

    @Test
    public void testLastPlanDataTypes() throws QueryProcessException {
        String sqlStr1 = "SELECT last s1 FROM root.vehicle.d1";
        String sqlStr2 = "SELECT last s1 FROM root.vehicle.d2, root.vehicle.d3, root.vehicle.d4";
        PhysicalPlan plan1 = this.processor.parseSQLToPhysicalPlan(sqlStr1);
        PhysicalPlan plan2 = this.processor.parseSQLToPhysicalPlan(sqlStr2);
        Assert.assertEquals((long)1L, (long)((LastQueryPlan)plan1).getDataTypes().size());
        TSDataType dataType = (TSDataType)((LastQueryPlan)plan1).getDataTypes().get(0);
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)dataType);
        Assert.assertEquals((long)3L, (long)((LastQueryPlan)plan2).getDataTypes().size());
        for (TSDataType dt : ((LastQueryPlan)plan2).getDataTypes()) {
            Assert.assertEquals((Object)TSDataType.FLOAT, (Object)dt);
        }
    }

    @Test
    public void testDelete1() throws QueryProcessException, IllegalPathException {
        PartialPath path = new PartialPath("root.vehicle.d1.s1");
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(Collections.singletonList(path));
        String sqlStr = "delete FROM root.vehicle.d1.s1 WHERE time < 5000";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE, (Object)plan.getOperatorType());
        Assert.assertEquals(pathList, (Object)plan.getPaths());
    }

    @Test
    public void testDelete2() throws QueryProcessException, IllegalPathException {
        PartialPath path1 = new PartialPath("root.vehicle.d1.s1");
        PartialPath path2 = new PartialPath("root.vehicle.d1.s2");
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(Arrays.asList(path1, path2));
        String sqlStr = "delete FROM root.vehicle.d1.s1,root.vehicle.d1.s2 WHERE time < 5000";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE, (Object)plan.getOperatorType());
        Assert.assertEquals(pathList, (Object)plan.getPaths());
    }

    @Test
    public void testDelete3() throws QueryProcessException, IllegalPathException {
        PartialPath path1 = new PartialPath("root.vehicle.d1.s1");
        PartialPath path2 = new PartialPath("root.vehicle.d2.s3");
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(Arrays.asList(path1, path2));
        String sqlStr = "delete FROM root.vehicle.d1.s1,root.vehicle.d2.s3 WHERE time < 5000";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE, (Object)plan.getOperatorType());
        Assert.assertEquals(pathList, (Object)plan.getPaths());
    }

    @Test
    public void testSpecialCharacters() throws QueryProcessException {
        String sqlStr1 = "create timeseries root.`3e-3`.`-1+1/2`.`SNAPPY`.`RLE`.`81+12+2s/io`.`in[jack]`.`hel[jjj[]s[1]`.`desc` with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        PhysicalPlan plan1 = this.processor.parseSQLToPhysicalPlan(sqlStr1);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_TIMESERIES, (Object)plan1.getOperatorType());
    }

    @Test
    public void testTimeRangeDelete() throws QueryProcessException, IllegalPathException {
        String sqlStr1 = "DELETE FROM root.vehicle.d1 where time >= 1 and time <= 2";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr1);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)plan.getPaths(), Collections.singletonList(new PartialPath("root.vehicle.d1")));
        Assert.assertEquals((long)1L, (long)((DeletePlan)plan).getDeleteStartTime());
        Assert.assertEquals((long)2L, (long)((DeletePlan)plan).getDeleteEndTime());
    }

    @Test
    public void testCreateTrigger1() throws QueryProcessException {
        String sql = "CREATE TRIGGER trigger1 BEFORE INSERT ON root.sg1.d1.s1 AS 'org.apache.iotdb.engine.trigger.Example'";
        CreateTriggerPlan plan = (CreateTriggerPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"trigger1", (Object)plan.getTriggerName());
        Assert.assertEquals((Object)TriggerEvent.BEFORE_INSERT, (Object)plan.getEvent());
        Assert.assertEquals((Object)"root.sg1.d1.s1", (Object)plan.getFullPath().getFullPath());
        Assert.assertEquals((Object)"org.apache.iotdb.engine.trigger.Example", (Object)plan.getClassName());
    }

    @Test
    public void testCreateTrigger2() throws QueryProcessException {
        String sql = "CREATE TRIGGER trigger2 AFTER INSERT ON root.sg1.d1.s2 AS 'org.apache.iotdb.engine.trigger.Example'WITH ('key1'='value1', 'key2'='value2')";
        CreateTriggerPlan plan = (CreateTriggerPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"trigger2", (Object)plan.getTriggerName());
        Assert.assertEquals((Object)TriggerEvent.AFTER_INSERT, (Object)plan.getEvent());
        Assert.assertEquals((Object)"root.sg1.d1.s2", (Object)plan.getFullPath().getFullPath());
        Assert.assertEquals((Object)"org.apache.iotdb.engine.trigger.Example", (Object)plan.getClassName());
        HashMap<String, String> expectedAttributes = new HashMap<String, String>();
        expectedAttributes.put("key1", "value1");
        expectedAttributes.put("key2", "value2");
        Assert.assertEquals(expectedAttributes, (Object)plan.getAttributes());
    }

    @Test
    public void testDropTrigger() throws QueryProcessException {
        String sql = "DROP TRIGGER trigger1";
        DropTriggerPlan plan = (DropTriggerPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"trigger1", (Object)plan.getTriggerName());
    }

    @Test
    public void testStartTrigger() throws QueryProcessException {
        String sql = "START TRIGGER `my-trigger`";
        StartTriggerPlan plan = (StartTriggerPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"my-trigger", (Object)plan.getTriggerName());
    }

    @Test
    public void testStopTrigger() throws QueryProcessException {
        String sql = "STOP TRIGGER `my-trigger`";
        StopTriggerPlan plan = (StopTriggerPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"my-trigger", (Object)plan.getTriggerName());
    }

    @Test
    public void testShowTriggers() throws QueryProcessException {
        String sql = "SHOW TRIGGERS";
        ShowTriggersPlan plan = (ShowTriggersPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertTrue((boolean)plan.isQuery());
        Assert.assertEquals((Object)ShowPlan.ShowContentType.TRIGGERS, (Object)plan.getShowContentType());
    }

    @Test
    public void testCreateCQ1() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s) END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)10000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)10000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}.${2}.${3}.${4}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 10s, now()), 10s)", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ2() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)10000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)10000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}.${2}.${3}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 10s, now()), 10s), level = 3", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ3() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 RESAMPLE EVERY 20s BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)20000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)10000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}.${2}.${3}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 10s, now()), 10s), level = 3", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ4() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 RESAMPLE EVERY 20s FOR 10s BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)20000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)10000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}.${2}.${3}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 10s, now()), 10s), level = 3", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ5() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 RESAMPLE FOR 20s BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)10000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)20000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}.${2}.${3}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 20s, now()), 10s), level = 3", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ6() throws QueryProcessException {
        String sql = "CREATE CQ cq1 RESAMPLE FOR 20s BEGIN SELECT max_value(temperature) INTO root.${a4}.${3}.temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        try {
            CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("the x of ${x} should be an integer."));
        }
    }

    @Test
    public void testCreateCQ7() throws QueryProcessException {
        String sql = "CREATE CQ cq1 RESAMPLE FOR 20s BEGIN SELECT max_value(temperature) INTO root.${4}.${3}.temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        try {
            CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("the x of ${x} should be greater than 0 and equal to or less than <level> or the length of queried path prefix."));
        }
    }

    @Test
    public void testCreateCQ8() throws QueryProcessException {
        String sql = "CREATE CONTINUOUS QUERY cq1 BEGIN SELECT max_value(temperature) INTO root.${1}_cq.${2}.${3}.temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
        Assert.assertEquals((long)10000L, (long)plan.getEveryInterval());
        Assert.assertEquals((long)10000L, (long)plan.getForInterval());
        Assert.assertEquals((Object)"root.${1}_cq.${2}.${3}.temperature_max", (Object)plan.getTargetPath().getFullPath());
        Assert.assertEquals((Object)"select max_value(temperature) from root.ln.*.*.* group by ([now() - 10s, now()), 10s), level = 3", (Object)plan.getQuerySql());
    }

    @Test
    public void testCreateCQ9() throws QueryProcessException {
        String sql = "CREATE CQ cq1 RESAMPLE FOR 20s BEGIN SELECT max_value(temperature) INTO root.${0}.${3}.temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        try {
            CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("the x of ${x} should be greater than 0 and equal to or less than <level> or the length of queried path prefix."));
        }
    }

    @Test
    public void testCreateCQ10() throws QueryProcessException {
        String sql = "CREATE CQ cq1 RESAMPLE FOR 20s BEGIN SELECT max_value(temperature), avg(temperature) INTO root.${0}.${3}.temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END";
        try {
            CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertEquals((Object)"CQ: CQ currently does not support multiple result columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateCQ11() throws QueryProcessException {
        long minEveryInterval = IoTDBDescriptor.getInstance().getConfig().getContinuousQueryMinimumEveryInterval();
        long everyInterval = minEveryInterval / 2L;
        String sql = String.format("CREATE CQ cq1 RESAMPLE EVERY %dms FOR 20s BEGIN SELECT max_value(temperature) INTO temperature_max FROM root.ln.*.*.* GROUP BY time(10s), level = 3 END", everyInterval);
        try {
            CreateContinuousQueryPlan plan = (CreateContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
            Assert.fail();
        }
        catch (SQLParserException e) {
            Assert.assertEquals((Object)"CQ: every interval should not be lower than the minimum value you configured.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDropCQ() throws QueryProcessException {
        String sql = "DROP CONTINUOUS QUERY cq1";
        DropContinuousQueryPlan plan = (DropContinuousQueryPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertFalse((boolean)plan.isQuery());
        Assert.assertEquals((Object)"cq1", (Object)plan.getContinuousQueryName());
    }

    @Test
    public void testShowCQs() throws QueryProcessException {
        String sql = "SHOW CONTINUOUS QUERIES";
        ShowContinuousQueriesPlan plan = (ShowContinuousQueriesPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertTrue((boolean)plan.isQuery());
    }

    @Test
    public void testShowFunction() throws QueryProcessException {
        String sql = "SHOW FUNCTIONS";
        ShowFunctionsPlan plan = (ShowFunctionsPlan)this.processor.parseSQLToPhysicalPlan(sql);
        Assert.assertTrue((boolean)plan.isQuery());
        Assert.assertEquals((Object)ShowPlan.ShowContentType.FUNCTIONS, (Object)plan.getShowContentType());
    }

    @Test
    public void testCreateStorageGroup() throws QueryProcessException {
        String sqlStr = "CREATE STORAGE GROUP root.sg";
        SetStorageGroupPlan plan = (SetStorageGroupPlan)this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((Object)"SetStorageGroup{root.sg}", (Object)plan.toString());
    }

    @Test
    public void testRegexpQuery() throws QueryProcessException, MetadataException {
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d5.s1"), TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        String sqlStr = "SELECT * FROM root.vehicle.d5 WHERE s1 REGEXP 'string*'";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        IExpression queryFilter = ((RawDataQueryPlan)plan).getExpression();
        SingleSeriesExpression expect = new SingleSeriesExpression(new Path("root.vehicle.d5", "s1"), (Filter)ValueFilter.like((String)"string*"));
        Assert.assertEquals((Object)expect.toString(), (Object)queryFilter.toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSerializationError() {
        ShowDevicesPlan plan = new ShowDevicesPlan();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        plan.serialize(byteBuffer);
    }

    @Test(expected=NullPointerException.class)
    public void testSerializationRollback() {
        InsertRowPlan plan = new InsertRowPlan();
        plan.setTime(0L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        byteBuffer.putInt(0);
        long position = byteBuffer.position();
        try {
            plan.serialize(byteBuffer);
        }
        catch (NullPointerException e) {
            Assert.assertEquals((long)position, (long)byteBuffer.position());
            throw e;
        }
    }
}

