/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class InsertRowsOfOneDevicePlanTest {
    @Test
    public void testSerializable() throws IllegalPathException, IOException {
        PartialPath device = new PartialPath("root.sg.d");
        InsertRowPlan[] rowPlans = new InsertRowPlan[]{new InsertRowPlan(device, 1000L, new String[]{"s1", "s2", "s3"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64}, new String[]{"1.0", "2", "300"}, true), new InsertRowPlan(device, 2000L, new String[]{"s1", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.TEXT}, new String[]{"2.0", "abc"}, true)};
        InsertRowsOfOneDevicePlan p = new InsertRowsOfOneDevicePlan(device, rowPlans, new int[]{0, 1});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream w = new DataOutputStream(baos);
        p.serialize(w);
        w.flush();
        byte[] res = baos.toByteArray();
        ByteBuffer buf = ByteBuffer.wrap(res);
        InsertRowsOfOneDevicePlan p2 = (InsertRowsOfOneDevicePlan)PhysicalPlan.Factory.create((ByteBuffer)buf);
        Assert.assertEquals((Object)p, (Object)p2);
        res = new byte[1024];
        p.serialize(ByteBuffer.wrap(res));
        buf = ByteBuffer.wrap(res);
        p2 = (InsertRowsOfOneDevicePlan)PhysicalPlan.Factory.create((ByteBuffer)buf);
        Assert.assertEquals((Object)p, (Object)p2);
    }
}

