/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertRowPlanTest {
    private final Planner processor = new Planner();

    @Before
    public void before() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testInsertRowPlan() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        InsertRowPlan rowPlan = this.getInsertRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(rowPlan);
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)6L, (long)dataSet.getPaths().size());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)6L, (long)record.getFields().size());
        }
    }

    @Test
    public void testInsertRowPlanWithAlignedTimeseries() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        InsertRowPlan vectorRowPlan = this.getInsertAlignedRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(vectorRowPlan);
        Assert.assertEquals((Object)"[s1, s2, s3]", (Object)Arrays.toString(vectorRowPlan.getMeasurementMNodes()));
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1.GPS");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)1L, (long)dataSet.getPaths().size());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)3L, (long)record.getFields().size());
        }
    }

    @Test
    public void testInsertRowPlanWithTreeSchemaTemplate() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("GPS.s1", "GPS.s2", "GPS.s3");
        measurementList.add(v1);
        List<String> v2 = Arrays.asList("GPS2.s4", "GPS2.s5");
        measurementList.add(v2);
        measurementList.add(Collections.singletonList("s6"));
        ArrayList<List<TSDataType>> dataTypesList = new ArrayList<List<TSDataType>>();
        List<TSDataType> d1 = Arrays.asList(TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64);
        dataTypesList.add(d1);
        List<TSDataType> d2 = Arrays.asList(TSDataType.INT32, TSDataType.BOOLEAN);
        dataTypesList.add(d2);
        dataTypesList.add(Collections.singletonList(TSDataType.TEXT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        List<TSEncoding> e1 = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN);
        encodingList.add(e1);
        List<TSEncoding> e2 = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN);
        encodingList.add(e2);
        encodingList.add(Collections.singletonList(TSEncoding.PLAIN));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY, CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY));
        CreateTemplatePlan plan = new CreateTemplatePlan("templateN", measurementList, dataTypesList, encodingList, compressionTypes);
        IoTDB.metaManager.createSchemaTemplate(plan);
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("templateN", "root.isp.d1"));
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(false);
        InsertRowPlan rowPlan = this.getInsertAlignedRowPlan(111L);
        PlanExecutor executor = new PlanExecutor();
        executor.insert(rowPlan);
        rowPlan = this.getInsertAlignedRowPlan(112L);
        executor.insert(rowPlan);
        rowPlan = this.getInsertAlignedRowPlan(113L);
        executor.insert(rowPlan);
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1.GPS");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)1L, (long)dataSet.getPaths().size());
        int resSize = 0;
        while (dataSet.hasNext()) {
            Assert.assertEquals((long)3L, (long)dataSet.next().getFields().size());
            ++resSize;
        }
        Assert.assertEquals((long)3L, (long)resSize);
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.TEXT};
        String[] columns = new String[]{"a"};
        rowPlan = new InsertRowPlan(new PartialPath("root.isp.d1"), 1111L, new String[]{"s6"}, dataTypes, columns, false);
        executor.insert(rowPlan);
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)1L, (long)dataSet.getPaths().size());
        Assert.assertEquals((Object)true, (Object)dataSet.hasNext());
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1.**");
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)2L, (long)dataSet.getPaths().size());
        Assert.assertEquals((Object)true, (Object)dataSet.hasNext());
        Assert.assertEquals((long)5L, (long)dataSet.next().getFields().size());
    }

    @Test
    public void testInsertRowPlanWithSchemaTemplate() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        for (int i = 1; i <= 6; ++i) {
            measurementList.add(Collections.singletonList("s" + i));
        }
        ArrayList<List<TSDataType>> dataTypesList = new ArrayList<List<TSDataType>>();
        dataTypesList.add(Collections.singletonList(TSDataType.DOUBLE));
        dataTypesList.add(Collections.singletonList(TSDataType.FLOAT));
        dataTypesList.add(Collections.singletonList(TSDataType.INT64));
        dataTypesList.add(Collections.singletonList(TSDataType.INT32));
        dataTypesList.add(Collections.singletonList(TSDataType.BOOLEAN));
        dataTypesList.add(Collections.singletonList(TSDataType.TEXT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        for (int i = 1; i <= 6; ++i) {
            encodingList.add(Collections.singletonList(TSEncoding.PLAIN));
        }
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        for (int i = 1; i <= 6; ++i) {
            compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        for (int i = 1; i <= 6; ++i) {
            schemaNames.add("s" + i);
        }
        CreateTemplatePlan plan = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypesList, encodingList, compressionTypes);
        IoTDB.metaManager.createSchemaTemplate(plan);
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("template1", "root.isp.d1"));
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(false);
        InsertRowPlan rowPlan = this.getInsertRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(rowPlan);
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)6L, (long)dataSet.getPaths().size());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)6L, (long)record.getFields().size());
        }
        executor.processNonQuery((PhysicalPlan)new DeactivateTemplatePlan("template1", "root.isp.d1"));
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)0L, (long)dataSet.getPaths().size());
        executor.insert(rowPlan);
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int rCnt = 0;
        while (dataSet.hasNext()) {
            ++rCnt;
            dataSet.next();
        }
        Assert.assertEquals((long)1L, (long)rCnt);
        executor.processNonQuery((PhysicalPlan)new DeactivateTemplatePlan("template1", "root.isp.d1"));
        executor.processNonQuery((PhysicalPlan)new UnsetTemplatePlan("root.isp.d1", "template1"));
        rowPlan.getDataTypes()[0] = TSDataType.TEXT;
        rowPlan.getValues()[0] = Binary.valueOf((String)"aaa");
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        executor.insert(rowPlan);
        queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        rCnt = 0;
        while (dataSet.hasNext()) {
            ++rCnt;
            dataSet.next();
        }
        Assert.assertEquals((long)1L, (long)rCnt);
    }

    @Test
    public void testInsertRowSerialization() throws IllegalPathException, QueryProcessException {
        InsertRowPlan plan1 = this.getInsertAlignedRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(plan1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        plan1.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PhysicalPlan.PhysicalPlanType.INSERT.ordinal(), (long)byteBuffer.get());
        InsertRowPlan plan2 = new InsertRowPlan();
        plan2.deserialize(byteBuffer);
        executor.insert(plan2);
        Assert.assertEquals((Object)plan1, (Object)plan2);
    }

    @Test
    public void testInsertRowPlanWithSchemaTemplateFormer() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        ArrayList<List<Object>> measurementList = new ArrayList<List<Object>>();
        ArrayList<String> v1 = new ArrayList<String>();
        v1.add("GPS.s1");
        v1.add("GPS.s2");
        v1.add("GPS.s3");
        measurementList.add(v1);
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("GPS2.s4");
        v2.add("GPS2.s5");
        measurementList.add(v2);
        measurementList.add(Collections.singletonList("s6"));
        ArrayList<List<Object>> dataTypesList = new ArrayList<List<Object>>();
        ArrayList<TSDataType> d1 = new ArrayList<TSDataType>();
        d1.add(TSDataType.DOUBLE);
        d1.add(TSDataType.FLOAT);
        d1.add(TSDataType.INT64);
        dataTypesList.add(d1);
        ArrayList<TSDataType> d2 = new ArrayList<TSDataType>();
        d2.add(TSDataType.INT32);
        d2.add(TSDataType.BOOLEAN);
        dataTypesList.add(d2);
        dataTypesList.add(Collections.singletonList(TSDataType.TEXT));
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        ArrayList<TSEncoding> e1 = new ArrayList<TSEncoding>();
        e1.add(TSEncoding.PLAIN);
        e1.add(TSEncoding.PLAIN);
        e1.add(TSEncoding.PLAIN);
        encodingList.add(e1);
        ArrayList<TSEncoding> e2 = new ArrayList<TSEncoding>();
        e2.add(TSEncoding.PLAIN);
        e2.add(TSEncoding.PLAIN);
        encodingList.add(e2);
        encodingList.add(Collections.singletonList(TSEncoding.PLAIN));
        ArrayList compressionTypes = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
            for (int j = 0; j < 3; ++j) {
                compressorList.add(CompressionType.SNAPPY);
            }
            compressionTypes.add(compressorList);
        }
        CreateTemplatePlan plan = new CreateTemplatePlan("template1", measurementList, dataTypesList, encodingList, compressionTypes);
        IoTDB.metaManager.createSchemaTemplate(plan);
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("template1", "root.isp.d1"));
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(false);
        InsertRowPlan rowPlan = this.getInsertAlignedRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(rowPlan);
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1.GPS");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)1L, (long)dataSet.getPaths().size());
        Assert.assertEquals((Object)true, (Object)dataSet.hasNext());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)3L, (long)record.getFields().size());
        }
    }

    private InsertRowPlan getInsertRowPlan() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath("root.isp.d1"), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }

    private InsertRowPlan getInsertAlignedRowPlan() throws IllegalPathException {
        return this.getInsertAlignedRowPlan(110L);
    }

    private InsertRowPlan getInsertAlignedRowPlan(long time) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64};
        String[] columns = new String[]{"1.0", "2", "10000"};
        return new InsertRowPlan(new PartialPath("root.isp.d1.GPS"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, true);
    }
}

