/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class IoTDBRestServiceIT {
    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private String getAuthorization(String username, String password) {
        return Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ping() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet("http://127.0.0.1:18080/ping");
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((long)200L, (long)Integer.parseInt(result.get("code").toString()));
            RPCService.getInstance().stop();
            response = httpClient.execute((HttpUriRequest)httpGet);
            responseEntity = response.getEntity();
            message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)503L, (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((long)500L, (long)Integer.parseInt(result.get("code").toString()));
            RPCService.getInstance().start();
        }
        catch (IOException | StartupException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private HttpPost getHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        String authorization = this.getAuthorization("root", "root");
        httpPost.setHeader("Authorization", authorization);
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rightInsertTablet(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/insertTablet");
            String json = "{\"timestamps\":[1635232143960,1635232153960],\"measurements\":[\"s3\",\"s4\",\"s5\",\"s6\",\"s7\",\"s8\"],\"dataTypes\":[\"TEXT\",\"INT32\",\"INT64\",\"FLOAT\",\"BOOLEAN\",\"DOUBLE\"],\"values\":[[\"2aa\",\"\"],[11,2],[1635000012345555,1635000012345556],[1.41,null],[null,false],[null,3.5555]],\"isAligned\":false,\"deviceId\":\"root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)200L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInsertTablet() {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/insertTablet");
            String json = "{\"timestamps\":[1635232143960,1635232153960],\"measurements\":[\"s3\",\"s4\",\"s5\",\"s6\",\"s7\",\"s8\"],\"dataTypes\":[\"TEXT\",\"INT32\",\"INT64\",\"FLOAT\",\"BOOLEAN\",\"DOUBLE\"],\"values\":[[\"2aa\",\"\"],[111111112312312442352545452323123,2],[16,15],[1.41,null],[null,false],[null,3.55555555555555555555555555555555555555555555312234235345123127318927461482308478123645555555555555555555555555555555555555555555531223423534512312731892746148230847812364]],\"isAligned\":false,\"deviceId\":\"root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)413L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void insertAndQuery() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        this.query(httpClient);
        this.queryGroupByLevel(httpClient);
        this.queryRowLimit(httpClient);
        this.queryShowChildPaths(httpClient);
        this.queryShowNodes(httpClient);
        this.showAllTTL(httpClient);
        this.showStorageGroup(httpClient);
        this.showFunctions(httpClient);
        this.showTimeseries(httpClient);
        this.showLastTimeseries(httpClient);
        this.countTimeseries(httpClient);
        this.countNodes(httpClient);
        this.showDevices(httpClient);
        this.showDevicesWithStroage(httpClient);
        this.listUser(httpClient);
        this.selectCount(httpClient);
        this.selectLast(httpClient);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryWithUnsetAuthorization() {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost("http://127.0.0.1:18080/rest/v1/query");
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            String sql = "{\"sql\":\"select *,s4+1,s4+1 from root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
            String message = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)603L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryWithWrongAuthorization() {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost("http://127.0.0.1:18080/rest/v1/query");
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            String authorization = this.getAuthorization("abc", "def");
            httpPost.setHeader("Authorization", authorization);
            String sql = "{\"sql\":\"select *,s4+1,s4+1 from root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
            String message = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)600L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/query");
            String sql = "{\"sql\":\"select *,s4+1,s4+1 from root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            List timestampsResult = (List)map.get("timestamps");
            List expressionsResult = (List)map.get("expressions");
            List valuesResult = (List)map.get("values");
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            ArrayList<Object> expressions = new ArrayList<Object>(){
                {
                    this.add("root.sg25.s3");
                    this.add("root.sg25.s4");
                    this.add("root.sg25.s5");
                    this.add("root.sg25.s6");
                    this.add("root.sg25.s7");
                    this.add("root.sg25.s8");
                    this.add("root.sg25.s4 + 1");
                    this.add("root.sg25.s4 + 1");
                }
            };
            ArrayList<Object> timestamps = new ArrayList<Object>(){
                {
                    this.add(1635232143960L);
                    this.add(1635232153960L);
                }
            };
            ArrayList<Object> values1 = new ArrayList<Object>(){
                {
                    this.add("2aa");
                    this.add("");
                }
            };
            ArrayList<Object> values2 = new ArrayList<Object>(){
                {
                    this.add(11);
                    this.add(2);
                }
            };
            ArrayList<Object> values3 = new ArrayList<Object>(){
                {
                    this.add(1635000012345555L);
                    this.add(1635000012345556L);
                }
            };
            ArrayList<Object> values4 = new ArrayList<Object>(){
                {
                    this.add(1.41);
                    this.add(null);
                }
            };
            ArrayList<Object> values5 = new ArrayList<Object>(){
                {
                    this.add(null);
                    this.add(false);
                }
            };
            ArrayList<Object> values6 = new ArrayList<Object>(){
                {
                    this.add(null);
                    this.add(3.5555);
                }
            };
            Assert.assertEquals((Object)expressions, (Object)expressionsResult);
            Assert.assertEquals((Object)timestamps, (Object)timestampsResult);
            Assert.assertEquals((Object)values1, valuesResult.get(0));
            Assert.assertEquals((Object)values2, valuesResult.get(1));
            Assert.assertEquals((Object)values3, valuesResult.get(2));
            Assert.assertEquals((Object)values4, valuesResult.get(3));
            Assert.assertEquals((Object)values5, valuesResult.get(4));
            Assert.assertEquals((Object)values6, valuesResult.get(5));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryGroupByLevel(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/query");
            String sql = "{\"sql\":\"select count(s4) from root.sg25 group by([1635232143960,1635232153960),1s),level=1\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            List timestampsResult = (List)map.get("timestamps");
            List expressionsResult = (List)map.get("expressions");
            List valuesResult = (List)map.get("values");
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((timestampsResult.size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((valuesResult.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)"count(root.sg25.s4)".equals(expressionsResult.get(0)));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryRowLimit(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/query");
            String sql = "{\"sql\":\"select *,s4+1,s4+1 from root.sg25\",\"rowLimit\":1}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            Assert.assertTrue((boolean)message.contains("row size exceeded the given max row size"));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map queryMetaData(CloseableHttpClient httpClient, String sql) {
        CloseableHttpResponse response = null;
        try {
            Map map;
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/query");
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map2 = map = (Map)mapper.readValue(message, Map.class);
            return map2;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        return null;
    }

    public void queryShowChildPaths(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show child paths root\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("child paths");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void queryShowNodes(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show child nodes root\",\"rowLimit\":1}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("child nodes");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("sg25");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void showAllTTL(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show all ttl\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("storage group");
                this.add("ttl");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add(null);
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals((Object)values2, valuesResult.get(1));
    }

    public void showStorageGroup(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show storage group root.*\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("storage group");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void showFunctions(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show functions\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertEquals((long)3L, (long)columnNamesResult.size());
        Assert.assertEquals((long)3L, (long)valuesResult.size());
    }

    public void showTimeseries(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show timeseries\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("timeseries");
                this.add("alias");
                this.add("storage group");
                this.add("dataType");
                this.add("encoding");
                this.add("compression");
                this.add("tags");
                this.add("attributes");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25.s3");
                this.add("root.sg25.s4");
                this.add("root.sg25.s5");
                this.add("root.sg25.s6");
                this.add("root.sg25.s7");
                this.add("root.sg25.s8");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
            }
        };
        ArrayList<Object> values3 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals((Object)values2, valuesResult.get(1));
        Assert.assertEquals((Object)values3, valuesResult.get(2));
    }

    public void showLastTimeseries(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"SHOW LATEST TIMESERIES\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("timeseries");
                this.add("alias");
                this.add("storage group");
                this.add("dataType");
                this.add("encoding");
                this.add("compression");
                this.add("tags");
                this.add("attributes");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25.s3");
                this.add("root.sg25.s4");
                this.add("root.sg25.s5");
                this.add("root.sg25.s7");
                this.add("root.sg25.s8");
                this.add("root.sg25.s6");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
                this.add(null);
            }
        };
        ArrayList<Object> values3 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
                this.add("root.sg25");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals((Object)values2, valuesResult.get(1));
        Assert.assertEquals((Object)values3, valuesResult.get(2));
    }

    public void countTimeseries(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"COUNT TIMESERIES root.** GROUP BY LEVEL=1\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("column");
                this.add("count");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add(6);
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals((Object)values2, valuesResult.get(1));
    }

    public void countNodes(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"count nodes root.** level=2\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("count");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add(6);
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void showDevices(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show devices\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("devices");
                this.add("isAligned");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        ArrayList<Boolean> values2 = new ArrayList<Boolean>(){
            {
                this.add(false);
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void showDevicesWithStroage(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"show devices with storage group\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("devices");
                this.add("storage group");
                this.add("isAligned");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add("root.sg25");
            }
        };
        ArrayList<Object> values3 = new ArrayList<Object>(){
            {
                this.add("false");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals((Object)values2, valuesResult.get(1));
        Assert.assertEquals((Object)values3, valuesResult.get(2));
    }

    public void listUser(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"list user\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("user");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void selectCount(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"select count(s3) from root.** group by level = 1\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("count(root.sg25.s3)");
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add(2);
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
    }

    public void selectLast(CloseableHttpClient httpClient) {
        String sql = "{\"sql\":\"select last s4 from root.sg25\"}";
        Map map = this.queryMetaData(httpClient, sql);
        List columnNamesResult = (List)map.get("columnNames");
        List valuesResult = (List)map.get("values");
        List timestampsResult = (List)map.get("timestamps");
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> columnNames = new ArrayList<Object>(){
            {
                this.add("timeseries");
                this.add("value");
                this.add("dataType");
            }
        };
        ArrayList<Long> timestamps = new ArrayList<Long>(){
            {
                this.add(1635232153960L);
            }
        };
        ArrayList<Object> values1 = new ArrayList<Object>(){
            {
                this.add("root.sg25.s4");
            }
        };
        ArrayList<Object> values2 = new ArrayList<Object>(){
            {
                this.add("2");
            }
        };
        ArrayList<Object> values3 = new ArrayList<Object>(){
            {
                this.add("INT32");
            }
        };
        Assert.assertEquals((Object)columnNames, (Object)columnNamesResult);
        Assert.assertEquals((Object)timestamps, (Object)timestampsResult);
        Assert.assertEquals((Object)values1, valuesResult.get(0));
        Assert.assertEquals(values2.get(0), ((List)valuesResult.get(1)).get(0));
        Assert.assertEquals((Object)values3, valuesResult.get(2));
    }
}

