/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mqtt;

import io.moquette.interception.messages.InterceptConnectMessage;
import io.moquette.interception.messages.InterceptDisconnectMessage;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatManager;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.protocol.mqtt.PublishHandler;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PublishHandlerTest {
    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void onPublish() throws ClassNotFoundException {
        PayloadFormatter payloadFormat = PayloadFormatManager.getPayloadFormat((String)"json");
        PublishHandler handler = new PublishHandler(payloadFormat);
        String payload = "{\n\"device\":\"root.sg.d1\",\n\"timestamp\":1586076045524,\n\"measurements\":[\"s1\"],\n\"values\":[0.530635]\n}";
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)payload, (Charset)StandardCharsets.UTF_8);
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(null, null, "test", "root", "root");
        MqttConnectMessage mqttConnectMessage = new MqttConnectMessage(null, null, mqttConnectPayload);
        InterceptConnectMessage interceptConnectMessage = new InterceptConnectMessage(mqttConnectMessage);
        handler.onConnect(interceptConnectMessage);
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader("root.sg.d1", 1);
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, false, 1);
        MqttPublishMessage publishMessage = new MqttPublishMessage(fixedHeader, variableHeader, buf);
        InterceptPublishMessage message = new InterceptPublishMessage(publishMessage, null, null);
        handler.onPublish(message);
        InterceptDisconnectMessage interceptDisconnectMessage = new InterceptDisconnectMessage(null, null);
        handler.onDisconnect(interceptDisconnectMessage);
        String[] retArray = new String[]{"1586076045524,0.530635,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.sg.d1");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int cnt = 0;
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

