/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.input;

import java.util.ArrayList;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineParser;
import org.influxdb.dto.Point;
import org.junit.Assert;
import org.junit.Test;

public class InfluxLineParserTest {
    @Test
    public void parseToPointTest() {
        String[] records = new String[]{"student,name=xie,sex=m country=\"china\",score=87.0,tel=\"110\" 1635177018815000000", "student,name=xie,sex=m country=\"china\",score=87i,tel=990i 1635187018815000000", "cpu,name=xie country=\"china\",score=100.0 1635187018815000000"};
        int expectLength = 3;
        for (int i = 0; i < expectLength; ++i) {
            Assert.assertEquals((Object)records[i], (Object)InfluxLineParser.parseToPoint((String)records[i]).lineProtocol());
        }
    }

    @Test
    public void parserRecordsToPoints() {
        CharSequence[] records = new String[]{"student,name=xie,sex=m country=\"china\",score=87.0,tel=\"110\" 1635177018815000000", "student,name=xie,sex=m country=\"china\",score=87i,tel=990i 1635187018815000000", "cpu,name=xie country=\"china\",score=100.0 1635187018815000000"};
        int expectLength = 3;
        ArrayList points = (ArrayList)InfluxLineParser.parserRecordsToPoints((String)String.join((CharSequence)"\n", records));
        for (int i = 0; i < expectLength; ++i) {
            Assert.assertEquals((Object)records[i], (Object)((Point)points.get(i)).lineProtocol());
        }
    }
}

