/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mlog;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.logfile.MLogTxtWriter;
import org.apache.iotdb.db.metadata.logfile.MLogUpgrader;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.tag.TagLogFile;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MLogUpgraderTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testUpgrade() throws IOException, MetadataException {
        MManager manager = IoTDB.metaManager;
        manager.clear();
        String schemaDir = IoTDBDescriptor.getInstance().getConfig().getSchemaDir();
        MLogTxtWriter mLogTxtWriter = new MLogTxtWriter(schemaDir, "mlog.txt");
        mLogTxtWriter.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.sg.d.s"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, null, null, null), 0L);
        mLogTxtWriter.close();
        TagLogFile tagLogFile = new TagLogFile(schemaDir, "tlog.txt");
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("name", "IoTDB");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("type", "tsDB");
        tagLogFile.write(tags, attributes, 0L);
        tagLogFile.close();
        File mLog = new File(schemaDir + File.separator + "mlog.bin");
        if (mLog.exists()) {
            mLog.delete();
        }
        MLogUpgrader.upgradeMLog();
        manager.init();
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(new PartialPath("root.**"), true, "name", "DB", 0, 0, false);
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)manager.showTimeseries(plan, null).get(0);
        Assert.assertEquals((Object)"root.sg.d.s", (Object)result.getName());
        Assert.assertEquals(tags, (Object)result.getTag());
        Assert.assertEquals(attributes, (Object)result.getAttribute());
    }

    @Test
    public void testCreateSchemaTemplateSerializationAdaptation() throws IOException {
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        plan.formerSerialize(dos);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((long)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal(), (long)buffer.get());
        CreateTemplatePlan deserializedPlan = new CreateTemplatePlan();
        deserializedPlan.deserialize(buffer);
        Assert.assertEquals((long)plan.getCompressors().size(), (long)deserializedPlan.getCompressors().size());
        Assert.assertEquals(((List)plan.getMeasurements().get(0)).get(0), ((List)deserializedPlan.getMeasurements().get(0)).get(0));
        Assert.assertEquals((long)plan.getDataTypes().size(), (long)deserializedPlan.getDataTypes().size());
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }
}

