/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class SchemaEntryTest {
    @Test
    public void schemaEntryBuildTest() throws IllegalPathException {
        for (TSDataType type : TSDataType.values()) {
            if (type == TSDataType.VECTOR) continue;
            SchemaEntry schemaEntry = new SchemaEntry(type);
            Assert.assertEquals((Object)schemaEntry.getTSDataType(), (Object)type);
            Assert.assertEquals((Object)schemaEntry.getTSEncoding(), (Object)EncodingInferenceUtils.getDefaultEncoding((TSDataType)type));
            Assert.assertEquals((Object)schemaEntry.getCompressionType(), (Object)TSFileDescriptor.getInstance().getConfig().getCompressor());
            schemaEntry.updateCachedLast(new TimeValuePair(100L, (TsPrimitiveType)new TsPrimitiveType.TsLong(1L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(1L), (Object)schemaEntry.getLastValue());
            Assert.assertEquals((long)100L, (long)schemaEntry.getLastTime());
            schemaEntry.updateCachedLast(new TimeValuePair(90L, (TsPrimitiveType)new TsPrimitiveType.TsLong(2L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(1L), (Object)schemaEntry.getLastValue());
            Assert.assertEquals((long)100L, (long)schemaEntry.getLastTime());
            schemaEntry.updateCachedLast(new TimeValuePair(110L, (TsPrimitiveType)new TsPrimitiveType.TsLong(2L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(2L), (Object)schemaEntry.getLastValue());
            Assert.assertEquals((long)110L, (long)schemaEntry.getLastTime());
        }
    }
}

