/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDTableResourceControlTest {
    private final Planner processor = new Planner();
    private boolean isEnableIDTable = false;
    private String originalDeviceIDTransformationMethod = null;

    @Before
    public void before() {
        this.isEnableIDTable = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
        this.originalDeviceIDTransformationMethod = IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod();
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(true);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod("SHA256");
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(this.isEnableIDTable);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod(this.originalDeviceIDTransformationMethod);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDeviceIDReusing() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        InsertRowPlan rowPlan = this.getInsertRowPlan();
        PlanExecutor executor = new PlanExecutor();
        executor.insert(rowPlan);
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select * from root.isp.d1");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)6L, (long)dataSet.getPaths().size());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)6L, (long)record.getFields().size());
        }
        IDeviceID idTableDeviceID = null;
        for (Map map : IDTableManager.getInstance().getIDTable(new PartialPath("root.isp.d1")).getIdTables()) {
            if (map == null) continue;
            for (IDeviceID deviceID : map.keySet()) {
                if (idTableDeviceID == null) {
                    idTableDeviceID = deviceID;
                    continue;
                }
                Assert.fail((String)"there should only be one device in id table");
            }
        }
        Assert.assertNotNull(idTableDeviceID);
        int deviceCount = 0;
        for (TsFileProcessor processor : StorageEngine.getInstance().getProcessor(new PartialPath("root.isp.d1")).getWorkSequenceTsFileProcessors()) {
            for (Map.Entry entry : processor.getWorkMemTable().getMemTableMap().entrySet()) {
                if (entry.getKey() != rowPlan.getDeviceID()) {
                    Assert.fail((String)"memtable's device id is not same as insert plan's device id");
                }
                if (entry.getKey() != idTableDeviceID) {
                    Assert.fail((String)"memtable's device id is not same as insert plan's device id");
                }
                ++deviceCount;
            }
        }
        Assert.assertEquals((long)1L, (long)deviceCount);
    }

    private InsertRowPlan getInsertRowPlan() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath("root.isp.d1"), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }
}

