/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDTableLogFileTest {
    private boolean isEnableIDTable = false;
    private String originalDeviceIDTransformationMethod = null;
    private boolean isEnableIDTableLogFile = false;

    @Before
    public void before() {
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        this.isEnableIDTable = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
        this.originalDeviceIDTransformationMethod = IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod();
        this.isEnableIDTableLogFile = IoTDBDescriptor.getInstance().getConfig().isEnableIDTableLogFile();
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(true);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod("SHA256");
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(this.isEnableIDTable);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod(this.originalDeviceIDTransformationMethod);
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(this.isEnableIDTableLogFile);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testInsertAndAutoCreate() {
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device1"), time, new String[]{"s1", "s2"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d2.non_aligned_device2"), time, new String[]{"s3", "s4"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            HashMap deviceIdToNameMap = new HashMap();
            HashSet<String> d1Set = new HashSet<String>();
            d1Set.add("root.laptop.d1.non_aligned_device1.s1");
            d1Set.add("root.laptop.d1.non_aligned_device1.s2");
            HashSet<String> d2Set = new HashSet<String>();
            d2Set.add("root.laptop.d2.non_aligned_device2.s3");
            d2Set.add("root.laptop.d2.non_aligned_device2.s4");
            HashSet<String> resSet = new HashSet<String>();
            deviceIdToNameMap.put(DeviceIDFactory.getInstance().getDeviceID(new PartialPath("root.laptop.d1.non_aligned_device1")).toStringID(), d1Set);
            deviceIdToNameMap.put(DeviceIDFactory.getInstance().getDeviceID(new PartialPath("root.laptop.d2.non_aligned_device2")).toStringID(), d2Set);
            int count = 0;
            for (DiskSchemaEntry entry : idTable.getIDiskSchemaManager().getAllSchemaEntry()) {
                String deviceID = entry.deviceID;
                HashSet set = (HashSet)deviceIdToNameMap.get(deviceID);
                if (set == null) {
                    Assert.fail((String)("device path is not correct " + deviceID));
                }
                if (!set.contains(entry.seriesKey)) {
                    Assert.fail((String)("series path is not correct " + entry.seriesKey));
                }
                ++count;
                resSet.add(entry.seriesKey);
            }
            Assert.assertEquals((long)4L, (long)count);
            Assert.assertEquals((long)4L, (long)resSet.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }
}

