/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePartitionPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDTableFlushTimeTest {
    private PlanExecutor executor = new PlanExecutor();
    private final Planner processor = new Planner();
    private boolean isEnableIDTable = false;
    private String originalDeviceIDTransformationMethod = null;
    private boolean isEnableIDTableLogFile = false;

    @Before
    public void before() {
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        this.isEnableIDTable = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
        this.originalDeviceIDTransformationMethod = IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod();
        this.isEnableIDTableLogFile = IoTDBDescriptor.getInstance().getConfig().isEnableIDTableLogFile();
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(true);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod("SHA256");
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(this.isEnableIDTable);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod(this.originalDeviceIDTransformationMethod);
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(this.isEnableIDTableLogFile);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSequenceInsert() throws MetadataException, QueryProcessException, StorageEngineException {
        this.insertData(0L);
        this.insertData(10L);
        PhysicalPlan flushPlan = this.processor.parseSQLToPhysicalPlan("flush");
        this.executor.processNonQuery(flushPlan);
        this.insertData(20L);
        VirtualStorageGroupProcessor storageGroupProcessor = StorageEngine.getInstance().getProcessor(new PartialPath("root.isp.d1"));
        Assert.assertEquals((long)2L, (long)storageGroupProcessor.getSequenceFileTreeSet().size());
        Assert.assertEquals((long)0L, (long)storageGroupProcessor.getUnSequenceFileList().size());
    }

    @Test
    public void testUnSequenceInsert() throws MetadataException, QueryProcessException, StorageEngineException {
        this.insertData(100L);
        PhysicalPlan flushPlan = this.processor.parseSQLToPhysicalPlan("flush");
        this.executor.processNonQuery(flushPlan);
        this.insertData(20L);
        VirtualStorageGroupProcessor storageGroupProcessor = StorageEngine.getInstance().getProcessor(new PartialPath("root.isp.d1"));
        Assert.assertEquals((long)1L, (long)storageGroupProcessor.getSequenceFileTreeSet().size());
        Assert.assertEquals((long)1L, (long)storageGroupProcessor.getUnSequenceFileList().size());
    }

    @Test
    public void testSequenceAndUnSequenceInsert() throws MetadataException, QueryProcessException, StorageEngineException {
        this.insertData(100L);
        PhysicalPlan flushPlan = this.processor.parseSQLToPhysicalPlan("flush");
        this.executor.processNonQuery(flushPlan);
        this.insertData(120L);
        this.executor.processNonQuery(flushPlan);
        this.insertData(20L);
        this.insertData(130L);
        this.executor.processNonQuery(flushPlan);
        this.insertData(150L);
        this.insertData(90L);
        VirtualStorageGroupProcessor storageGroupProcessor = StorageEngine.getInstance().getProcessor(new PartialPath("root.isp.d1"));
        Assert.assertEquals((long)4L, (long)storageGroupProcessor.getSequenceFileTreeSet().size());
        Assert.assertEquals((long)2L, (long)storageGroupProcessor.getUnSequenceFileList().size());
        Assert.assertEquals((long)1L, (long)storageGroupProcessor.getWorkSequenceTsFileProcessors().size());
        Assert.assertEquals((long)1L, (long)storageGroupProcessor.getWorkUnsequenceTsFileProcessors().size());
    }

    @Test
    public void testDeletePartition() throws MetadataException, QueryProcessException, StorageEngineException {
        this.insertData(100L);
        PhysicalPlan flushPlan = this.processor.parseSQLToPhysicalPlan("flush");
        this.executor.processNonQuery(flushPlan);
        this.insertData(20L);
        this.insertData(120L);
        VirtualStorageGroupProcessor storageGroupProcessor = StorageEngine.getInstance().getProcessor(new PartialPath("root.isp.d1"));
        Assert.assertEquals((long)103L, (long)storageGroupProcessor.getLastFlushTimeManager().getFlushedTime(0L, "root.isp.d1"));
        Assert.assertEquals((long)123L, (long)storageGroupProcessor.getLastFlushTimeManager().getLastTime(0L, "root.isp.d1"));
        Assert.assertEquals((long)103L, (long)storageGroupProcessor.getLastFlushTimeManager().getGlobalFlushedTime("root.isp.d1"));
        HashSet<Long> deletedPartition = new HashSet<Long>();
        deletedPartition.add(0L);
        DeletePartitionPlan deletePartitionPlan = new DeletePartitionPlan(new PartialPath("root.isp"), deletedPartition);
        this.executor.processNonQuery((PhysicalPlan)deletePartitionPlan);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)storageGroupProcessor.getLastFlushTimeManager().getFlushedTime(0L, "root.isp.d1"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)storageGroupProcessor.getLastFlushTimeManager().getLastTime(0L, "root.isp.d1"));
        Assert.assertEquals((long)123L, (long)storageGroupProcessor.getLastFlushTimeManager().getGlobalFlushedTime("root.isp.d1"));
    }

    private void insertData(long initTime) throws IllegalPathException, QueryProcessException {
        long[] times = new long[]{initTime, initTime + 1L, initTime + 2L, initTime + 3L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 10.0 + (double)r;
            ((float[])columns[1])[r] = 20 + r;
            ((long[])columns[2])[r] = 100000 + r;
            ((int[])columns[3])[r] = 1000 + r;
            ((boolean[])columns[4])[r] = false;
            ((Binary[])columns[5])[r] = new Binary("mm" + r);
        }
        InsertTabletPlan tabletPlan = new InsertTabletPlan(new PartialPath("root.isp.d1"), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes);
        tabletPlan.setTimes(times);
        tabletPlan.setColumns(columns);
        tabletPlan.setRowCount(times.length);
        PlanExecutor executor = new PlanExecutor();
        executor.insertTablet(tabletPlan);
    }
}

