/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.TemplateIsInUseException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testTemplate() throws MetadataException {
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        MManager manager = IoTDB.metaManager;
        manager.createSchemaTemplate(plan);
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg1.d1");
        manager.setSchemaTemplate(setTemplatePlan);
        IMNode node = manager.getDeviceNode(new PartialPath("root.sg1.d1"));
        node = manager.setUsingSchemaTemplate(node);
        MeasurementSchema s11 = new MeasurementSchema("s11", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        Assert.assertNotNull((Object)node.getSchemaTemplate());
        HashSet allSchema = new HashSet(node.getSchemaTemplate().getSchemaMap().values());
        manager.getAllMeasurementByDevicePath(new PartialPath("root.sg1.d1")).stream().map(MeasurementPath::getMeasurementSchema).forEach(allSchema::remove);
        Assert.assertTrue((boolean)allSchema.isEmpty());
        IMeasurementMNode mNode = manager.getMeasurementMNode(new PartialPath("root.sg1.d1.s11"));
        IMeasurementMNode mNode2 = manager.getMeasurementMNode(new PartialPath("root.sg1.d1.vector.s2"));
        Assert.assertNotNull((Object)mNode);
        Assert.assertEquals((Object)mNode.getSchema(), (Object)s11);
        Assert.assertNotNull((Object)mNode2);
        Assert.assertEquals((Object)mNode2.getSchema(), manager.getTemplate("template1").getSchemaMap().get("vector.s2"));
        try {
            manager.getMeasurementMNode(new PartialPath("root.sg1.d1.s100"));
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [root.sg1.d1.s100] does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void testTemplateInnerTree() {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        MManager manager = IoTDB.metaManager;
        try {
            manager.createSchemaTemplate(plan);
            Template template = manager.getTemplate("treeTemplate");
            Assert.assertEquals((long)4L, (long)template.getMeasurementsCount());
            Assert.assertEquals((Object)"d1", (Object)template.getPathNodeInTemplate("d1").getName());
            Assert.assertEquals(null, (Object)template.getPathNodeInTemplate("notExists"));
            Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
            String[] alignedMeasurements = new String[]{"to.be.prefix.s1", "to.be.prefix.s2"};
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT32};
            TSEncoding[] encodings = new TSEncoding[]{TSEncoding.RLE, TSEncoding.RLE};
            CompressionType[] compressionTypes = new CompressionType[]{CompressionType.SNAPPY, CompressionType.SNAPPY};
            template.addAlignedMeasurements(alignedMeasurements, dataTypes, encodings, compressionTypes);
            Assert.assertEquals((Object)"[to.be.prefix, GPS]", (Object)template.getAllAlignedPrefix().toString());
            Assert.assertEquals((Object)"[s1, s2]", (Object)template.getAlignedMeasurements("to.be.prefix").toString());
            template.deleteAlignedPrefix("to.be.prefix");
            Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
            Assert.assertEquals(null, (Object)template.getDirectNode("prefix"));
            Assert.assertEquals((Object)"to", (Object)template.getDirectNode("to").getName());
            try {
                template.deleteMeasurements("a.single");
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Path [a.single] does not exist", (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"[d1.s1, GPS.x, to.be.prefix.s2, GPS.y, to.be.prefix.s1, s2]", (Object)template.getAllMeasurementsPaths().toString());
            template.deleteSeriesCascade("to");
            Assert.assertEquals((Object)"[d1.s1, GPS.x, GPS.y, s2]", (Object)template.getAllMeasurementsPaths().toString());
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCreateSchemaTemplateSerialization() throws IOException {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        plan.serialize(dos);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((long)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal(), (long)buffer.get());
        CreateTemplatePlan deserializedPlan = new CreateTemplatePlan();
        deserializedPlan.deserialize(buffer);
        Assert.assertEquals(((List)plan.getCompressors().get(0)).get(0), ((List)deserializedPlan.getCompressors().get(0)).get(0));
        Assert.assertEquals((long)plan.getMeasurements().size(), (long)deserializedPlan.getMeasurements().size());
        Assert.assertEquals((Object)plan.getName(), (Object)deserializedPlan.getName());
    }

    private CreateTemplatePlan getTreeTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.UNCOMPRESSED));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        return new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getDirectAlignedTemplate() {
        ArrayList measurementList = new ArrayList();
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vs" + i);
        }
        measurementList.add(measurements);
        ArrayList dataTypeList = new ArrayList();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList encodingList = new ArrayList();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList compressionTypes = new ArrayList();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("vector");
        return new CreateTemplatePlan("templateDA", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testShowTemplates() throws MetadataException, QueryProcessException {
        SetTemplatePlan setTemplatePlan;
        int i;
        MManager manager = IoTDB.metaManager;
        Assert.assertEquals((long)0L, (long)manager.getAllTemplates().size());
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        manager.createSchemaTemplate(plan1);
        manager.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)manager.getAllTemplates().toString());
        for (i = 0; i < 3; ++i) {
            setTemplatePlan = new SetTemplatePlan("template1", String.format("root.sg%d.d%d", i, i + 1));
            manager.setSchemaTemplate(setTemplatePlan);
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.sg1.d2", "root.sg0.d1", "root.sg2.d3")), (Object)manager.getPathsSetTemplate("*"));
        Assert.assertEquals(new HashSet<Object>(Arrays.asList(new Object[0])), (Object)manager.getPathsSetTemplate("treeTemplate"));
        for (i = 0; i < 3; ++i) {
            setTemplatePlan = new SetTemplatePlan("treeTemplate", String.format("root.tsg%d.d%d", i + 9, i + 10));
            manager.setSchemaTemplate(setTemplatePlan);
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.tsg11.d12", "root.tsg9.d10")), (Object)manager.getPathsSetTemplate("treeTemplate"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.tsg11.d12", "root.tsg9.d10", "root.sg1.d2", "root.sg0.d1", "root.sg2.d3")), (Object)manager.getPathsSetTemplate("*"));
        PlanExecutor exe1 = new PlanExecutor();
        exe1.insert(this.getInsertRowPlan("root.sg0.d1", "s11"));
        exe1.insert(this.getInsertRowPlan("root.sg1.d2", "s11"));
        exe1.insert(this.getInsertRowPlan("root.tsg10.d11.d1", "s1"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.sg1.d2", "root.sg0.d1")), (Object)manager.getPathsUsingTemplate("*"));
        try {
            manager.createSchemaTemplate(plan1);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Duplicated template name: treeTemplate", (Object)e.getMessage());
        }
        try {
            manager.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [treeTemplate] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
    }

    @Test
    public void testShowAllSchemas() throws MetadataException {
        MManager manager = IoTDB.metaManager;
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        manager.createSchemaTemplate(plan1);
        manager.createSchemaTemplate(plan2);
        Assert.assertEquals((long)4L, (long)manager.getSchemasInTemplate("treeTemplate", "").size());
        Assert.assertEquals((long)2L, (long)manager.getSchemasInTemplate("treeTemplate", "GPS").size());
        Assert.assertEquals((long)11L, (long)manager.getSchemasInTemplate("template1", "").size());
        Assert.assertEquals((long)10L, (long)manager.getSchemasInTemplate("template1", "vector").size());
    }

    @Test
    public void testDropTemplate() throws MetadataException {
        MManager manager = IoTDB.metaManager;
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        manager.createSchemaTemplate(plan1);
        manager.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)manager.getAllTemplates().toString());
        try {
            manager.createSchemaTemplate(plan2);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Duplicated template name: template1", (Object)e.getMessage());
        }
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg.d0");
        manager.setSchemaTemplate(setTemplatePlan);
        try {
            manager.dropSchemaTemplate(new DropTemplatePlan("template1"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [template1] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
        UnsetTemplatePlan unsetPlan = new UnsetTemplatePlan("root.sg.d0", "template1");
        manager.unsetSchemaTemplate(unsetPlan);
        manager.dropSchemaTemplate(new DropTemplatePlan("template1"));
        Assert.assertEquals((Object)"[treeTemplate]", (Object)manager.getAllTemplates().toString());
        manager.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)manager.getAllTemplates().toString());
        manager.dropSchemaTemplate(new DropTemplatePlan("template1"));
        manager.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
    }

    @Test
    public void testDropTemplateWithStorageGroupDeleted() throws MetadataException {
        MManager manager = IoTDB.metaManager;
        manager.createSchemaTemplate(this.getTreeTemplatePlan());
        manager.setSchemaTemplate(new SetTemplatePlan("treeTemplate", "root.sg1.d1"));
        try {
            manager.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [treeTemplate] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
        manager.deleteStorageGroups(Arrays.asList(new PartialPath("root.sg1")));
        manager.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
        Assert.assertEquals((long)0L, (long)manager.getAllTemplates().size());
    }

    @Test
    public void testTemplateAlignment() throws MetadataException {
        MManager manager = IoTDB.metaManager;
        manager.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        manager.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        manager.createTimeseries(new PartialPath("root.laptop.d1.ss.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        manager.createSchemaTemplate(this.getDirectAlignedTemplate());
        try {
            manager.setSchemaTemplate(new SetTemplatePlan("templateDA", "root.laptop.d1"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Template[templateDA] and mounted node[root.laptop.d1.vs0] has different alignment.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeactivateTemplate() throws Exception {
        IoTDB.metaManager.createSchemaTemplate(this.getCreateTemplatePlan());
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("template1", "root.sg0"));
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("template1", "root.sg1.v1"));
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg2.v2"));
        IoTDB.metaManager.setSchemaTemplate(new SetTemplatePlan("template1", "root.sg2.v2.d2"));
        IoTDB.metaManager.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.sg1.v1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        Assert.assertEquals((long)1L, (long)IoTDB.metaManager.getAllTimeseriesCount(new PartialPath("root.**")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg0.v1")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg0.v1.d1")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg0.v1.d2")));
        Assert.assertEquals((long)(1L + 3L * (long)IoTDB.metaManager.countMeasurementsInTemplate("template1")), (long)IoTDB.metaManager.getAllTimeseriesCount(new PartialPath("root.**")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.v1")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.v1.d1")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.v1.d2")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.v1.d3")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg2.v2.d2")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg2.v2.d2.s0")));
        IoTDB.metaManager.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg2.v2.d2.sd.s0")));
        Assert.assertEquals((long)10L, (long)IoTDB.metaManager.getPathsUsingTemplate("template1").size());
        try {
            IoTDB.metaManager.unsetSchemaTemplate(new UnsetTemplatePlan("root.sg0", "template1"));
            Assert.fail();
        }
        catch (TemplateIsInUseException e) {
            Assert.assertEquals((Object)"Template is in use on root.sg0.v1", (Object)e.getMessage());
        }
        Assert.assertEquals((long)3L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg0", true).size());
        Assert.assertEquals((long)4L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg1", true).size());
        Assert.assertEquals((long)4L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg1.v1", true).size());
        Assert.assertEquals((long)3L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2", true).size());
        Assert.assertEquals((long)3L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2.v2.d2", true).size());
        HashSet<String> ans1 = new HashSet<String>(Arrays.asList("root.sg2.v2.d2", "root.sg2.v2.d2.s0", "root.sg2.v2.d2.sd.s0"));
        HashSet<String> ans2 = new HashSet<String>(Arrays.asList("root.sg2.v2.d2.s0"));
        HashSet<String> ans3 = new HashSet<String>(Arrays.asList("root.sg2.v2.d2.s0", "root.sg2.v2.d2.sd.s0"));
        Assert.assertEquals(ans1, IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2.v2.d2", true).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        Assert.assertEquals(ans2, IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2.v2.d2.*", true).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        Assert.assertEquals(ans3, IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2.v2.d2.**", true).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        System.out.println(IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2.v2.d2", false).toString());
        IoTDB.metaManager.deactivateSchemaTemplate(this.getDeactivatePlan("template1", "root.sg1.v1"));
        Assert.assertEquals((long)3L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg1.v1", true).size());
        IoTDB.metaManager.deactivateSchemaTemplate(this.getDeactivatePlan("template1", "root.sg1.v1.**"));
        IoTDB.metaManager.unsetSchemaTemplate(new UnsetTemplatePlan("root.sg1.v1", "template1"));
        Assert.assertEquals((long)2L, (long)IoTDB.metaManager.getPathsSetTemplate("template1").size());
        IoTDB.metaManager.deactivateSchemaTemplate(this.getDeactivatePlan("template1", "root.sg2.v2.*"));
        Assert.assertEquals((long)2L, (long)IoTDB.metaManager.getPathsUsingTemplateUnderPrefix("template1", "root.sg2", true).size());
        IoTDB.metaManager.deactivateSchemaTemplate(this.getDeactivatePlan("template1", "root.**"));
        Assert.assertEquals((long)1L, (long)IoTDB.metaManager.getAllTimeseriesCount(new PartialPath("root.**")));
        EnvironmentUtils.restartDaemon();
        Assert.assertEquals((long)1L, (long)IoTDB.metaManager.getAllTimeseriesCount(new PartialPath("root.**")));
        IoTDB.metaManager.unsetSchemaTemplate(new UnsetTemplatePlan("root.sg0", "template1"));
        IoTDB.metaManager.unsetSchemaTemplate(new UnsetTemplatePlan("root.sg2.v2.d2", "template1"));
        IoTDB.metaManager.dropSchemaTemplate(new DropTemplatePlan("template1"));
        Assert.assertEquals((long)0L, (long)IoTDB.metaManager.getAllTemplates().size());
    }

    private DeactivateTemplatePlan getDeactivatePlan(String tName, String prefix) throws MetadataException {
        DeactivateTemplatePlan plan = new DeactivateTemplatePlan(tName, new PartialPath(prefix));
        plan.setPaths(new ArrayList(IoTDB.metaManager.getPathsUsingTemplateUnderPrefix(tName, prefix, false)));
        return plan;
    }

    private InsertRowPlan getInsertRowPlan(String prefixPath, String measurement) throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT64};
        String[] columns = new String[]{"1"};
        return new InsertRowPlan(new PartialPath(prefixPath), time, new String[]{measurement}, dataTypes, columns);
    }
}

