/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartialPathTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testConcatPath() {
        String[] arr1 = new String[]{"root", "sg1"};
        PartialPath a = new PartialPath(arr1);
        String[] arr2 = new String[]{"d1", "s1"};
        PartialPath b = new PartialPath(arr2);
        Assert.assertEquals((Object)"[root, sg1, d1, s1]", (Object)Arrays.toString(a.concatPath(b).getNodes()));
        Assert.assertEquals((Object)"s1", (Object)b.getTailNode());
        Assert.assertEquals((Object)"root.sg1.d1", (Object)a.concatPath(b).getDevicePath().getFullPath());
        Assert.assertEquals((Object)"root.sg1", (Object)a.toString());
    }

    @Test
    public void testConcatArray() throws IllegalPathException {
        PartialPath a = new PartialPath("root", "sg1");
        String[] arr2 = new String[]{"d1", "s1"};
        a.concatPath(arr2);
        Assert.assertEquals((Object)"[root, sg1, d1, s1]", (Object)Arrays.toString(a.getNodes()));
    }

    @Test
    public void testConcatNode() {
        String[] arr1 = new String[]{"root", "sg1"};
        PartialPath a = new PartialPath(arr1);
        PartialPath b = a.concatNode("d1");
        Assert.assertEquals((Object)"[root, sg1, d1]", (Object)Arrays.toString(b.getNodes()));
        Assert.assertEquals((Object)"root.sg1.d1", (Object)b.getFullPath());
        Assert.assertTrue((boolean)b.startsWith(arr1));
        Assert.assertEquals((Object)"root", (Object)b.getFirstNode());
    }

    @Test
    public void testAlterPrefixPath() throws IllegalPathException {
        PartialPath p = new PartialPath("root.a.b.c");
        List results = p.alterPrefixPath(new PartialPath("root.a.b"));
        Assert.assertEquals((String)results.toString(), (long)1L, (long)results.size());
        Assert.assertEquals((Object)"root.a.b.c", (Object)((PartialPath)results.get(0)).getFullPath());
        p = new PartialPath("root.*.b.c");
        results = p.alterPrefixPath(new PartialPath("root.a.b"));
        Assert.assertEquals((String)results.toString(), (long)1L, (long)results.size());
        Assert.assertEquals((Object)"root.a.b.c", (Object)((PartialPath)results.get(0)).getFullPath());
        p = new PartialPath("root.**.b.c");
        results = p.alterPrefixPath(new PartialPath("root.a.b"));
        Assert.assertEquals((String)results.toString(), (long)3L, (long)results.size());
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.c")));
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.b.c")));
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.**.b.c")));
        p = new PartialPath("root.**");
        results = p.alterPrefixPath(new PartialPath("root.a.b"));
        Assert.assertEquals((String)results.toString(), (long)2L, (long)results.size());
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b")));
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.**")));
        p = new PartialPath("root.**.b.**");
        results = p.alterPrefixPath(new PartialPath("root.a.b.c"));
        Assert.assertEquals((String)results.toString(), (long)2L, (long)results.size());
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.c")));
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.a.b.c.**")));
        p = new PartialPath("root.**.b.**.b");
        results = p.alterPrefixPath(new PartialPath("root.b.b.b"));
        Assert.assertEquals((String)results.toString(), (long)2L, (long)results.size());
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.b.b.b.b")));
        Assert.assertTrue((String)results.toString(), (boolean)results.contains(new PartialPath("root.b.b.b.**.b")));
        p = new PartialPath("root.b.c.**");
        results = p.alterPrefixPath(new PartialPath("root.a.b.c"));
        Assert.assertEquals((String)results.toString(), (long)0L, (long)results.size());
    }

    @Test
    public void testMatchPath() throws IllegalPathException {
        String[] patterns;
        PartialPath p1 = new PartialPath("root.sg1.d1.*");
        Assert.assertTrue((boolean)p1.matchFullPath(new PartialPath("root.sg1.d1.s2")));
        Assert.assertFalse((boolean)p1.matchFullPath(new PartialPath("root.sg1.d1")));
        Assert.assertFalse((boolean)p1.matchFullPath(new PartialPath("root.sg2.d1.*")));
        Assert.assertFalse((boolean)p1.matchFullPath(new PartialPath("")));
        PartialPath path = new PartialPath("root.sg.d.s");
        for (String pattern : patterns = new String[]{"root.**", "root.**.s", "root.sg.*.s", "root.*.*.*", "root.sg.d.s", "root.s*.d.s"}) {
            Assert.assertTrue((boolean)new PartialPath(pattern).matchFullPath(path));
        }
    }

    @Test
    public void testPartialPathAndStringList() {
        List paths = PartialPath.fromStringList(Arrays.asList("root.sg1.d1.s1", "root.sg1.d1.s2"));
        Assert.assertEquals((Object)"root.sg1.d1.s1", (Object)((PartialPath)paths.get(0)).getFullPath());
        Assert.assertEquals((Object)"root.sg1.d1.s2", (Object)((PartialPath)paths.get(1)).getFullPath());
        List stringPaths = PartialPath.toStringList((List)paths);
        Assert.assertEquals((Object)"root.sg1.d1.s1", stringPaths.get(0));
        Assert.assertEquals((Object)"root.sg1.d1.s2", stringPaths.get(1));
    }
}

