/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTLTest {
    private String sg1 = "root.TTL_SG1";
    private String sg2 = "root.TTL_SG2";
    private long ttl = 12345L;
    private VirtualStorageGroupProcessor virtualStorageGroupProcessor;
    private String s1 = "s1";
    private String g1s1 = this.sg1 + '.' + this.s1;
    private long prevPartitionInterval;

    @Before
    public void setUp() throws MetadataException, StorageGroupProcessorException {
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(86400L);
        EnvironmentUtils.envSetUp();
        this.createSchemas();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(this.prevPartitionInterval);
    }

    private void createSchemas() throws MetadataException, StorageGroupProcessorException {
        IoTDB.metaManager.setStorageGroup(new PartialPath(this.sg1));
        IoTDB.metaManager.setStorageGroup(new PartialPath(this.sg2));
        this.virtualStorageGroupProcessor = new VirtualStorageGroupProcessor(IoTDBDescriptor.getInstance().getConfig().getSystemDir(), this.sg1, (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), this.sg1);
        IoTDB.metaManager.createTimeseries(new PartialPath(this.g1s1), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap());
    }

    @Test
    public void testSetMetaTTL() throws IOException, MetadataException {
        boolean caught = false;
        try {
            IoTDB.metaManager.setTTL(new PartialPath(this.sg1 + ".notExist"), this.ttl);
        }
        catch (MetadataException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        IoTDB.metaManager.setTTL(new PartialPath(this.sg1), this.ttl);
        IStorageGroupMNode mNode = IoTDB.metaManager.getStorageGroupNodeByStorageGroupPath(new PartialPath(this.sg1));
        Assert.assertEquals((long)this.ttl, (long)mNode.getDataTTL());
        mNode = IoTDB.metaManager.getStorageGroupNodeByStorageGroupPath(new PartialPath(this.sg2));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)mNode.getDataTTL());
    }

    @Test
    public void testTTLWrite() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        InsertRowPlan plan = new InsertRowPlan();
        plan.setDevicePath(new PartialPath(this.sg1));
        plan.setTime(System.currentTimeMillis());
        plan.setMeasurements(new String[]{"s1"});
        plan.setDataTypes(new TSDataType[]{TSDataType.INT64});
        plan.setValues(new Object[]{1L});
        plan.setMeasurementMNodes(new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)});
        plan.transferType();
        this.virtualStorageGroupProcessor.insert(plan);
        this.virtualStorageGroupProcessor.setDataTTL(1000L);
        plan.setTime(System.currentTimeMillis() - 1001L);
        boolean caught = false;
        try {
            this.virtualStorageGroupProcessor.insert(plan);
        }
        catch (OutOfTTLException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        plan.setTime(System.currentTimeMillis() - 900L);
        this.virtualStorageGroupProcessor.insert(plan);
    }

    private void prepareData() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        int i;
        InsertRowPlan plan = new InsertRowPlan();
        plan.setDevicePath(new PartialPath(this.sg1));
        plan.setTime(System.currentTimeMillis());
        plan.setMeasurements(new String[]{"s1"});
        plan.setDataTypes(new TSDataType[]{TSDataType.INT64});
        plan.setValues(new Object[]{1L});
        plan.setMeasurementMNodes(new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)});
        plan.transferType();
        long initTime = System.currentTimeMillis();
        for (i = 1000; i < 2000; ++i) {
            plan.setTime(initTime - 2000L + (long)i);
            this.virtualStorageGroupProcessor.insert(plan);
            if ((i + 1) % 300 != 0) continue;
            this.virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        }
        for (i = 0; i < 1000; ++i) {
            plan.setTime(initTime - 2000L + (long)i);
            this.virtualStorageGroupProcessor.insert(plan);
            if ((i + 1) % 300 != 0) continue;
            this.virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        }
    }

    @Test
    public void testTTLRead() throws IOException, WriteProcessException, StorageEngineException, QueryProcessException, MetadataException {
        this.prepareData();
        QueryDataSource dataSource = this.virtualStorageGroupProcessor.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        List seqResource = dataSource.getSeqResources();
        List unseqResource = dataSource.getUnseqResources();
        Assert.assertEquals((long)4L, (long)seqResource.size());
        Assert.assertEquals((long)4L, (long)unseqResource.size());
        this.virtualStorageGroupProcessor.setDataTTL(500L);
        dataSource = this.virtualStorageGroupProcessor.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        seqResource = dataSource.getSeqResources();
        unseqResource = dataSource.getUnseqResources();
        Assert.assertTrue((seqResource.size() < 4 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)unseqResource.size());
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1);
        HashSet<String> allSensors = new HashSet<String>();
        allSensors.add(this.s1);
        SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader((PartialPath)path, TSDataType.INT64, EnvironmentUtils.TEST_QUERY_CONTEXT, seqResource, unseqResource, null, null, true);
        int cnt = 0;
        while (reader.hasNextBatch()) {
            BatchData batchData = reader.nextBatch();
            while (batchData.hasCurrent()) {
                batchData.next();
                ++cnt;
            }
        }
        reader.close();
        Assert.assertTrue((cnt <= 1000 ? 1 : 0) != 0);
        this.virtualStorageGroupProcessor.setDataTTL(0L);
        dataSource = this.virtualStorageGroupProcessor.query(Collections.singletonList(SchemaTestUtils.getMeasurementPath(this.sg1 + "." + this.s1)), this.sg1, EnvironmentUtils.TEST_QUERY_CONTEXT, null, null);
        seqResource = dataSource.getSeqResources();
        unseqResource = dataSource.getUnseqResources();
        Assert.assertEquals((long)0L, (long)seqResource.size());
        Assert.assertEquals((long)0L, (long)unseqResource.size());
    }

    @Test
    public void testTTLRemoval() throws StorageEngineException, WriteProcessException, QueryProcessException, IllegalPathException {
        this.prepareData();
        this.virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        File seqDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.sg1);
        File unseqDir = new File(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.sg1);
        ArrayList<File> seqFiles = new ArrayList<File>();
        for (File directory : seqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    seqFiles.add(file);
                }
            }
        }
        ArrayList<File> unseqFiles = new ArrayList<File>();
        for (File directory : unseqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    unseqFiles.add(file);
                }
            }
        }
        Assert.assertEquals((long)4L, (long)seqFiles.size());
        Assert.assertEquals((long)4L, (long)unseqFiles.size());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.virtualStorageGroupProcessor.setDataTTL(500L);
        this.virtualStorageGroupProcessor.checkFilesTTL();
        seqFiles = new ArrayList();
        for (File directory : seqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    seqFiles.add(file);
                }
            }
        }
        unseqFiles = new ArrayList();
        for (File directory : unseqDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".tsfile")) continue;
                    unseqFiles.add(file);
                }
            }
        }
        Assert.assertTrue((seqFiles.size() <= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)unseqFiles.size());
    }

    @Test
    public void testParseSetTTL() throws QueryProcessException {
        Planner planner = new Planner();
        SetTTLPlan plan = (SetTTLPlan)planner.parseSQLToPhysicalPlan("SET TTL TO " + this.sg1 + " 10000");
        Assert.assertEquals((Object)this.sg1, (Object)plan.getStorageGroup().getFullPath());
        Assert.assertEquals((long)10000L, (long)plan.getDataTTL());
        plan = (SetTTLPlan)planner.parseSQLToPhysicalPlan("UNSET TTL TO " + this.sg2);
        Assert.assertEquals((Object)this.sg2, (Object)plan.getStorageGroup().getFullPath());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)plan.getDataTTL());
    }

    @Test
    public void testParseShowTTL() throws QueryProcessException {
        Planner planner = new Planner();
        ShowTTLPlan plan = (ShowTTLPlan)planner.parseSQLToPhysicalPlan("SHOW ALL TTL");
        Assert.assertTrue((boolean)plan.getStorageGroups().isEmpty());
        ArrayList<String> sgs = new ArrayList<String>();
        sgs.add("root.sg1");
        sgs.add("root.sg2");
        sgs.add("root.sg3");
        plan = (ShowTTLPlan)planner.parseSQLToPhysicalPlan("SHOW TTL ON root.sg1,root.sg2,root.sg3");
        Assert.assertEquals(sgs, plan.getStorageGroups().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
    }

    @Test
    public void testShowTTL() throws IOException, QueryProcessException, QueryFilterOptimizationException, StorageEngineException, MetadataException, InterruptedException {
        IoTDB.metaManager.setTTL(new PartialPath(this.sg1), this.ttl);
        ShowTTLPlan plan = new ShowTTLPlan(Collections.emptyList());
        PlanExecutor executor = new PlanExecutor();
        QueryDataSet queryDataSet = executor.processQuery((PhysicalPlan)plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        while (queryDataSet.hasNext()) {
            RowRecord rowRecord = queryDataSet.next();
            String sg = ((Field)rowRecord.getFields().get(0)).getStringValue();
            if (sg.equals(this.sg1)) {
                Assert.assertEquals((long)this.ttl, (long)((Field)rowRecord.getFields().get(1)).getLongV());
                continue;
            }
            if (sg.equals(this.sg2)) {
                Assert.assertNull(rowRecord.getFields().get(1));
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void testTTLCleanFile() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        this.prepareData();
        this.virtualStorageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)4L, (long)this.virtualStorageGroupProcessor.getSequenceFileTreeSet().size());
        Assert.assertEquals((long)4L, (long)this.virtualStorageGroupProcessor.getUnSequenceFileList().size());
        this.virtualStorageGroupProcessor.setDataTTL(0L);
        this.virtualStorageGroupProcessor.checkFilesTTL();
        Assert.assertEquals((long)0L, (long)this.virtualStorageGroupProcessor.getSequenceFileTreeSet().size());
        Assert.assertEquals((long)0L, (long)this.virtualStorageGroupProcessor.getUnSequenceFileList().size());
    }
}

