/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.MetadataManagerHelper;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.ShutdownException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupProcessorTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static Logger logger = LoggerFactory.getLogger(StorageGroupProcessorTest.class);
    private String storageGroup = "root.vehicle.d0";
    private String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private String deviceId = "root.vehicle.d0";
    private String measurementId = "s0";
    private VirtualStorageGroupProcessor processor;
    private QueryContext context = EnvironmentUtils.TEST_QUERY_CONTEXT;

    @Before
    public void setUp() throws Exception {
        MetadataManagerHelper.initMetadata();
        EnvironmentUtils.envSetUp();
        this.processor = new DummySGP(this.systemDir, this.storageGroup);
        CompactionTaskManager.getInstance().start();
    }

    @After
    public void tearDown() throws Exception {
        this.processor.syncDeleteDataFiles();
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        CompactionTaskManager.getInstance().stop();
        EnvironmentUtils.cleanEnv();
    }

    private void insertToStorageGroupProcessor(TSRecord record) throws WriteProcessException, IllegalPathException, TriggerExecutionException {
        InsertRowPlan insertRowPlan = new InsertRowPlan(record);
        this.processor.insert(insertRowPlan);
    }

    @Test
    public void testUnseqUnsealedDelete() throws WriteProcessException, IOException, MetadataException, TriggerExecutionException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        for (int j = 11; j <= 20; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, TSDataType.INT32, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
        this.processor.delete(new PartialPath(this.deviceId, this.measurementId), 0L, 15L, -1L, null);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.query(Collections.singletonList(fullPath), EnvironmentUtils.TEST_QUERY_CONTEXT, tsfileResourcesForQuery);
        }
        Assert.assertEquals((long)1L, (long)tsfileResourcesForQuery.size());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        long time = 16L;
        for (ReadOnlyMemChunk memChunk : memChunks) {
            IPointReader iterator = memChunk.getPointReader();
            while (iterator.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)time++, (long)timeValuePair.getTimestamp());
            }
        }
    }

    @Test
    public void testSequenceSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        for (int j = 1; j <= 10; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testInsertDataAndRemovePartitionAndInsert() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        TSRecord record;
        int j;
        for (j = 0; j < 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        this.processor.removePartitions((storageGroupName, timePartitionId) -> true);
        for (j = 0; j < 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
    }

    @Test
    public void testIoTDBTabletWriteAndSyncClose() throws QueryProcessException, IllegalPathException, TriggerExecutionException {
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s0", (IMeasurementSchema)new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)1L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testSeqAndUnSeqSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        TSRecord record;
        int j;
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)10L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertRowPlan() throws WriteProcessException, QueryProcessException, IllegalPathException, IOException, TriggerExecutionException {
        TSRecord record;
        int j;
        boolean defaultValue = config.isEnableDiscardOutOfOrderData();
        config.setEnableDiscardOutOfOrderData(true);
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.insertToStorageGroupProcessor(record);
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.insertToStorageGroupProcessor(record);
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultValue);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet1() throws QueryProcessException, IllegalPathException, IOException, TriggerExecutionException {
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(100L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s0", (IMeasurementSchema)new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 149; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet2() throws QueryProcessException, IllegalPathException, IOException, TriggerExecutionException {
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(1200L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s0", (IMeasurementSchema)new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet3() throws QueryProcessException, IllegalPathException, IOException, TriggerExecutionException {
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(1000L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"s0", (IMeasurementSchema)new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), MeasurementMNode.getMeasurementMNode(null, (String)"s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testMerge() throws WriteProcessException, QueryProcessException, IllegalPathException, TriggerExecutionException {
        TSRecord record;
        int j;
        int originCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxInnerCompactionCandidateFileNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(9);
        boolean originEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        boolean originEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        this.processor.compact();
        long totalWaitingTime = 0L;
        while (CompactionTaskManager.getInstance().getExecutingTaskCount() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((totalWaitingTime += 100L) % 1000L == 0L) {
                logger.warn("has waited for {} seconds", (Object)(totalWaitingTime / 1000L));
            }
            if (totalWaitingTime <= 120000L) continue;
            Assert.fail();
            break;
        }
        QueryDataSource queryDataSource = this.processor.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        IoTDBDescriptor.getInstance().getConfig().setMaxInnerCompactionCandidateFileNum(originCandidateFileNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(originEnableSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(originEnableUnseqSpaceCompaction);
    }

    @Test
    public void testTimedFlushSeqMemTable() throws IllegalPathException, InterruptedException, WriteProcessException, TriggerExecutionException, ShutdownException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        boolean prevEnableTimedFlushSeqMemtable = config.isEnableTimedFlushSeqMemtable();
        long preFLushInterval = config.getSeqMemtableFlushInterval();
        config.setEnableTimedFlushSeqMemtable(true);
        config.setSeqMemtableFlushInterval(5L);
        StorageEngine.getInstance().rebootTimedService();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)this.processor.getWorkSequenceTsFileProcessors().size());
        TsFileProcessor tsFileProcessor = (TsFileProcessor)this.processor.getWorkSequenceTsFileProcessors().iterator().next();
        FlushManager flushManager = FlushManager.getInstance();
        this.processor.timedFlushSeqMemTable();
        int waitCnt = 0;
        while (tsFileProcessor.getFlushingMemTableSize() != 0 || tsFileProcessor.isManagedByFlushManager() || flushManager.getNumberOfPendingTasks() != 0 || flushManager.getNumberOfPendingSubTasks() != 0 || flushManager.getNumberOfWorkingTasks() != 0 || flushManager.getNumberOfWorkingSubTasks() != 0) {
            Thread.sleep(500L);
            if (++waitCnt % 10 != 0) continue;
            logger.info("already wait {} s", (Object)(waitCnt / 2));
        }
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        config.setEnableTimedFlushSeqMemtable(prevEnableTimedFlushSeqMemtable);
        config.setSeqMemtableFlushInterval(preFLushInterval);
    }

    @Test
    public void testTimedFlushUnseqMemTable() throws IllegalPathException, InterruptedException, WriteProcessException, TriggerExecutionException, ShutdownException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        this.processor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        record = new TSRecord(1L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        boolean prevEnableTimedFlushUnseqMemtable = config.isEnableTimedFlushUnseqMemtable();
        long preFLushInterval = config.getUnseqMemtableFlushInterval();
        config.setEnableTimedFlushUnseqMemtable(true);
        config.setUnseqMemtableFlushInterval(5L);
        StorageEngine.getInstance().rebootTimedService();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)this.processor.getWorkUnsequenceTsFileProcessors().size());
        TsFileProcessor tsFileProcessor = (TsFileProcessor)this.processor.getWorkUnsequenceTsFileProcessors().iterator().next();
        FlushManager flushManager = FlushManager.getInstance();
        this.processor.timedFlushUnseqMemTable();
        int waitCnt = 0;
        while (tsFileProcessor.getFlushingMemTableSize() != 0 || tsFileProcessor.isManagedByFlushManager() || flushManager.getNumberOfPendingTasks() != 0 || flushManager.getNumberOfPendingSubTasks() != 0 || flushManager.getNumberOfWorkingTasks() != 0 || flushManager.getNumberOfWorkingSubTasks() != 0) {
            Thread.sleep(500L);
            if (++waitCnt % 10 != 0) continue;
            logger.info("already wait {} s", (Object)(waitCnt / 2));
        }
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        config.setEnableTimedFlushUnseqMemtable(prevEnableTimedFlushUnseqMemtable);
        config.setUnseqMemtableFlushInterval(preFLushInterval);
    }

    @Test
    public void testTimedCloseTsFile() throws IllegalPathException, InterruptedException, WriteProcessException, TriggerExecutionException, ShutdownException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        long prevSeqTsFileSize = config.getSeqTsFileSize();
        config.setSeqTsFileSize(1L);
        boolean prevEnableTimedFlushSeqMemtable = config.isEnableTimedFlushSeqMemtable();
        long preFLushInterval = config.getSeqMemtableFlushInterval();
        config.setEnableTimedFlushSeqMemtable(true);
        config.setSeqMemtableFlushInterval(5L);
        boolean prevEnableTimedCloseTsFile = config.isEnableTimedCloseTsFile();
        long prevCloseTsFileInterval = config.getCloseTsFileIntervalAfterFlushing();
        config.setEnableTimedCloseTsFile(true);
        config.setCloseTsFileIntervalAfterFlushing(5L);
        StorageEngine.getInstance().rebootTimedService();
        Thread.sleep(500L);
        this.processor.timedFlushSeqMemTable();
        Assert.assertEquals((long)1L, (long)this.processor.getWorkSequenceTsFileProcessors().size());
        TsFileProcessor tsFileProcessor = (TsFileProcessor)this.processor.getWorkSequenceTsFileProcessors().iterator().next();
        FlushManager flushManager = FlushManager.getInstance();
        int waitCnt = 0;
        while (tsFileProcessor.getFlushingMemTableSize() != 0 || tsFileProcessor.isManagedByFlushManager() || flushManager.getNumberOfPendingTasks() != 0 || flushManager.getNumberOfPendingSubTasks() != 0 || flushManager.getNumberOfWorkingTasks() != 0 || flushManager.getNumberOfWorkingSubTasks() != 0) {
            Thread.sleep(500L);
            if (++waitCnt % 10 != 0) continue;
            logger.info("already wait {} s", (Object)(waitCnt / 2));
        }
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        Assert.assertFalse((boolean)tsFileProcessor.alreadyMarkedClosing());
        this.processor.timedCloseTsFileProcessor();
        Thread.sleep(500L);
        Assert.assertTrue((boolean)tsFileProcessor.alreadyMarkedClosing());
        config.setSeqTsFileSize(prevSeqTsFileSize);
        config.setEnableTimedFlushSeqMemtable(prevEnableTimedFlushSeqMemtable);
        config.setSeqMemtableFlushInterval(preFLushInterval);
        config.setEnableTimedCloseTsFile(prevEnableTimedCloseTsFile);
        config.setCloseTsFileIntervalAfterFlushing(prevCloseTsFileInterval);
    }

    @Test
    public void testDeleteDataNotInFile() throws IllegalPathException, WriteProcessException, TriggerExecutionException, InterruptedException, IOException {
        int i;
        for (i = 0; i < 5; ++i) {
            TSRecord record;
            int count;
            int d;
            if (i % 2 == 0) {
                for (d = 0; d < 2; ++d) {
                    for (count = i * 100; count < i * 100 + 100; ++count) {
                        record = new TSRecord((long)count, "root.vehicle.d" + d);
                        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(count)));
                        this.processor.insert(new InsertRowPlan(record));
                    }
                }
            } else {
                for (d = 0; d < 3; ++d) {
                    for (count = i * 100; count < i * 100 + 100; ++count) {
                        record = new TSRecord((long)count, "root.vehicle.d" + d);
                        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(count)));
                        this.processor.insert(new InsertRowPlan(record));
                    }
                }
            }
            this.processor.syncCloseAllWorkingTsFileProcessors();
        }
        this.processor.delete(new PartialPath("root.vehicle.d2.s0"), 50L, 150L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d2.s0"), 150L, 450L, 0L, null);
        for (i = 0; i < this.processor.getTsFileResourceManager().getTsFileList(true).size(); ++i) {
            TsFileResource resource = (TsFileResource)this.processor.getTsFileResourceManager().getTsFileList(true).get(i);
            if (i == 1) {
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
                continue;
            }
            if (i == 3) {
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
                continue;
            }
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
    }

    @Test
    public void testDeleteDataNotInFlushingMemtable() throws IllegalPathException, WriteProcessException, TriggerExecutionException, IOException {
        for (int j = 0; j < 100; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.processor.getTsFileResourceManager().getTsFileList(true).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.processor.delete(new PartialPath("root.vehicle.d2.s0"), 50L, 70L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L, null);
        this.processor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
    }

    @Test
    public void testDeleteDataInSeqFlushingMemtable() throws IllegalPathException, WriteProcessException, TriggerExecutionException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.processor.getTsFileResourceManager().getTsFileList(true).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 99L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 100L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 150L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 100L, 300L, 0L, null);
        this.processor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertTrue((boolean)tsFileResource.getModFile().exists());
        Assert.assertEquals((long)3L, (long)tsFileResource.getModFile().getModifications().size());
    }

    @Test
    public void testDeleteDataInUnSeqFlushingMemtable() throws IllegalPathException, WriteProcessException, TriggerExecutionException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.processor.getTsFileResourceManager().getTsFileList(true).get(0);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 99L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 100L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 150L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 100L, 300L, 0L, null);
        this.processor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        for (int j = 50; j < 100; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 200L, 299L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 80L, 85L, 0L, null);
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        tsFileResource = (TsFileResource)this.processor.getTsFileResourceManager().getTsFileList(false).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 0L, 49L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 100L, 200L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 25L, 50L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 50L, 80L, 0L, null);
        this.processor.delete(new PartialPath("root.vehicle.d0.s0"), 99L, 150L, 0L, null);
        this.processor.syncCloseAllWorkingTsFileProcessors();
        Assert.assertTrue((boolean)tsFileResource.getModFile().exists());
        Assert.assertEquals((long)3L, (long)tsFileResource.getModFile().getModifications().size());
    }

    class DummySGP
    extends VirtualStorageGroupProcessor {
        DummySGP(String systemInfoDir, String storageGroupName) throws StorageGroupProcessorException {
            super(systemInfoDir, storageGroupName, (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), storageGroupName);
        }
    }
}

