/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.timeindex.FileTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;

public class FakedTsFileResource
extends TsFileResource {
    protected ITimeIndex timeIndex = new FileTimeIndex();
    private long tsFileSize;
    private String fakeTsfileName;

    public FakedTsFileResource(long tsFileSize, String name) {
        this.tsFileSize = tsFileSize;
        this.status = TsFileResourceStatus.CLOSED;
        this.fakeTsfileName = name;
    }

    public void setTsFileSize(long tsFileSize) {
        this.tsFileSize = tsFileSize;
    }

    public long getTsFileSize() {
        return this.tsFileSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tsFileSize).append(",");
        builder.append(this.status);
        return builder.toString();
    }

    public File getTsFile() {
        return new File(this.fakeTsfileName);
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof FakedTsFileResource) {
            FakedTsFileResource otherResource = (FakedTsFileResource)((Object)otherObject);
            return this.fakeTsfileName.equals(otherResource.fakeTsfileName) && this.tsFileSize == otherResource.tsFileSize;
        }
        return false;
    }
}

