/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeletionQueryTest {
    private String processorName = "root.test";
    private static String[] measurements = new String[10];
    private TSDataType dataType = TSDataType.DOUBLE;
    private TSEncoding encoding = TSEncoding.PLAIN;
    private QueryRouter router = new QueryRouter();

    @Before
    public void setup() throws MetadataException {
        EnvironmentUtils.envSetUp();
        IoTDB.metaManager.setStorageGroup(new PartialPath(this.processorName));
        for (int i = 0; i < 10; ++i) {
            IoTDB.metaManager.createTimeseries(new PartialPath(this.processorName + "." + measurements[i]), this.dataType, this.encoding, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
    }

    @After
    public void teardown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDeleteInBufferWriteCache() throws StorageEngineException, IOException, QueryProcessException, MetadataException {
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.processorName);
            for (int j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[3]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[4]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedPathsAndUpdate(pathList);
        QueryDataSet dataSet = this.router.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int count = 0;
        while (dataSet.hasNext()) {
            dataSet.next();
            ++count;
        }
        Assert.assertEquals((long)50L, (long)count);
    }

    @Test
    public void testDeleteInBufferWriteFile() throws StorageEngineException, IOException, QueryProcessException, MetadataException {
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.processorName);
            for (int j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 40L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 30L, -1L, null);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[3]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[4]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedPathsAndUpdate(pathList);
        QueryDataSet dataSet = this.router.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int count = 0;
        while (dataSet.hasNext()) {
            dataSet.next();
            ++count;
        }
        Assert.assertEquals((long)70L, (long)count);
    }

    @Test
    public void testDeleteInOverflowCache() throws StorageEngineException, IOException, QueryProcessException, MetadataException {
        int j;
        TSRecord record;
        int i;
        for (i = 101; i <= 200; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[3]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[4]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedPathsAndUpdate(pathList);
        QueryDataSet dataSet = this.router.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int count = 0;
        while (dataSet.hasNext()) {
            dataSet.next();
            ++count;
        }
        Assert.assertEquals((long)150L, (long)count);
    }

    @Test
    public void testDeleteInOverflowFile() throws StorageEngineException, IOException, QueryProcessException, MetadataException {
        int j;
        TSRecord record;
        int i;
        for (i = 101; i <= 200; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 40L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 30L, -1L, null);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[3]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[4]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedPathsAndUpdate(pathList);
        QueryDataSet dataSet = this.router.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int count = 0;
        while (dataSet.hasNext()) {
            dataSet.next();
            ++count;
        }
        Assert.assertEquals((long)170L, (long)count);
    }

    @Test
    public void testSuccessiveDeletion() throws StorageEngineException, IOException, QueryProcessException, MetadataException {
        int j;
        TSRecord record;
        int i;
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 101; i <= 200; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 250L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 250L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 230L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 230L, 250L, -1L, null);
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 201; i <= 300; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        StorageEngine.getInstance().syncCloseAllProcessor();
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[3]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[4]));
        pathList.add(SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedPathsAndUpdate(pathList);
        QueryDataSet dataSet = this.router.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int count = 0;
        while (dataSet.hasNext()) {
            dataSet.next();
            ++count;
        }
        Assert.assertEquals((long)100L, (long)count);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            DeletionQueryTest.measurements[i] = "m" + i;
        }
    }
}

