/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveMemTableTest {
    double delta;

    @Before
    public void setUp() {
        this.delta = Math.pow(0.1, TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
    }

    @Test
    public void memSeriesSortIteratorTest() throws IOException {
        TSDataType dataType = TSDataType.INT32;
        WritableMemChunk series = new WritableMemChunk((IMeasurementSchema)new MeasurementSchema("s1", dataType, TSEncoding.PLAIN));
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            series.write((long)i, (Object)i);
        }
        IPointReader it = series.getSortedTvListForQuery().getIterator();
        int i = 0;
        while (it.hasNextTimeValuePair()) {
            Assert.assertEquals((long)i, (long)it.nextTimeValuePair().getTimestamp());
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
    }

    @Test
    public void memSeriesToStringTest() throws IOException {
        TSDataType dataType = TSDataType.INT32;
        WritableMemChunk series = new WritableMemChunk((IMeasurementSchema)new MeasurementSchema("s1", dataType, TSEncoding.PLAIN));
        int count = 100;
        for (int i = 0; i < count; ++i) {
            series.write((long)i, (Object)i);
        }
        series.write(0L, (Object)21);
        series.write(99L, (Object)20);
        series.write(20L, (Object)21);
        String str = series.toString();
        Assert.assertFalse((boolean)series.getTVList().isSorted());
        Assert.assertEquals((Object)("MemChunk Size: 103" + System.lineSeparator() + "Data type:INT32" + System.lineSeparator() + "First point:0 : 0" + System.lineSeparator() + "Last point:99 : 20" + System.lineSeparator()), (Object)str);
    }

    @Test
    public void simpleTest() throws IOException, QueryProcessException, MetadataException {
        int i;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i2 = 0; i2 < measurementId.length; ++i2) {
            measurementId[i2] = "s" + i2;
        }
        int dataSize = 10000;
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)(dataSize - i - 1), new Object[]{i + 10});
        }
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)i, new Object[]{i});
        }
        MeasurementPath fullPath = new MeasurementPath(deviceId, measurementId[0], (IMeasurementSchema)new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
        ReadOnlyMemChunk memChunk = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        for (int i3 = 0; i3 < dataSize; ++i3) {
            iterator.hasNextTimeValuePair();
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)i3, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((Object)i3, (Object)timeValuePair.getValue().getValue());
        }
    }

    @Test
    public void totalSeriesNumberTest() throws IOException, QueryProcessException, MetadataException {
        int i;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i2 = 0; i2 < measurementId.length; ++i2) {
            measurementId[i2] = "s" + i2;
        }
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        schemaList.add(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN));
        schemaList.add(new MeasurementSchema(measurementId[1], TSDataType.INT32, TSEncoding.PLAIN));
        int dataSize = 10000;
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)i, new Object[]{i});
        }
        deviceId = "d2";
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), schemaList, (long)i, new Object[]{i, i});
        }
        Assert.assertEquals((long)3L, (long)memTable.getSeriesNumber());
        deviceId = "d3";
        for (i = 0; i < dataSize; ++i) {
            memTable.writeAlignedRow(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), schemaList, (long)i, new Object[]{i, i});
        }
        Assert.assertEquals((long)5L, (long)memTable.getSeriesNumber());
        memTable.writeAlignedRow(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[2], TSDataType.INT32, TSEncoding.PLAIN)), 0L, new Object[]{0});
        Assert.assertEquals((long)6L, (long)memTable.getSeriesNumber());
    }

    @Test
    public void queryWithDeletionTest() throws IOException, QueryProcessException, MetadataException {
        int i;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i2 = 0; i2 < measurementId.length; ++i2) {
            measurementId[i2] = "s" + i2;
        }
        int dataSize = 10000;
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)(dataSize - i - 1), new Object[]{i + 10});
        }
        for (i = 0; i < dataSize; ++i) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)i, new Object[]{i});
        }
        MeasurementPath fullPath = new MeasurementPath(deviceId, measurementId[0], (IMeasurementSchema)new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
        ArrayList<Pair> modsToMemtable = new ArrayList<Pair>();
        Deletion deletion = new Deletion(new PartialPath(deviceId, measurementId[0]), Long.MAX_VALUE, 10L, (long)dataSize);
        modsToMemtable.add(new Pair((Object)deletion, (Object)memTable));
        ReadOnlyMemChunk memChunk = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, modsToMemtable);
        IPointReader iterator = memChunk.getPointReader();
        int cnt = 0;
        while (iterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)cnt, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((Object)cnt, (Object)timeValuePair.getValue().getValue());
            ++cnt;
        }
        Assert.assertEquals((long)10L, (long)cnt);
    }

    @Test
    public void queryAlignChuckWithDeletionTest() throws IOException, QueryProcessException, MetadataException {
        int i;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i2 = 0; i2 < measurementId.length; ++i2) {
            measurementId[i2] = "s" + i2;
        }
        int dataSize = 10000;
        for (i = 0; i < dataSize; ++i) {
            memTable.writeAlignedRow(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)(dataSize - i - 1), new Object[]{i + 10});
        }
        for (i = 0; i < dataSize; ++i) {
            memTable.writeAlignedRow(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN)), (long)i, new Object[]{i});
        }
        AlignedPath fullPath = new AlignedPath(deviceId, Collections.singletonList(measurementId[0]), Collections.singletonList(new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap())));
        ArrayList<Pair> modsToMemtable = new ArrayList<Pair>();
        Deletion deletion = new Deletion(new PartialPath(deviceId, measurementId[0]), Long.MAX_VALUE, 10L, (long)dataSize);
        modsToMemtable.add(new Pair((Object)deletion, (Object)memTable));
        ReadOnlyMemChunk memChunk = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, modsToMemtable);
        IPointReader iterator = memChunk.getPointReader();
        int cnt = 0;
        while (iterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)cnt, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)cnt, (long)timeValuePair.getValue().getVector()[0].getInt());
            ++cnt;
        }
        Assert.assertEquals((long)10L, (long)cnt);
    }

    /*
     * WARNING - void declaration
     */
    private void write(IMemTable memTable, String deviceId, String sensorId, TSDataType dataType, TSEncoding encoding, int size) throws IOException, QueryProcessException, MetadataException {
        void var11_15;
        Object[] ret;
        for (TimeValuePair timeValuePair : ret = this.genTimeValuePair(size, dataType)) {
            memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(sensorId, dataType, encoding)), timeValuePair.getTimestamp(), new Object[]{timeValuePair.getValue().getValue()});
        }
        MeasurementPath fullPath = new MeasurementPath(deviceId, sensorId, (IMeasurementSchema)new MeasurementSchema(sensorId, dataType, encoding, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
        IPointReader tvPair = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null).getPointReader();
        Arrays.sort(ret);
        Object last = null;
        boolean bl = false;
        while (var11_15 < ret.length) {
            Object pair;
            while (last != null && var11_15 < ret.length && last.getTimestamp() == ret[var11_15].getTimestamp()) {
                ++var11_15;
            }
            if (var11_15 >= ret.length) break;
            last = pair = ret[var11_15];
            tvPair.hasNextTimeValuePair();
            TimeValuePair next = tvPair.nextTimeValuePair();
            Assert.assertEquals((long)pair.getTimestamp(), (long)next.getTimestamp());
            if (dataType == TSDataType.DOUBLE) {
                Assert.assertEquals((double)pair.getValue().getDouble(), (double)MathUtils.roundWithGivenPrecision((double)next.getValue().getDouble()), (double)this.delta);
            } else if (dataType == TSDataType.FLOAT) {
                float expected = pair.getValue().getFloat();
                float actual = MathUtils.roundWithGivenPrecision((float)next.getValue().getFloat());
                Assert.assertEquals((double)expected, (double)actual, (double)(this.delta + 1.1754943508222875E-38));
            } else {
                Assert.assertEquals((Object)pair.getValue(), (Object)next.getValue());
            }
            ++var11_15;
        }
    }

    private void writeVector(IMemTable memTable) throws IOException, QueryProcessException, MetadataException {
        TimeValuePair next;
        int i;
        memTable.writeAlignedTablet(this.genInsertTablePlan(), 0, 100);
        AlignedPath fullPath = new AlignedPath("root.sg.device5", Collections.singletonList("sensor1"), Collections.singletonList(new MeasurementSchema("sensor1", TSDataType.INT64, TSEncoding.GORILLA, CompressionType.UNCOMPRESSED, Collections.emptyMap())));
        IPointReader tvPair = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null).getPointReader();
        for (i = 0; i < 100; ++i) {
            tvPair.hasNextTimeValuePair();
            next = tvPair.nextTimeValuePair();
            Assert.assertEquals((long)i, (long)next.getTimestamp());
            Assert.assertEquals((long)i, (long)next.getValue().getVector()[0].getLong());
        }
        fullPath = new AlignedPath("root.sg.device5", Arrays.asList("sensor0", "sensor1"), Arrays.asList(new MeasurementSchema("sensor0", TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap()), new MeasurementSchema("sensor1", TSDataType.INT64, TSEncoding.GORILLA, CompressionType.UNCOMPRESSED, Collections.emptyMap())));
        tvPair = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null).getPointReader();
        for (i = 0; i < 100; ++i) {
            tvPair.hasNextTimeValuePair();
            next = tvPair.nextTimeValuePair();
            Assert.assertEquals((long)i, (long)next.getTimestamp());
            Assert.assertEquals((long)i, (long)next.getValue().getVector()[1].getLong());
        }
    }

    @Test
    public void testFloatType() throws IOException, QueryProcessException, MetadataException {
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        String deviceId = "d1";
        int size = 100;
        this.write((IMemTable)memTable, deviceId, "s1", TSDataType.FLOAT, TSEncoding.RLE, size);
    }

    @Test
    public void testAllType() throws IOException, QueryProcessException, MetadataException {
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i = 0; i < measurementId.length; ++i) {
            measurementId[i] = "s" + i;
        }
        int index = 0;
        int size = 10000;
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.BOOLEAN, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.INT32, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.INT64, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.FLOAT, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.DOUBLE, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.TEXT, TSEncoding.PLAIN, size);
        this.writeVector((IMemTable)memTable);
    }

    private TimeValuePair[] genTimeValuePair(int size, TSDataType dataType) {
        TimeValuePair[] ret = new TimeValuePair[size];
        Random rand = new Random();
        block8: for (int i = 0; i < size; ++i) {
            switch (dataType) {
                case BOOLEAN: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)true));
                    continue block8;
                }
                case INT32: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextInt()));
                    continue block8;
                }
                case INT64: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextLong()));
                    continue block8;
                }
                case FLOAT: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)Float.valueOf(rand.nextFloat())));
                    continue block8;
                }
                case DOUBLE: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextDouble()));
                    continue block8;
                }
                case TEXT: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)new Binary("a" + rand.nextDouble())));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
                }
            }
        }
        return ret;
    }

    private InsertTabletPlan genInsertTablePlan() throws IllegalPathException {
        String[] measurements = new String[]{"sensor0", "sensor1"};
        ArrayList<Integer> dataTypesList = new ArrayList<Integer>();
        TSDataType[] dataTypes = new TSDataType[2];
        dataTypesList.add(TSDataType.BOOLEAN.ordinal());
        dataTypesList.add(TSDataType.INT64.ordinal());
        dataTypes[0] = TSDataType.BOOLEAN;
        dataTypes[1] = TSDataType.INT64;
        TSEncoding[] encodings = new TSEncoding[]{TSEncoding.PLAIN, TSEncoding.GORILLA};
        String deviceId = "root.sg.device5";
        IMeasurementMNode[] mNodes = new IMeasurementMNode[2];
        MeasurementSchema schema0 = new MeasurementSchema(measurements[0], dataTypes[0], encodings[0]);
        MeasurementSchema schema1 = new MeasurementSchema(measurements[1], dataTypes[1], encodings[1]);
        mNodes[0] = MeasurementMNode.getMeasurementMNode(null, (String)"sensor0", (IMeasurementSchema)schema0, null);
        mNodes[1] = MeasurementMNode.getMeasurementMNode(null, (String)"sensor1", (IMeasurementSchema)schema1, null);
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(deviceId), measurements, dataTypesList);
        long[] times = new long[100];
        Object[] columns = new Object[]{new boolean[100], new long[100]};
        for (long r = 0L; r < 100L; ++r) {
            times[(int)r] = r;
            ((boolean[])columns[0])[(int)r] = false;
            ((long[])columns[1])[(int)r] = r;
        }
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setMeasurementMNodes(mNodes);
        insertTabletPlan.setStart(0);
        insertTabletPlan.setEnd(100);
        insertTabletPlan.setAligned(true);
        return insertTabletPlan;
    }
}

