/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.Collections;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MemtableBenchmark {
    private static String deviceId = "d0";
    private static int numOfMeasurement = 10000;
    private static int numOfPoint = 1000;
    private static String[] measurementId = new String[numOfMeasurement];
    private static TSDataType tsDataType = TSDataType.INT64;

    public static void main(String[] args) throws IllegalPathException {
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numOfPoint; ++i) {
            for (int j = 0; j < numOfMeasurement; ++j) {
                memTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.emptyList(), Collections.singletonList(new MeasurementSchema(measurementId[j], tsDataType, TSEncoding.PLAIN)), System.nanoTime(), new Object[]{System.currentTimeMillis()});
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println(String.format("Num of time series: %d, Num of points for each time series: %d, The total time: %d ms. ", numOfMeasurement, numOfPoint, endTime - startTime));
    }

    static {
        for (int i = 0; i < numOfMeasurement; ++i) {
            MemtableBenchmark.measurementId[i] = "m" + i;
        }
    }
}

