/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.cross.CrossCompactionStrategy;
import org.apache.iotdb.db.engine.compaction.inner.InnerCompactionStrategy;

public class CompactionConfigRestorer {
    private boolean enableSeqSpaceCompaction = true;
    private boolean enableUnseqSpaceCompaction = false;
    private boolean enableCrossSpaceCompaction = true;
    private CrossCompactionStrategy crossStrategy = CrossCompactionStrategy.REWRITE_COMPACTION;
    private InnerCompactionStrategy innerStrategy = InnerCompactionStrategy.SIZE_TIERED_COMPACTION;
    private CompactionPriority priority = CompactionPriority.BALANCE;
    private long targetFileSize = 0x40000000L;
    private long targetChunkSize = 0x100000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 128L;
    private long chunkPointNumLowerBoundInCompaction = 100L;
    private int maxInnerCompactionCandidateFileNum = 30;
    private int maxCrossCompactionCandidateFileNum = 1000;
    private int concurrentCompactionThread = 10;
    private long compactionScheduleIntervalInMs = 60000L;
    private long compactionSubmissionIntervalInMs = 60000L;
    private int compactionWriteThroughputMbPerSec = 8;

    public void restoreCompactionConfig() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        config.setEnableSeqSpaceCompaction(this.enableSeqSpaceCompaction);
        config.setEnableUnseqSpaceCompaction(this.enableUnseqSpaceCompaction);
        config.setEnableCrossSpaceCompaction(this.enableCrossSpaceCompaction);
        config.setCrossCompactionStrategy(this.crossStrategy);
        config.setInnerCompactionStrategy(this.innerStrategy);
        config.setCompactionPriority(this.priority);
        config.setTargetCompactionFileSize(this.targetFileSize);
        config.setTargetChunkSize(this.targetChunkSize);
        config.setTargetChunkPointNum(this.targetChunkPointNum);
        config.setChunkSizeLowerBoundInCompaction(this.chunkSizeLowerBoundInCompaction);
        config.setChunkPointNumLowerBoundInCompaction(this.chunkPointNumLowerBoundInCompaction);
        config.setMaxInnerCompactionCandidateFileNum(this.maxInnerCompactionCandidateFileNum);
        config.setMaxCrossCompactionCandidateFileNum(this.maxCrossCompactionCandidateFileNum);
        config.setConcurrentCompactionThread(this.concurrentCompactionThread);
        config.setCompactionScheduleIntervalInMs(this.compactionScheduleIntervalInMs);
        config.setCompactionSubmissionIntervalInMs(this.compactionSubmissionIntervalInMs);
        config.setCompactionWriteThroughputMbPerSec(this.compactionWriteThroughputMbPerSec);
    }
}

