/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;

public class CompactionClearUtils {
    public static void clearAllCompactionFiles() throws IOException {
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".tsfile");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".resource");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".mods");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".inner");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".cross");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".inner-compaction.log");
        CompactionClearUtils.deleteAllFilesInOneDirBySuffix("target", ".cross-compaction.log");
        if (IoTDBDescriptor.getInstance().getConfig().isMetaDataCacheEnable()) {
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }

    private static void deleteAllFilesInOneDirBySuffix(String dirPath, String suffix) throws IOException {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        for (File f : FSFactoryProducer.getFSFactory().listFilesBySuffix(dirPath, suffix)) {
            FileUtils.delete((File)f);
        }
        File[] tmpFiles = dir.listFiles();
        if (tmpFiles != null) {
            for (File f : tmpFiles) {
                if (!f.isDirectory()) continue;
                CompactionClearUtils.deleteAllFilesInOneDirBySuffix(f.getAbsolutePath(), suffix);
            }
        }
    }

    public static void deleteEmptyDir(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        for (File f : dir.listFiles()) {
            CompactionClearUtils.deleteEmptyDir(f);
        }
        dir.delete();
    }
}

