/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.junit.Assert;

public class CompactionCheckerUtils {
    public static void putOnePageChunks(Map<String, List<List<Long>>> chunkPagePointsNum, String fullPath, long[] pagePointNums) {
        for (long pagePointNum : pagePointNums) {
            CompactionCheckerUtils.putChunk(chunkPagePointsNum, fullPath, new long[]{pagePointNum});
        }
    }

    public static void putOnePageChunk(Map<String, List<List<Long>>> chunkPagePointsNum, String fullPath, long pagePointNum) {
        CompactionCheckerUtils.putChunk(chunkPagePointsNum, fullPath, new long[]{pagePointNum});
    }

    public static void putChunk(Map<String, List<List<Long>>> chunkPagePointsNum, String fullPath, long[] pagePointNums) {
        ArrayList<Long> pagePointsNum = new ArrayList<Long>();
        for (long pagePointNum : pagePointNums) {
            pagePointsNum.add(pagePointNum);
        }
        List chunkPointsNum = chunkPagePointsNum.computeIfAbsent(fullPath, k -> new ArrayList());
        chunkPointsNum.add(pagePointsNum);
    }

    public static Map<String, List<TimeValuePair>> readFiles(List<TsFileResource> tsFileResources) throws IOException, IllegalPathException {
        HashMap<String, Map> mapResult = new HashMap<String, Map>();
        for (TsFileResource tsFileResource : tsFileResources) {
            TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
            Throwable throwable = null;
            try {
                List allPaths = reader.getAllPaths();
                for (Path path : allPaths) {
                    Map timeValuePairMap = mapResult.computeIfAbsent(path.getFullPath(), k -> new TreeMap());
                    List chunkMetadataList = reader.getChunkMetadataList(path);
                    LinkedList<Modification> seriesModifications = new LinkedList<Modification>();
                    for (Modification modification : tsFileResource.getModFile().getModifications()) {
                        if (!modification.getPath().matchFullPath(new PartialPath(path.getFullPath()))) continue;
                        seriesModifications.add(modification);
                    }
                    QueryUtils.modifyChunkMetaData((List)chunkMetadataList, seriesModifications);
                    for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                        Chunk chunk = reader.readMemChunk(chunkMetadata);
                        ChunkReader chunkReader = new ChunkReader(chunk, null);
                        while (chunkReader.hasNextSatisfiedPage()) {
                            BatchData batchData = chunkReader.nextPageData();
                            BatchData.BatchDataIterator batchDataIterator = batchData.getBatchDataIterator();
                            while (batchDataIterator.hasNext()) {
                                timeValuePairMap.put(batchDataIterator.currentTime(), new TimeValuePair(batchDataIterator.currentTime(), TsPrimitiveType.getByType((TSDataType)chunkMetadata.getDataType(), (Object)batchDataIterator.currentValue())));
                                batchDataIterator.next();
                            }
                        }
                    }
                }
            }
            catch (Throwable allPaths) {
                throwable = allPaths;
                throw allPaths;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable allPaths) {
                        throwable.addSuppressed(allPaths);
                    }
                    continue;
                }
                reader.close();
            }
        }
        HashMap<String, List<TimeValuePair>> result = new HashMap<String, List<TimeValuePair>>();
        for (Map.Entry mapResultEntry : mapResult.entrySet()) {
            String fullPath = (String)mapResultEntry.getKey();
            Map timeValuePairMap = (Map)mapResultEntry.getValue();
            ArrayList timeValuePairs = new ArrayList(timeValuePairMap.values());
            result.put(fullPath, timeValuePairs);
        }
        return result;
    }

    public static void checkDataAndResource(Map<String, List<TimeValuePair>> sourceData, List<TsFileResource> mergedFiles) throws IOException, IllegalPathException {
        Map<String, List<TimeValuePair>> mergedData = CompactionCheckerUtils.readFiles(mergedFiles);
        CompactionCheckerUtils.compareSensorAndData(sourceData, mergedData);
        CompactionCheckerUtils.checkDataFromFrontToEnd(sourceData, mergedFiles);
        CompactionCheckerUtils.checkTsFileResource(sourceData, mergedFiles);
    }

    private static void checkDataFromFrontToEnd(Map<String, List<TimeValuePair>> sourceData, List<TsFileResource> mergedFiles) throws IOException, IllegalPathException {
        HashMap<String, List<TimeValuePair>> mergedData = new HashMap<String, List<TimeValuePair>>();
        HashMap<String, Long> fullPathPointNum = new HashMap<String, Long>();
        for (TsFileResource tsFileResource : mergedFiles) {
            TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
            Object object = null;
            try {
                byte marker;
                String device = "";
                String measurementID = "";
                ArrayList<TimeValuePair> currTimeValuePairs = new ArrayList<TimeValuePair>();
                reader.position((long)"TsFile".getBytes().length + 1L);
                block15: while ((marker = reader.readMarker()) != 2) {
                    switch (marker) {
                        case -127: 
                        case -123: 
                        case 1: 
                        case 5: 
                        case 65: 
                        case 69: {
                            PartialPath path;
                            PageHeader pageHeader;
                            ChunkHeader header = reader.readChunkHeader(marker);
                            if (currTimeValuePairs.size() > 0) {
                                PartialPath path2 = new PartialPath(device, measurementID);
                                List timeValuePairs = mergedData.computeIfAbsent(path2.getFullPath(), k -> new ArrayList());
                                timeValuePairs.addAll(currTimeValuePairs);
                                currTimeValuePairs.clear();
                            }
                            measurementID = header.getMeasurementID();
                            Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                            Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                            for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                                valueDecoder.reset();
                                pageHeader = reader.readPageHeader(header.getDataType(), header.getChunkType() == 1);
                                path = new PartialPath(device, measurementID);
                                ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                                PageReader reader1 = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                                BatchData batchData = reader1.getAllSatisfiedPageData();
                                long count = fullPathPointNum.getOrDefault(path.getFullPath(), 0L);
                                count = header.getChunkType() == 1 ? (count += pageHeader.getNumOfValues()) : (count += (long)batchData.length());
                                fullPathPointNum.put(path.getFullPath(), count);
                                BatchData.BatchDataIterator batchDataIterator = batchData.getBatchDataIterator();
                                while (batchDataIterator.hasNext()) {
                                    currTimeValuePairs.add(new TimeValuePair(batchDataIterator.currentTime(), TsPrimitiveType.getByType((TSDataType)header.getDataType(), (Object)batchDataIterator.currentValue())));
                                    batchDataIterator.next();
                                }
                            }
                            continue block15;
                        }
                        case 0: {
                            PartialPath path;
                            ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                            if (currTimeValuePairs.size() > 0) {
                                path = new PartialPath(device, measurementID);
                                List timeValuePairs = mergedData.computeIfAbsent(path.getFullPath(), k -> new ArrayList());
                                timeValuePairs.addAll(currTimeValuePairs);
                                currTimeValuePairs.clear();
                            }
                            device = chunkGroupHeader.getDeviceID();
                            continue block15;
                        }
                        case 4: {
                            reader.readPlanIndex();
                            continue block15;
                        }
                    }
                    MetaMarker.handleUnexpectedMarker((byte)marker);
                }
                if (currTimeValuePairs.size() > 0) {
                    PartialPath path = new PartialPath(device, measurementID);
                    List timeValuePairs = mergedData.computeIfAbsent(path.getFullPath(), k -> new ArrayList());
                    timeValuePairs.addAll(currTimeValuePairs);
                }
            }
            catch (Throwable device) {
                object = device;
                throw device;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable device) {
                            ((Throwable)object).addSuppressed(device);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            Collection modifications = ModificationFile.getNormalMods((TsFileResource)tsFileResource).getModifications();
            for (Modification modification : modifications) {
                Deletion deletion = (Deletion)modification;
                if (!mergedData.containsKey(deletion.getPath().getFullPath())) continue;
                long deletedCount = 0L;
                Iterator timeValuePairIterator = ((List)mergedData.get(deletion.getPath().getFullPath())).iterator();
                while (timeValuePairIterator.hasNext()) {
                    TimeValuePair timeValuePair = (TimeValuePair)timeValuePairIterator.next();
                    if (timeValuePair.getTimestamp() < deletion.getStartTime() || timeValuePair.getTimestamp() > deletion.getEndTime()) continue;
                    timeValuePairIterator.remove();
                    ++deletedCount;
                }
                long count = (Long)fullPathPointNum.get(deletion.getPath().getFullPath());
                fullPathPointNum.put(deletion.getPath().getFullPath(), count -= deletedCount);
            }
        }
        CompactionCheckerUtils.compareSensorAndData(sourceData, mergedData);
        for (Map.Entry entry : sourceData.entrySet()) {
            String fullPath = (String)entry.getKey();
            long sourceDataNum = ((List)entry.getValue()).size();
            long targetDataNum = fullPathPointNum.getOrDefault(fullPath, 0L);
            Assert.assertEquals((long)sourceDataNum, (long)targetDataNum);
        }
    }

    /*
     * Exception decompiling
     */
    private static void checkTsFileResource(Map<String, List<TimeValuePair>> sourceData, List<TsFileResource> mergedFiles) throws IllegalPathException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void compareSensorAndData(Map<String, List<TimeValuePair>> expectedData, Map<String, List<TimeValuePair>> targetData) {
        for (Map.Entry<String, List<TimeValuePair>> sourceDataEntry : expectedData.entrySet()) {
            String fullPath = sourceDataEntry.getKey();
            List<TimeValuePair> sourceTimeValuePairs = sourceDataEntry.getValue();
            List<TimeValuePair> targetTimeValuePairs = targetData.get(fullPath);
            CompactionCheckerUtils.compareData(sourceTimeValuePairs, targetTimeValuePairs);
        }
    }

    private static void compareData(List<TimeValuePair> expectedData, List<TimeValuePair> targetData) {
        if (targetData.size() > expectedData.size()) {
            Assert.fail();
        }
        if (targetData.size() < expectedData.size()) {
            Assert.fail();
        }
        for (int i = 0; i < expectedData.size(); ++i) {
            TimeValuePair expectedTimeValuePair = expectedData.get(i);
            TimeValuePair targetTimeValuePair = targetData.get(i);
            Assert.assertEquals((long)expectedTimeValuePair.getTimestamp(), (long)targetTimeValuePair.getTimestamp());
            Assert.assertEquals((Object)expectedTimeValuePair.getValue(), (Object)targetTimeValuePair.getValue());
        }
    }

    public static void checkChunkAndPage(Map<String, List<List<Long>>> chunkPagePointsNum, TsFileResource mergedFile) throws IOException, IllegalPathException {
        HashMap<String, List> mergedChunkPagePointsNum = new HashMap<String, List>();
        ArrayList<Long> pagePointsNum = new ArrayList<Long>();
        try (TsFileSequenceReader reader = new TsFileSequenceReader(mergedFile.getTsFilePath());){
            byte marker;
            String entity = "";
            String measurement = "";
            reader.position((long)"TsFile".getBytes().length + 1L);
            block14: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        PageHeader pageHeader;
                        ChunkHeader header = reader.readChunkHeader(marker);
                        if (pagePointsNum.size() > 0) {
                            String fullPath = new PartialPath(entity, measurement).getFullPath();
                            List currChunkPagePointsNum = mergedChunkPagePointsNum.computeIfAbsent(fullPath, k -> new ArrayList());
                            currChunkPagePointsNum.add(pagePointsNum);
                            pagePointsNum = new ArrayList();
                        }
                        measurement = header.getMeasurementID();
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                            valueDecoder.reset();
                            pageHeader = reader.readPageHeader(header.getDataType(), header.getChunkType() == 1);
                            ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                            PageReader reader1 = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                            BatchData batchData = reader1.getAllSatisfiedPageData();
                            if (header.getChunkType() == 1) {
                                pagePointsNum.add(pageHeader.getNumOfValues());
                            } else {
                                pagePointsNum.add(Long.valueOf(batchData.length()));
                            }
                            BatchData.BatchDataIterator batchDataIterator = batchData.getBatchDataIterator();
                            while (batchDataIterator.hasNext()) {
                                batchDataIterator.next();
                            }
                        }
                        continue block14;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        if (pagePointsNum.size() > 0) {
                            String fullPath = new PartialPath(entity, measurement).getFullPath();
                            List currChunkPagePointsNum = mergedChunkPagePointsNum.computeIfAbsent(fullPath, k -> new ArrayList());
                            currChunkPagePointsNum.add(pagePointsNum);
                            pagePointsNum = new ArrayList();
                        }
                        entity = chunkGroupHeader.getDeviceID();
                        continue block14;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block14;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            if (pagePointsNum.size() > 0) {
                String fullPath = new PartialPath(entity, measurement).getFullPath();
                List currChunkPagePointsNum = mergedChunkPagePointsNum.computeIfAbsent(fullPath, k -> new ArrayList());
                currChunkPagePointsNum.add(pagePointsNum);
            }
            for (Map.Entry<String, List<List<Long>>> chunkPagePointsNumEntry : chunkPagePointsNum.entrySet()) {
                String fullPath = chunkPagePointsNumEntry.getKey();
                List<List<Long>> sourceChunkPages = chunkPagePointsNumEntry.getValue();
                List mergedChunkPages = (List)mergedChunkPagePointsNum.get(fullPath);
                if (sourceChunkPages == null) {
                    Assert.assertNull((Object)mergedChunkPages);
                    continue;
                }
                for (int i = 0; i < sourceChunkPages.size(); ++i) {
                    for (int j = 0; j < sourceChunkPages.get(i).size(); ++j) {
                        Assert.assertEquals((Object)sourceChunkPages.get(i).get(j), ((List)mergedChunkPages.get(i)).get(j));
                    }
                }
            }
        }
    }

    public static Map<PartialPath, List<TimeValuePair>> getDataByQuery(List<PartialPath> fullPaths, List<IMeasurementSchema> schemas, List<TsFileResource> sequenceResources, List<TsFileResource> unsequenceResources) throws IllegalPathException, IOException {
        HashMap<PartialPath, List<TimeValuePair>> pathDataMap = new HashMap<PartialPath, List<TimeValuePair>>();
        for (int i = 0; i < fullPaths.size(); ++i) {
            TimeSeriesMetadataCache.getInstance().clear();
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            ChunkCache.getInstance().clear();
            PartialPath path = fullPaths.get(i);
            LinkedList<TimeValuePair> dataList = new LinkedList<TimeValuePair>();
            SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, path.getSeriesType(), EnvironmentUtils.TEST_QUERY_CONTEXT, sequenceResources, unsequenceResources, null, null, true);
            while (reader.hasNextBatch()) {
                BatchData batchData = reader.nextBatch();
                while (batchData.hasCurrent()) {
                    dataList.add(new TimeValuePair(batchData.currentTime(), batchData.currentTsPrimitiveType()));
                    batchData.next();
                }
            }
            pathDataMap.put(fullPaths.get(i), dataList);
            TimeSeriesMetadataCache.getInstance().clear();
            ChunkCache.getInstance().clear();
        }
        TimeSeriesMetadataCache.getInstance().clear();
        ChunkCache.getInstance().clear();
        return pathDataMap;
    }

    public static void validDataByValueList(Map<PartialPath, List<TimeValuePair>> expectedData, Map<PartialPath, List<TimeValuePair>> actualData) {
        for (PartialPath path : expectedData.keySet()) {
            List<TimeValuePair> expectedTimeValueList = expectedData.get(path);
            List<TimeValuePair> actualTimeValueList = actualData.get(path);
            Assert.assertEquals((long)expectedTimeValueList.size(), (long)actualTimeValueList.size());
            for (int i = 0; i < expectedTimeValueList.size(); ++i) {
                TimeValuePair expectedTimeValuePair = expectedTimeValueList.get(i);
                TimeValuePair actualTimeValuePair = actualTimeValueList.get(i);
                Assert.assertEquals((long)expectedTimeValuePair.getTimestamp(), (long)actualTimeValuePair.getTimestamp());
                TSDataType type = expectedTimeValuePair.getValue().getDataType();
                if (type == TSDataType.VECTOR) {
                    TsPrimitiveType[] expectedVector = expectedTimeValuePair.getValue().getVector();
                    TsPrimitiveType[] actualVector = actualTimeValuePair.getValue().getVector();
                    Assert.assertEquals((long)expectedVector.length, (long)actualVector.length);
                    for (int j = 0; j < expectedVector.length; ++j) {
                        Assert.assertEquals((Object)expectedVector[j], (Object)actualVector[j]);
                    }
                    continue;
                }
                Assert.assertEquals((Object)expectedTimeValuePair.getValue(), (Object)actualTimeValuePair.getValue());
            }
        }
    }
}

