/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.FakedTsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class FakedInnerSpaceCompactionTask
extends SizeTieredCompactionTask {
    public FakedInnerSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, AtomicInteger currentTaskNum) {
        super(logicalStorageGroupName, virtualStorageGroupName, timePartition, tsFileManager, selectedTsFileResourceList, sequence, currentTaskNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCompaction() throws IOException {
        try {
            TsFileNameGenerator.TsFileName name = TsFileNameGenerator.getTsFileName((String)((TsFileResource)this.selectedTsFileResourceList.get(0)).getTsFile().getName());
            String newName = TsFileNameGenerator.generateNewTsFileName((long)name.getTime(), (long)name.getVersion(), (int)(name.getInnerCompactionCnt() + 1), (int)name.getCrossCompactionCnt());
            FakedTsFileResource targetTsFileResource = new FakedTsFileResource(0L, newName);
            long targetFileSize = 0L;
            for (TsFileResource resource : this.selectedTsFileResourceList) {
                targetFileSize += resource.getTsFileSize();
            }
            targetTsFileResource.setTsFileSize(targetFileSize);
            this.tsFileResourceList.insertBefore((TsFileResource)this.selectedTsFileResourceList.get(0), (TsFileResource)targetTsFileResource);
            for (TsFileResource tsFileResource : this.selectedTsFileResourceList) {
                this.tsFileResourceList.remove((Object)tsFileResource);
            }
        }
        finally {
            CompactionTaskManager.getInstance().removeRunningTaskFromList((AbstractCompactionTask)this);
        }
    }

    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (otherTask instanceof FakedInnerSpaceCompactionTask) {
            FakedInnerSpaceCompactionTask fakedOtherTask = (FakedInnerSpaceCompactionTask)otherTask;
            return this.selectedTsFileResourceList.equals(fakedOtherTask.selectedTsFileResourceList);
        }
        return false;
    }

    public boolean checkValidAndSetMerging() {
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            if (!resource.isCompacting() && resource.isClosed()) continue;
            return false;
        }
        return true;
    }
}

