/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.util.List;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.RewriteCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.FakedTsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class FakedCrossSpaceCompactionTask
extends RewriteCrossSpaceCompactionTask {
    public FakedCrossSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartitionId, TsFileManager tsFileManager, List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) {
        super(logicalStorageGroupName, virtualStorageGroupName, timePartitionId, tsFileManager, selectedSeqTsFileResourceList, selectedUnSeqTsFileResourceList, CompactionTaskManager.currentTaskNum);
    }

    protected void doCompaction() {
        long totalUnseqFileSize = 0L;
        for (TsFileResource resource : this.selectedUnSeqTsFileResourceList) {
            totalUnseqFileSize += resource.getTsFileSize();
        }
        long avgSizeAddToSeqFile = totalUnseqFileSize / (long)this.selectedSeqTsFileResourceList.size();
        for (TsFileResource resource : this.selectedSeqTsFileResourceList) {
            ((FakedTsFileResource)resource).setTsFileSize(resource.getTsFileSize() + avgSizeAddToSeqFile);
        }
        this.selectedSeqTsFileResourceList.clear();
        this.selectedUnSeqTsFileResourceList.clear();
    }
}

