/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.recover;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeTieredCompactionRecoverTest {
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    static final String SEQ_FILE_DIR = TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "sequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
    static final String UNSEQ_FILE_DIR = TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "unsequence" + File.separator + "root.compactionTest" + File.separator + "0" + File.separator + "0";
    static final TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", TestConstant.BASE_OUTPUT_PATH);
    static final String[] fullPaths = new String[]{"root.compactionTest.device0.sensor0", "root.compactionTest.device0.sensor1", "root.compactionTest.device0.sensor2", "root.compactionTest.device0.sensor3", "root.compactionTest.device0.sensor4", "root.compactionTest.device0.sensor5", "root.compactionTest.device0.sensor6", "root.compactionTest.device0.sensor7", "root.compactionTest.device0.sensor8", "root.compactionTest.device0.sensor9", "root.compactionTest.device1.sensor0", "root.compactionTest.device1.sensor1", "root.compactionTest.device1.sensor2", "root.compactionTest.device1.sensor3", "root.compactionTest.device1.sensor4"};
    static final MeasurementSchema[] schemas = new MeasurementSchema[fullPaths.length];
    static String logFilePath = TestConstant.BASE_OUTPUT_PATH + File.separator + "test-compaction.compaction.log";
    static String[] originDataDirs = null;
    static String[] testDataDirs = new String[]{TestConstant.BASE_OUTPUT_PATH + "data"};
    static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Before
    public void setUp() throws Exception {
        IoTDB.metaManager.init();
        originDataDirs = config.getDataDirs();
        this.setDataDirs(testDataDirs);
        if (!new File(SEQ_FILE_DIR).exists()) {
            Assert.assertTrue((boolean)new File(SEQ_FILE_DIR).mkdirs());
        }
        if (!new File(UNSEQ_FILE_DIR).exists()) {
            Assert.assertTrue((boolean)new File(UNSEQ_FILE_DIR).mkdirs());
        }
        this.createTimeSeries();
    }

    @After
    public void tearDown() throws Exception {
        File logFile;
        new CompactionConfigRestorer().restoreCompactionConfig();
        this.setDataDirs(originDataDirs);
        IoTDB.metaManager.clear();
        File dataDir = new File(testDataDirs[0]);
        if (dataDir.exists()) {
            FileUtils.forceDelete((File)dataDir);
        }
        if ((logFile = new File(logFilePath)).exists()) {
            Assert.assertTrue((boolean)logFile.delete());
        }
        EnvironmentUtils.cleanEnv();
    }

    private void createTimeSeries() throws MetadataException {
        int i;
        PartialPath[] deviceIds = new PartialPath[fullPaths.length];
        for (i = 0; i < fullPaths.length; ++i) {
            SizeTieredCompactionRecoverTest.schemas[i] = new MeasurementSchema(fullPaths[i].split("\\.")[3], TSDataType.INT64, TSEncoding.RLE, CompressionType.UNCOMPRESSED);
            deviceIds[i] = new PartialPath(fullPaths[i].substring(0, 27));
        }
        IoTDB.metaManager.setStorageGroup(new PartialPath(COMPACTION_TEST_SG));
        for (i = 0; i < fullPaths.length; ++i) {
            MeasurementSchema schema = schemas[i];
            PartialPath deviceId = deviceIds[i];
            IoTDB.metaManager.createTimeseries(deviceId.concatNode(schema.getMeasurementId()), schema.getType(), schema.getEncodingType(), schema.getCompressor(), Collections.emptyMap());
        }
    }

    public void setDataDirs(String[] dataDirs) throws Exception {
        Class<?> configClass = config.getClass();
        Field dataDirsField = configClass.getDeclaredField("dataDirs");
        dataDirsField.setAccessible(true);
        dataDirsField.set(config, dataDirs);
    }

    @Test
    public void testRecoverWithUncorrectTimePartionDir() {
        try {
            File timePartitionDir = new File(SEQ_FILE_DIR);
            File f = new File(timePartitionDir.getParent() + File.separator + "test.tmp");
            f.createNewFile();
            new VirtualStorageGroupProcessor(TestConstant.BASE_OUTPUT_PATH + File.separator + "data" + File.separator + "sequence", "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), COMPACTION_TEST_SG);
        }
        catch (IOException | StorageGroupProcessorException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecoverWithCompleteTargetFileUsingFileInfo() throws Exception {
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        for (int i = 0; i < 10; ++i) {
            HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
            sourceFiles.add(tsFileResource);
        }
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        compactionLogger.close();
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithIncompleteTargetFileUsingFileInfo() throws Exception {
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        for (int i = 0; i < 10; ++i) {
            HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
            sourceFiles.add(tsFileResource);
        }
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        compactionLogger.close();
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithCompleteTargetFileUsingFilePath() throws Exception {
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        for (int i = 0; i < 10; ++i) {
            HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
            sourceFiles.add(tsFileResource);
        }
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger logger = new CompactionLogger(new File(logFilePath));
        logger.logFiles(sourceFiles, "source");
        logger.logFiles(Collections.singletonList(targetResource), "target");
        logger.close();
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    @Test
    public void testRecoverWithIncompleteTargetFileUsingFilePath() throws Exception {
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
        for (int i = 0; i < 10; ++i) {
            HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
            sourceFiles.add(tsFileResource);
        }
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
        CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
        compactionLogger.logFiles(sourceFiles, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        compactionLogger.close();
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
        FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
        FileChannel channel = targetStream.getChannel();
        channel.truncate(targetResource.getTsFile().length() - 100L);
        channel.close();
        CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
        recoverTask.doCompaction();
        for (TsFileResource resource : sourceFiles) {
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithCompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            ArrayList<String> sourceFileNames = new ArrayList<String>();
            for (int i = 0; i < 10; ++i) {
                HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                sourceFiles.add(tsFileResource);
                sourceFileNames.add(tsFileResource.getTsFile().getName());
            }
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
            InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
            long sizeOfTargetFile = targetResource.getTsFileSize();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[]{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithIncompleteTargetFileUsingFileInfoAndChangingDataDirs() throws Exception {
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            ArrayList<String> sourceFileNames = new ArrayList<String>();
            for (int i = 0; i < 10; ++i) {
                HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                sourceFiles.add(tsFileResource);
                sourceFileNames.add(tsFileResource.getTsFile().getName());
            }
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
            InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[]{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithCompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            ArrayList<String> sourceFileNames = new ArrayList<String>();
            for (int i = 0; i < 10; ++i) {
                HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                sourceFiles.add(tsFileResource);
                sourceFileNames.add(tsFileResource.getTsFile().getName());
            }
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
            InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
            long sizeOfTargetFile = targetResource.getTsFileSize();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[]{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            File targetFileAfterMoved = new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName().replace(".inner", ".tsfile"));
            Assert.assertFalse((boolean)targetFileAfterMoved.exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverWithIncompleteTargetFileUsingFilePathAndChangingDataDirs() throws Exception {
        try {
            ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>();
            ArrayList<String> sourceFileNames = new ArrayList<String>();
            for (int i = 0; i < 10; ++i) {
                HashSet<String> fullPath = new HashSet<String>(Arrays.asList(fullPaths));
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource tsFileResource = new TsFileResource(new File(SEQ_FILE_DIR + File.separator.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile")));
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                sourceFiles.add(tsFileResource);
                sourceFileNames.add(tsFileResource.getTsFile().getName());
            }
            TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(sourceFiles, (boolean)true);
            CompactionLogger compactionLogger = new CompactionLogger(new File(logFilePath));
            compactionLogger.logFiles(sourceFiles, "source");
            compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
            compactionLogger.close();
            InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, sourceFiles);
            InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)COMPACTION_TEST_SG);
            FileOutputStream targetStream = new FileOutputStream(targetResource.getTsFile(), true);
            FileChannel channel = targetStream.getChannel();
            channel.truncate(targetResource.getTsFile().length() - 100L);
            channel.close();
            FileUtils.moveDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data"), (File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
            this.setDataDirs(new String[]{TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"});
            CompactionRecoverTask recoverTask = new CompactionRecoverTask(COMPACTION_TEST_SG, "0", tsFileManager, new File(logFilePath), true);
            recoverTask.doCompaction();
            for (String sourceFileName : sourceFileNames) {
                Assert.assertTrue((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", sourceFileName).exists());
            }
            Assert.assertFalse((boolean)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1" + File.separator + "sequence" + File.separator + COMPACTION_TEST_SG + File.separator + "0" + File.separator + "0", targetResource.getTsFile().getName()).exists());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TestConstant.BASE_OUTPUT_PATH + File.separator + "data1"));
        }
    }
}

