/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTest;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.CompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.utils.Pair;
import org.h2.store.fs.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class InnerSpaceCompactionExceptionTest
extends AbstractInnerSpaceCompactionTest {
    @Test
    public void testWhenAllSourceExistsAndTargetNotComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        try (FileOutputStream os = new FileOutputStream(targetResource.getTsFile(), true);
             FileChannel channel = os.getChannel();){
            channel.truncate(targetResource.getTsFileSize() - 10L);
        }
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenAllSourceExistsAndTargetComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testWhenSomeSourceLostAndTargetComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        for (TsFileResource resource : this.seqResources) {
            this.tsFileManager.getSequenceListByTimePartition(0L).remove((Object)resource);
        }
        this.tsFileManager.getSequenceListByTimePartition(0L).keepOrderInsert(targetResource);
        FileUtils.delete((String)((TsFileResource)this.seqResources.get(0)).getTsFile().getPath());
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
        Assert.assertEquals((long)1L, (long)this.tsFileManager.getSequenceListByTimePartition(0L).size());
        Assert.assertEquals((Object)targetResource, (Object)this.tsFileManager.getSequenceListByTimePartition(0L).get(0));
    }

    @Test
    public void testWhenSomeSourceLostAndTargetNotComplete() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        try (FileOutputStream os = new FileOutputStream(targetResource.getTsFile(), true);
             FileChannel channel = os.getChannel();){
            channel.truncate(targetResource.getTsFileSize() - 10L);
        }
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
        }
        Assert.assertFalse((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithCompactionMods() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
        }
        InnerSpaceCompactionUtils.combineModsInCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertTrue((boolean)targetResource.getModFile().exists());
        Collection modifications = targetResource.getModFile().getModifications();
        Assert.assertEquals((long)this.seqResources.size(), (long)modifications.size());
        for (Modification modification : modifications) {
            Assert.assertEquals((Object)this.deviceIds[0], (Object)modification.getDevice());
            Assert.assertEquals((Object)this.measurementSchemas[0].getMeasurementId(), (Object)modification.getMeasurement());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)modification.getFileOffset());
        }
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithNormalMods() throws Exception {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        for (int i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        this.seqResources.remove(0);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.resourceFileExists());
            Assert.assertFalse((boolean)resource.getTsFile().exists());
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testHandleWithCompactionModsAndNormalMods() throws Exception {
        HashMap<String, Pair<Long, Long>> deleteMap;
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 5L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        InnerSpaceCompactionUtils.compact((TsFileResource)targetResource, (List)this.seqResources);
        InnerSpaceCompactionUtils.moveTargetFile((TsFileResource)targetResource, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            deleteMap = new HashMap();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), (Pair<Long, Long>)new Pair((Object)((long)i * this.ptNum + 10L), (Object)((long)i * this.ptNum + 15L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        compactionLogger.close();
        CompactionExceptionHandler.handleException((String)"root.compactionTest", (File)logFile, Collections.singletonList(targetResource), (List)this.seqResources, Collections.emptyList(), (TsFileManager)this.tsFileManager, (long)0L, (boolean)true, (boolean)true);
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((boolean)resource.resourceFileExists());
            Assert.assertTrue((boolean)resource.getTsFile().exists());
            Assert.assertTrue((boolean)resource.getModFile().exists());
            Assert.assertFalse((boolean)ModificationFile.getCompactionMods((TsFileResource)resource).exists());
            Collection modifications = resource.getModFile().getModifications();
            Assert.assertEquals((long)2L, (long)modifications.size());
            for (Modification modification : modifications) {
                Assert.assertEquals((Object)this.deviceIds[0], (Object)modification.getDevice());
                Assert.assertEquals((Object)this.measurementSchemas[0].getMeasurementId(), (Object)modification.getMeasurement());
                Assert.assertEquals((long)Long.MAX_VALUE, (long)modification.getFileOffset());
            }
        }
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }
}

